/*
 * Decompiled with CFR 0.152.
 */
package jcifs.internal.smb1.com;

import jcifs.Configuration;
import jcifs.internal.SMBProtocolDecodingException;
import jcifs.internal.smb1.AndXServerMessageBlock;
import jcifs.internal.smb1.com.LockingAndXRange;
import jcifs.internal.util.SMBUtil;

public class SmbComLockingAndX
extends AndXServerMessageBlock {
    private int fid;
    private byte typeOfLock;
    private byte newOpLockLevel;
    private long timeout;
    private LockingAndXRange[] locks;
    private LockingAndXRange[] unlocks;
    private boolean largeFile;

    public SmbComLockingAndX(Configuration config) {
        super(config);
    }

    @Override
    protected int writeParameterWordsWireFormat(byte[] dst, int dstIndex) {
        int start = dstIndex;
        SMBUtil.writeInt2(this.fid, dst, dstIndex);
        dst[dstIndex += 2] = this.typeOfLock;
        dst[dstIndex + 1] = this.newOpLockLevel;
        SMBUtil.writeInt4(this.timeout, dst, dstIndex += 2);
        SMBUtil.writeInt2(this.unlocks != null ? (long)this.unlocks.length : 0L, dst, dstIndex += 4);
        SMBUtil.writeInt2(this.locks != null ? (long)this.locks.length : 0L, dst, dstIndex += 2);
        return start - (dstIndex += 2);
    }

    @Override
    protected int readParameterWordsWireFormat(byte[] buffer, int bufferIndex) {
        int start = bufferIndex;
        this.fid = SMBUtil.readInt2(buffer, bufferIndex);
        this.typeOfLock = buffer[bufferIndex += 2];
        if ((this.typeOfLock & 0x10) == 16) {
            this.largeFile = true;
        }
        this.newOpLockLevel = buffer[bufferIndex + 1];
        this.timeout = SMBUtil.readInt4(buffer, bufferIndex += 2);
        int nunlocks = SMBUtil.readInt2(buffer, bufferIndex += 4);
        this.unlocks = new LockingAndXRange[nunlocks];
        int nlocks = SMBUtil.readInt2(buffer, bufferIndex += 2);
        this.locks = new LockingAndXRange[nlocks];
        return start - (bufferIndex += 2);
    }

    @Override
    protected int writeBytesWireFormat(byte[] dst, int dstIndex) {
        int start = dstIndex;
        if (this.unlocks != null) {
            for (LockingAndXRange lockingAndXRange : this.unlocks) {
                dstIndex += lockingAndXRange.encode(dst, dstIndex);
            }
        }
        if (this.locks != null) {
            for (LockingAndXRange lockingAndXRange : this.locks) {
                dstIndex += lockingAndXRange.encode(dst, dstIndex);
            }
        }
        return start - dstIndex;
    }

    @Override
    protected int readBytesWireFormat(byte[] buffer, int bufferIndex) throws SMBProtocolDecodingException {
        int i;
        int start = bufferIndex;
        for (i = 0; i < this.unlocks.length; ++i) {
            this.unlocks[i] = this.createLockRange();
            bufferIndex += this.unlocks[i].decode(buffer, bufferIndex, buffer.length);
        }
        for (i = 0; i < this.locks.length; ++i) {
            this.locks[i] = this.createLockRange();
            bufferIndex += this.locks[i].decode(buffer, bufferIndex, buffer.length);
        }
        return start - bufferIndex;
    }

    private LockingAndXRange createLockRange() {
        return new LockingAndXRange(this.largeFile);
    }

    @Override
    public String toString() {
        return new String("SmbComLockingAndX[" + super.toString() + ",fid=" + this.fid + ",typeOfLock=" + this.typeOfLock + ",newOplockLevel=" + this.newOpLockLevel + "]");
    }
}

