/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.config.poller;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentSkipListMap;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlTransient;
import org.opennms.netmgt.config.poller.Parameter;

@XmlRootElement(name="service")
@XmlAccessorType(value=XmlAccessType.NONE)
public class Service
implements Serializable {
    private static final long serialVersionUID = -8728008607550515715L;
    @XmlAttribute(name="name")
    private String m_name;
    @XmlAttribute(name="interval")
    private Long m_interval;
    @XmlAttribute(name="user-defined")
    private String m_userDefined = "false";
    @XmlAttribute(name="status")
    private String m_status = "on";
    @XmlElement(name="pattern")
    private String m_pattern = null;
    @XmlElement(name="parameter")
    private List<Parameter> m_parameters = new ArrayList<Parameter>();

    public Service() {
        this.setUserDefined("false");
        this.setStatus("on");
    }

    public Service(String name, long interval, String userDefined, String status, String ... parameters) {
        this();
        this.setName(name);
        this.setInterval(interval);
        this.setUserDefined(userDefined);
        this.setStatus(status);
        if (parameters != null && parameters.length > 0) {
            List<String> params = Arrays.asList(parameters);
            Iterator<String> paramIterator = params.iterator();
            while (paramIterator.hasNext()) {
                String key = paramIterator.next();
                if (!paramIterator.hasNext()) {
                    throw new IllegalArgumentException("Odd number of key/value pairs passed to new Service()!");
                }
                String value = paramIterator.next();
                this.addParameter(key, value);
            }
        }
    }

    public String getName() {
        return this.m_name;
    }

    public void setName(String name) {
        this.m_name = name;
    }

    public Long getInterval() {
        return this.m_interval == null ? 0L : this.m_interval;
    }

    public void setInterval(Long interval) {
        this.m_interval = interval;
    }

    @XmlTransient
    public void setInterval(Integer interval) {
        this.m_interval = interval == null ? null : Long.valueOf(interval.longValue());
    }

    public String getUserDefined() {
        return this.m_userDefined == null ? "false" : this.m_userDefined;
    }

    public void setUserDefined(String userDefined) {
        this.m_userDefined = userDefined;
    }

    public String getStatus() {
        return this.m_status == null ? "on" : this.m_status;
    }

    public void setStatus(String status) {
        this.m_status = status;
    }

    public String getPattern() {
        return this.m_pattern;
    }

    public void setPattern(String pattern) {
        this.m_pattern = pattern;
    }

    public List<Parameter> getParameters() {
        if (this.m_parameters == null) {
            return Collections.emptyList();
        }
        return Collections.unmodifiableList(this.m_parameters);
    }

    public Map<String, Object> getParameterMap() {
        ConcurrentSkipListMap<String, Object> m = new ConcurrentSkipListMap<String, Object>();
        for (Parameter p : this.getParameters()) {
            Object val = p.getValue();
            if (val == null) {
                val = p.getAnyObject() == null ? "" : p.getAnyObject();
            }
            m.put(p.getKey(), val);
        }
        return m;
    }

    public void setParameters(List<Parameter> parameters) {
        this.m_parameters = new ArrayList<Parameter>(parameters);
    }

    public void addParameter(Parameter parameter) throws IndexOutOfBoundsException {
        this.m_parameters.add(parameter);
    }

    public void addParameter(String key, String value) {
        this.m_parameters.add(new Parameter(key, value));
    }

    public boolean removeParameter(Parameter parameter) {
        return this.m_parameters.remove(parameter);
    }

    public Parameter getParameter(String key) {
        for (Parameter parameter : this.m_parameters) {
            if (!key.equals(parameter.getKey())) continue;
            return parameter;
        }
        return null;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof Service) {
            Service temp = (Service)obj;
            if (this.m_name != null) {
                if (temp.m_name == null) {
                    return false;
                }
                if (!this.m_name.equals(temp.m_name)) {
                    return false;
                }
            } else if (temp.m_name != null) {
                return false;
            }
            if (this.m_interval != null) {
                if (temp.m_interval == null) {
                    return false;
                }
                if (!this.m_interval.equals(temp.m_interval)) {
                    return false;
                }
            } else if (this.m_interval != null) {
                return false;
            }
            if (this.m_userDefined != null) {
                if (temp.m_userDefined == null) {
                    return false;
                }
                if (!this.m_userDefined.equals(temp.m_userDefined)) {
                    return false;
                }
            } else if (temp.m_userDefined != null) {
                return false;
            }
            if (this.m_status != null) {
                if (temp.m_status == null) {
                    return false;
                }
                if (!this.m_status.equals(temp.m_status)) {
                    return false;
                }
            } else if (temp.m_status != null) {
                return false;
            }
            if (this.m_parameters != null) {
                if (temp.m_parameters == null) {
                    return false;
                }
                if (!this.m_parameters.equals(temp.m_parameters)) {
                    return false;
                }
            } else if (temp.m_parameters != null) {
                return false;
            }
            return true;
        }
        return false;
    }

    public int hashCode() {
        int result = 17;
        if (this.m_name != null) {
            result = 37 * result + this.m_name.hashCode();
        }
        if (this.m_interval != null) {
            result = 37 * result + this.m_interval.hashCode();
        }
        if (this.m_userDefined != null) {
            result = 37 * result + this.m_userDefined.hashCode();
        }
        if (this.m_status != null) {
            result = 37 * result + this.m_status.hashCode();
        }
        if (this.m_parameters != null) {
            result = 37 * result + this.m_parameters.hashCode();
        }
        return result;
    }

    public String toString() {
        return "Service[name=" + this.m_name + ",interval=" + this.m_interval + ",userDefined=" + this.m_userDefined + ",status=" + this.m_status + ",parameters=" + this.m_parameters + "]";
    }
}

