/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.config.internal.collection;

import java.util.ArrayList;
import java.util.Arrays;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlTransient;
import org.opennms.netmgt.config.api.collection.IColumn;
import org.opennms.netmgt.config.api.collection.ITable;
import org.opennms.netmgt.config.internal.collection.ColumnImpl;
import org.opennms.netmgt.config.internal.collection.ResourceTypeImpl;

@XmlRootElement(name="table")
@XmlAccessorType(value=XmlAccessType.NONE)
public class TableImpl
implements ITable {
    @XmlAttribute(name="name")
    private String m_name;
    @XmlAttribute(name="instance")
    private String m_instance;
    @XmlElement(name="column")
    private ColumnImpl[] m_columns;
    @XmlTransient
    private ResourceTypeImpl m_resourceType;

    public TableImpl() {
    }

    public TableImpl(String name, String instance) {
        this.m_name = name;
        this.m_instance = instance;
    }

    @Override
    public String getName() {
        return this.m_name;
    }

    public void setName(String name) {
        this.m_name = name;
    }

    @Override
    public String getInstance() {
        return this.m_instance;
    }

    public void setInstance(String instance) {
        this.m_instance = instance;
    }

    @Override
    public IColumn[] getColumns() {
        return this.m_columns;
    }

    public void setColumns(IColumn[] columns) {
        this.m_columns = ColumnImpl.asColumns(columns);
    }

    public void addColumn(ColumnImpl column) {
        ArrayList<ColumnImpl> columns = this.m_columns == null ? new ArrayList<ColumnImpl>() : new ArrayList<ColumnImpl>(Arrays.asList(this.m_columns));
        columns.add(column);
        this.m_columns = columns.toArray(new ColumnImpl[columns.size()]);
    }

    public void addColumn(String oid, String alias, String type) {
        this.addColumn(new ColumnImpl(oid, alias, type));
    }

    public String toString() {
        return "TableImpl [name=" + this.m_name + ", instance=" + this.m_instance + ", columns=" + Arrays.toString(this.m_columns) + ", resourceType=" + this.m_resourceType + "]";
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + Arrays.hashCode(this.m_columns);
        result = 31 * result + (this.m_instance == null ? 0 : this.m_instance.hashCode());
        result = 31 * result + (this.m_name == null ? 0 : this.m_name.hashCode());
        result = 31 * result + (this.m_resourceType == null ? 0 : this.m_resourceType.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof TableImpl)) {
            return false;
        }
        TableImpl other = (TableImpl)obj;
        if (!Arrays.equals(this.m_columns, other.m_columns)) {
            return false;
        }
        if (this.m_instance == null ? other.m_instance != null : !this.m_instance.equals(other.m_instance)) {
            return false;
        }
        if (this.m_name == null ? other.m_name != null : !this.m_name.equals(other.m_name)) {
            return false;
        }
        return !(this.m_resourceType == null ? other.m_resourceType != null : !this.m_resourceType.equals(other.m_resourceType));
    }

    public static TableImpl asTable(ITable table) {
        if (table == null) {
            return null;
        }
        if (table instanceof TableImpl) {
            return (TableImpl)table;
        }
        TableImpl newTable = new TableImpl();
        newTable.setName(table.getName());
        newTable.setInstance(table.getInstance());
        newTable.setColumns(ColumnImpl.asColumns(table.getColumns()));
        return newTable;
    }

    public static TableImpl[] asTables(ITable[] tables) {
        if (tables == null) {
            return null;
        }
        TableImpl[] newTables = new TableImpl[tables.length];
        for (int i = 0; i < tables.length; ++i) {
            newTables[i] = TableImpl.asTable(tables[i]);
        }
        return newTables;
    }
}

