/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.config.datacollection;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import org.opennms.core.xml.ValidateUsing;
import org.opennms.netmgt.config.api.collection.IDataCollectionConfig;
import org.opennms.netmgt.config.datacollection.IncludeCollection;
import org.opennms.netmgt.config.datacollection.SnmpCollection;
import org.opennms.netmgt.config.internal.collection.DataCollectionConfigConverter;
import org.opennms.netmgt.config.internal.collection.DatacollectionConfigVisitor;

@XmlRootElement(name="datacollection-config", namespace="http://xmlns.opennms.org/xsd/config/datacollection")
@XmlAccessorType(value=XmlAccessType.NONE)
@ValidateUsing(value="datacollection-config.xsd")
public class DatacollectionConfig
implements Serializable {
    private static final long serialVersionUID = 8822093542080103175L;
    private static final List<IncludeCollection> EMPTY_INCLUDE_LIST = Collections.emptyList();
    @XmlAttribute(name="rrdRepository")
    private String m_rrdRepository;
    @XmlElement(name="snmp-collection")
    private List<SnmpCollection> m_snmpCollections = new ArrayList<SnmpCollection>();

    public String getRrdRepository() {
        return this.m_rrdRepository;
    }

    public void setRrdRepository(String rrdRepository) {
        this.m_rrdRepository = rrdRepository.intern();
    }

    public List<SnmpCollection> getSnmpCollections() {
        if (this.m_snmpCollections == null) {
            return Collections.emptyList();
        }
        return Collections.unmodifiableList(this.m_snmpCollections);
    }

    public void setSnmpCollections(List<SnmpCollection> snmpCollections) {
        this.m_snmpCollections = new ArrayList<SnmpCollection>(snmpCollections);
    }

    public SnmpCollection getSnmpCollection(String name) {
        for (SnmpCollection collection : this.m_snmpCollections) {
            if (!name.equals(collection.getName())) continue;
            return collection;
        }
        return null;
    }

    public void addSnmpCollection(SnmpCollection snmpCollection) throws IndexOutOfBoundsException {
        this.m_snmpCollections.add(snmpCollection);
    }

    public boolean removeSnmpCollection(SnmpCollection snmpCollection) {
        return this.m_snmpCollections.remove(snmpCollection);
    }

    public void insertSnmpCollection(SnmpCollection resourceTypeCollection) {
        this.m_snmpCollections.add(0, resourceTypeCollection);
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.m_rrdRepository == null ? 0 : this.m_rrdRepository.hashCode());
        result = 31 * result + (this.m_snmpCollections == null ? 0 : this.m_snmpCollections.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DatacollectionConfig)) {
            return false;
        }
        DatacollectionConfig other = (DatacollectionConfig)obj;
        if (this.m_rrdRepository == null ? other.m_rrdRepository != null : !this.m_rrdRepository.equals(other.m_rrdRepository)) {
            return false;
        }
        return !(this.m_snmpCollections == null ? other.m_snmpCollections != null : !this.m_snmpCollections.equals(other.m_snmpCollections));
    }

    public IDataCollectionConfig toDataCollectionConfig() {
        DatacollectionConfig modifiable = new DatacollectionConfig();
        modifiable.setRrdRepository(this.getRrdRepository());
        String resourceTypeName = "__resource_type_collection";
        SnmpCollection resourceTypeCollection = this.getSnmpCollection("__resource_type_collection");
        for (SnmpCollection collection : this.getSnmpCollections()) {
            if ("__resource_type_collection".equals(collection.getName())) continue;
            SnmpCollection cloned = collection.clone();
            cloned.setIncludeCollections(EMPTY_INCLUDE_LIST);
            if (resourceTypeCollection != null) {
                cloned.setResourceTypes(resourceTypeCollection.getResourceTypes());
            }
            modifiable.addSnmpCollection(cloned);
        }
        DataCollectionConfigConverter converter = new DataCollectionConfigConverter();
        modifiable.visit(converter);
        return converter.getDataCollectionConfig();
    }

    public String toString() {
        return "DatacollectionConfig [rrdRepository=" + this.m_rrdRepository + ", snmpCollections=" + this.m_snmpCollections + "]";
    }

    public void visit(DatacollectionConfigVisitor visitor) {
        visitor.visitDatacollectionConfig(this);
        for (SnmpCollection collection : this.m_snmpCollections) {
            collection.visit(visitor);
        }
        visitor.visitDatacollectionConfigComplete();
    }
}

