/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.newts.api.search;

import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import org.opennms.newts.api.Resource;

public class SearchResults
implements Iterable<Result> {
    private final List<Result> m_results = Lists.newArrayList();

    public void addResult(Resource resource, Collection<String> metrics) {
        this.m_results.add(new Result(resource, metrics));
    }

    public int size() {
        return this.m_results.size();
    }

    public boolean isEmpty() {
        return this.m_results.isEmpty();
    }

    @Override
    public Iterator<Result> iterator() {
        return this.m_results.iterator();
    }

    public static class Result {
        private final Resource m_resource;
        private final Collection<String> m_metrics;

        private Result(Resource resource, Collection<String> metrics) {
            this.m_resource = (Resource)Preconditions.checkNotNull((Object)resource, (Object)"resource argument");
            this.m_metrics = (Collection)Preconditions.checkNotNull(metrics, (Object)"metrics argument");
        }

        public Resource getResource() {
            return this.m_resource;
        }

        public Collection<String> getMetrics() {
            return this.m_metrics;
        }
    }
}

