/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.discovery;

import java.io.IOException;
import java.util.List;
import java.util.Objects;
import java.util.Timer;
import java.util.TimerTask;
import java.util.concurrent.CompletableFuture;
import org.opennms.netmgt.config.DiscoveryConfigFactory;
import org.opennms.netmgt.daemon.AbstractServiceDaemon;
import org.opennms.netmgt.discovery.DiscoveryTaskExecutor;
import org.opennms.netmgt.events.api.EventForwarder;
import org.opennms.netmgt.events.api.annotations.EventHandler;
import org.opennms.netmgt.events.api.annotations.EventListener;
import org.opennms.netmgt.events.api.model.IEvent;
import org.opennms.netmgt.events.api.model.IParm;
import org.opennms.netmgt.model.events.EventBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;

@EventListener(name="Discovery", logPrefix="discovery")
public class Discovery
extends AbstractServiceDaemon {
    private static final Logger LOG = LoggerFactory.getLogger(Discovery.class);
    protected static final String DAEMON_NAME = "Discovery";
    protected static final String LOG4J_CATEGORY = "discovery";
    @Autowired
    private DiscoveryConfigFactory m_discoveryFactory;
    @Autowired
    private DiscoveryTaskExecutor m_discoveryTaskExecutor;
    @Autowired
    @Qualifier(value="eventIpcManager")
    private EventForwarder m_eventForwarder;
    private Timer discoveryTimer;

    public Discovery() {
        super(LOG4J_CATEGORY);
    }

    protected void onInit() throws IllegalStateException {
        Objects.requireNonNull(this.m_eventForwarder, "must set the eventForwarder property");
        Objects.requireNonNull(this.m_discoveryTaskExecutor, "must set the discoveryTaskExecutor property");
        Objects.requireNonNull(this.m_discoveryFactory, "must set the discoveryFactory property");
        try {
            LOG.debug("Initializing configuration...");
            this.m_discoveryFactory.reload();
        }
        catch (Throwable e) {
            LOG.debug("onInit: initialization failed", e);
            throw new IllegalStateException("Could not initialize discovery configuration.", e);
        }
    }

    protected synchronized void onStart() {
        if (this.discoveryTimer != null) {
            LOG.warn("Discovery is already started.");
            return;
        }
        this.discoveryTimer = new Timer(DAEMON_NAME);
        this.discoveryTimer.schedule(new TimerTask(){

            @Override
            public void run() {
                LOG.info("Discovery triggered by timer.");
                try {
                    ((CompletableFuture)Discovery.this.m_discoveryTaskExecutor.handleDiscoveryTask(Discovery.this.m_discoveryFactory.getConfiguration()).whenComplete((result, ex) -> LOG.info("Discovery completed succesfully."))).join();
                }
                catch (Throwable t) {
                    LOG.error("Discovery failed. Will try again in {} ms", (Object)Discovery.this.m_discoveryFactory.getRestartSleepTime(), (Object)t);
                }
            }
        }, this.m_discoveryFactory.getInitialSleepTime(), this.m_discoveryFactory.getRestartSleepTime());
    }

    protected synchronized void onStop() {
        if (this.discoveryTimer == null) {
            LOG.warn("Discovery is already stopped.");
            return;
        }
        this.discoveryTimer.cancel();
        this.discoveryTimer = null;
    }

    protected void onPause() {
        this.onStop();
    }

    protected void onResume() {
        this.onStart();
    }

    @EventHandler(uei="uei.opennms.org/internal/discoveryConfigChange")
    public void handleDiscoveryConfigurationChanged(IEvent event) {
        LOG.info("handleDiscoveryConfigurationChanged: handling message that a change to configuration happened...");
        this.reloadAndReStart();
    }

    private void reloadAndReStart() {
        EventBuilder ebldr = null;
        try {
            this.m_discoveryFactory.reload();
            ebldr = new EventBuilder("uei.opennms.org/internal/reloadDaemonConfigSuccessful", this.getName());
            ebldr.addParam("daemonName", DAEMON_NAME);
            this.stop();
            this.start();
        }
        catch (IOException e) {
            LOG.error("Unable to initialize the discovery configuration factory", (Throwable)e);
            ebldr = new EventBuilder("uei.opennms.org/internal/reloadDaemonConfigFailed", this.getName());
            ebldr.addParam("daemonName", DAEMON_NAME);
            ebldr.addParam("reason", e.getLocalizedMessage().substring(0, 128));
        }
        this.m_eventForwarder.sendNow(ebldr.getEvent());
    }

    @EventHandler(uei="uei.opennms.org/internal/reloadDaemonConfig")
    public void reloadDaemonConfig(IEvent e) {
        LOG.info("reloadDaemonConfig: processing reload daemon event...");
        if (this.isReloadConfigEventTarget(e)) {
            this.reloadAndReStart();
        }
        LOG.info("reloadDaemonConfig: reload daemon event processed.");
    }

    private boolean isReloadConfigEventTarget(IEvent event) {
        boolean isTarget = false;
        List parmCollection = event.getParmCollection();
        for (IParm parm : parmCollection) {
            if (!"daemonName".equals(parm.getParmName()) || !DAEMON_NAME.equalsIgnoreCase(parm.getValue().getContent())) continue;
            isTarget = true;
            break;
        }
        LOG.debug("isReloadConfigEventTarget: discovery was target of reload event: {}", (Object)isTarget);
        return isTarget;
    }

    @EventHandler(uei="uei.opennms.org/internal/capsd/discResume")
    public void handleDiscoveryResume(IEvent event) {
        this.resume();
    }

    @EventHandler(uei="uei.opennms.org/internal/capsd/discPause")
    public void handleDiscoveryPause(IEvent event) {
        this.pause();
    }

    public static String getLoggingCategory() {
        return LOG4J_CATEGORY;
    }

    public void setEventForwarder(EventForwarder eventForwarder) {
        this.m_eventForwarder = eventForwarder;
    }

    public void setDiscoveryFactory(DiscoveryConfigFactory discoveryFactory) {
        this.m_discoveryFactory = discoveryFactory;
    }

    public void setDiscoveryTaskExecutor(DiscoveryTaskExecutor discoveryTaskExecutor) {
        this.m_discoveryTaskExecutor = discoveryTaskExecutor;
    }
}

