/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.telemetry.protocols.netflow.parser.transport;

import com.google.common.base.Strings;
import com.google.common.primitives.UnsignedLong;
import com.google.protobuf.DoubleValue;
import com.google.protobuf.UInt32Value;
import com.google.protobuf.UInt64Value;
import java.net.InetAddress;
import java.time.Instant;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Stream;
import org.opennms.netmgt.telemetry.protocols.netflow.parser.ie.Value;
import org.opennms.netmgt.telemetry.protocols.netflow.parser.ie.values.BooleanValue;
import org.opennms.netmgt.telemetry.protocols.netflow.parser.ie.values.DateTimeValue;
import org.opennms.netmgt.telemetry.protocols.netflow.parser.ie.values.IPv4AddressValue;
import org.opennms.netmgt.telemetry.protocols.netflow.parser.ie.values.IPv6AddressValue;
import org.opennms.netmgt.telemetry.protocols.netflow.parser.ie.values.UnsignedValue;

public interface MessageUtils {
    public static Long getLongValue(Value<?> value) {
        if (value instanceof UnsignedValue) {
            UnsignedLong unsignedValue = ((UnsignedValue)value).getValue();
            return unsignedValue.longValue();
        }
        return null;
    }

    public static Boolean getBooleanValue(Value<?> value) {
        if (value instanceof BooleanValue) {
            return ((BooleanValue)value).getValue();
        }
        return Boolean.FALSE;
    }

    public static InetAddress getInetAddress(Value<?> value) {
        if (value instanceof IPv4AddressValue) {
            return (InetAddress)value.getValue();
        }
        if (value instanceof IPv6AddressValue) {
            return (InetAddress)value.getValue();
        }
        return null;
    }

    public static Instant getTime(Value<?> value) {
        if (value instanceof DateTimeValue) {
            return ((DateTimeValue)value).getValue();
        }
        return null;
    }

    @SafeVarargs
    public static <V> Optional<V> first(V ... values) {
        return Stream.of(values).filter(Objects::nonNull).findFirst();
    }

    public static Optional<UInt64Value> getUInt64Value(Value<?> value) {
        Long longValue = MessageUtils.getLongValue(value);
        if (longValue != null) {
            return Optional.of(UInt64Value.newBuilder().setValue(longValue.longValue()).build());
        }
        return Optional.empty();
    }

    public static Optional<UInt64Value> getUInt64Value(Long value) {
        if (value != null) {
            return Optional.of(UInt64Value.newBuilder().setValue(value.longValue()).build());
        }
        return Optional.empty();
    }

    public static Optional<UInt32Value> getUInt32Value(Value<?> value) {
        Long longValue = MessageUtils.getLongValue(value);
        if (longValue != null) {
            return Optional.of(UInt32Value.newBuilder().setValue(longValue.intValue()).build());
        }
        return Optional.empty();
    }

    public static Optional<DoubleValue> getDoubleValue(Value<?> value) {
        Long longValue = MessageUtils.getLongValue(value);
        if (longValue != null) {
            return Optional.of(DoubleValue.newBuilder().setValue(longValue.doubleValue()).build());
        }
        return Optional.empty();
    }

    public static Optional<String> getString(String value) {
        if (!Strings.isNullOrEmpty((String)value)) {
            return Optional.of(value);
        }
        return Optional.empty();
    }

    public static UInt32Value setIntValue(int value) {
        return UInt32Value.newBuilder().setValue(value).build();
    }

    public static UInt64Value setLongValue(long value) {
        return UInt64Value.newBuilder().setValue(value).build();
    }

    public static DoubleValue setDoubleValue(double value) {
        return DoubleValue.newBuilder().setValue(value).build();
    }
}

