/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.telemetry.protocols.netflow.parser.netflow9.proto;

import com.google.common.base.MoreObjects;
import io.netty.buffer.ByteBuf;
import java.util.Optional;
import org.opennms.netmgt.telemetry.listeners.utils.BufferUtils;
import org.opennms.netmgt.telemetry.protocols.netflow.parser.InvalidPacketException;
import org.opennms.netmgt.telemetry.protocols.netflow.parser.MissingTemplateException;
import org.opennms.netmgt.telemetry.protocols.netflow.parser.Protocol;
import org.opennms.netmgt.telemetry.protocols.netflow.parser.ie.InformationElement;
import org.opennms.netmgt.telemetry.protocols.netflow.parser.ie.InformationElementDatabase;
import org.opennms.netmgt.telemetry.protocols.netflow.parser.ie.Value;
import org.opennms.netmgt.telemetry.protocols.netflow.parser.ie.values.UndeclaredValue;
import org.opennms.netmgt.telemetry.protocols.netflow.parser.session.Field;
import org.opennms.netmgt.telemetry.protocols.netflow.parser.session.Session;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class FieldSpecifier
implements Field {
    private static final Logger LOG = LoggerFactory.getLogger(FieldSpecifier.class);
    public static final int SIZE = 4;
    public final int fieldType;
    public final int fieldLength;
    public final InformationElement informationElement;

    public FieldSpecifier(ByteBuf buffer) throws InvalidPacketException {
        this.fieldType = BufferUtils.uint16((ByteBuf)buffer);
        this.fieldLength = BufferUtils.uint16((ByteBuf)buffer);
        this.informationElement = InformationElementDatabase.instance.lookup(Protocol.NETFLOW9, this.fieldType).orElseGet(() -> {
            LOG.warn("Undeclared field type: {}", (Object)UndeclaredValue.nameFor(Optional.empty(), this.fieldType));
            return UndeclaredValue.parser(this.fieldType);
        });
        if (this.fieldLength > this.informationElement.getMaximumFieldLength() || this.fieldLength < this.informationElement.getMinimumFieldLength()) {
            throw new InvalidPacketException(buffer, "Template field '%s' has illegal size: %d (min=%d, max=%d)", this.informationElement.getName(), this.fieldLength, this.informationElement.getMinimumFieldLength(), this.informationElement.getMaximumFieldLength());
        }
    }

    @Override
    public Value<?> parse(Session.Resolver resolver, ByteBuf buffer) throws InvalidPacketException, MissingTemplateException {
        try {
            return this.informationElement.parse(resolver, buffer);
        }
        catch (InvalidPacketException e) {
            throw new InvalidPacketException(e, "Failed to parse Netflow9 information element: fieldType=%d", this.fieldType);
        }
    }

    @Override
    public int length() {
        return this.fieldLength;
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("fieldType", this.fieldType).add("fieldLength", this.fieldLength).toString();
    }
}

