/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.features.topology.netutils.internal.ping;

import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import java.util.Objects;
import java.util.concurrent.TimeUnit;

public class PingRequest {
    private long timeout;
    private int packetSize;
    private int retries;
    private String ipAddress;
    private int numberRequests;
    private String location;

    public PingRequest withTimeout(long timeout, TimeUnit unit) {
        Preconditions.checkArgument((timeout > 0L ? 1 : 0) != 0, (Object)"timeout must be > 0");
        Objects.requireNonNull(unit);
        this.timeout = TimeUnit.MILLISECONDS.convert(timeout, unit);
        return this;
    }

    public PingRequest withPackageSize(int packageSize) {
        Preconditions.checkArgument((packageSize > 0 ? 1 : 0) != 0, (Object)"packetSize must be > 0");
        this.packetSize = packageSize;
        return this;
    }

    public PingRequest withRetries(int retries) {
        Preconditions.checkArgument((retries >= 0 ? 1 : 0) != 0, (Object)"retries must be >= 0");
        this.retries = retries;
        return this;
    }

    public PingRequest withIpAddress(String ipAddress) {
        this.ipAddress = Objects.requireNonNull(ipAddress);
        return this;
    }

    public PingRequest withNumberRequests(int numberRequests) {
        Preconditions.checkArgument((numberRequests > 0 ? 1 : 0) != 0, (Object)"number of requests must be > 0");
        this.numberRequests = numberRequests;
        return this;
    }

    public PingRequest withLocation(String location) {
        Preconditions.checkArgument((!Strings.isNullOrEmpty((String)location) ? 1 : 0) != 0, (Object)"Location must not be empty or null");
        this.location = location;
        return this;
    }

    public long getTimeout() {
        return this.timeout;
    }

    public int getPacketSize() {
        return this.packetSize;
    }

    public int getRetries() {
        return this.retries;
    }

    public String getIpAddress() {
        return this.ipAddress;
    }

    public int getNumberRequests() {
        return this.numberRequests;
    }

    public void setTimeout(long timeout) {
        this.timeout = timeout;
    }

    public void setPacketSize(int packetSize) {
        this.packetSize = packetSize;
    }

    public void setRetries(int retries) {
        this.retries = retries;
    }

    public void setIpAddress(String ipAddress) {
        this.ipAddress = ipAddress;
    }

    public void setNumberRequests(int numberRequests) {
        this.numberRequests = numberRequests;
    }

    public String getLocation() {
        return this.location;
    }

    public void setLocation(String location) {
        this.location = location;
    }
}

