/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.features.topology.plugins.topo.graphml.status;

import java.io.Serializable;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Collection;
import java.util.Map;
import java.util.Objects;
import javax.script.ScriptEngineManager;
import javax.script.SimpleBindings;
import org.opennms.features.topology.api.info.MeasurementsWrapper;
import org.opennms.features.topology.api.topo.AbstractVertex;
import org.opennms.features.topology.api.topo.BackendGraph;
import org.opennms.features.topology.api.topo.Criteria;
import org.opennms.features.topology.api.topo.EdgeRef;
import org.opennms.features.topology.api.topo.EdgeStatusProvider;
import org.opennms.features.topology.api.topo.Status;
import org.opennms.features.topology.api.topo.simple.SimpleConnector;
import org.opennms.features.topology.plugins.topo.graphml.GraphMLEdge;
import org.opennms.features.topology.plugins.topo.graphml.GraphMLTopologyProvider;
import org.opennms.features.topology.plugins.topo.graphml.internal.GraphMLServiceAccessor;
import org.opennms.features.topology.plugins.topo.graphml.internal.Scripting;
import org.opennms.features.topology.plugins.topo.graphml.status.GraphMLEdgeStatus;
import org.opennms.netmgt.model.OnmsNode;

public class GraphMLEdgeStatusProvider
implements EdgeStatusProvider {
    private final GraphMLTopologyProvider provider;
    private final GraphMLServiceAccessor serviceAccessor;
    private final Scripting<GraphMLEdge, GraphMLEdgeStatus> scripting;

    public GraphMLEdgeStatusProvider(GraphMLTopologyProvider provider, ScriptEngineManager scriptEngineManager, GraphMLServiceAccessor serviceAccessor, Path scriptPath) {
        this.provider = Objects.requireNonNull(provider);
        this.serviceAccessor = Objects.requireNonNull(serviceAccessor);
        this.scripting = new Scripting(scriptPath, scriptEngineManager, GraphMLEdgeStatus::new, GraphMLEdgeStatus::merge);
    }

    public GraphMLEdgeStatusProvider(GraphMLTopologyProvider provider, ScriptEngineManager scriptEngineManager, GraphMLServiceAccessor serviceAccessor) {
        this(provider, scriptEngineManager, serviceAccessor, Paths.get(System.getProperty("opennms.home"), "etc", "graphml-edge-status"));
    }

    public Map<? extends EdgeRef, ? extends Status> getStatusForEdges(BackendGraph graph, Collection<EdgeRef> edges, Criteria[] criteria) {
        return (Map)this.serviceAccessor.getTransactionOperations().execute(t -> this.scripting.compute(edges.stream().filter(edge -> edge instanceof GraphMLEdge).map(edge -> (GraphMLEdge)((Object)((Object)edge))), edge -> {
            SimpleBindings bindings = new SimpleBindings();
            bindings.put("edge", edge);
            bindings.put("sourceNode", (Object)this.getNodeForEdgeVertexConnector(edge.getSource()));
            bindings.put("targetNode", (Object)this.getNodeForEdgeVertexConnector(edge.getTarget()));
            bindings.put("measurements", (Object)new MeasurementsWrapper(this.serviceAccessor.getMeasurementsService()));
            bindings.put("nodeDao", (Object)this.serviceAccessor.getNodeDao());
            bindings.put("snmpInterfaceDao", (Object)this.serviceAccessor.getSnmpInterfaceDao());
            return bindings;
        }));
    }

    public String getNamespace() {
        return this.provider.getNamespace();
    }

    public boolean contributesTo(String namespace) {
        return this.getNamespace().equals(namespace);
    }

    private OnmsNode getNodeForEdgeVertexConnector(SimpleConnector simpleConnector) {
        AbstractVertex abstractVertex;
        if (simpleConnector != null && simpleConnector.getVertex() instanceof AbstractVertex && (abstractVertex = (AbstractVertex)simpleConnector.getVertex()).getNodeID() != null) {
            return (OnmsNode)this.serviceAccessor.getNodeDao().get((Serializable)abstractVertex.getNodeID());
        }
        return null;
    }
}

