/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.rtc.datablock;

import java.net.InetAddress;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.opennms.netmgt.rtc.NodeNotInCategoryException;
import org.opennms.netmgt.rtc.RTCUtils;
import org.opennms.netmgt.rtc.datablock.RTCNode;
import org.opennms.netmgt.rtc.datablock.RTCNodeKey;

public class RTCHashMap {
    private final Map<RTCNodeKey, List<RTCNode>> m_map;

    public RTCHashMap(int initialCapacity) {
        this.m_map = new HashMap<RTCNodeKey, List<RTCNode>>(initialCapacity);
    }

    private List<Integer> getNodeIDs() {
        LinkedList<Integer> nodes = new LinkedList<Integer>();
        for (RTCNodeKey key : this.m_map.keySet()) {
            nodes.add(key.getNodeID());
        }
        return nodes;
    }

    private void add(int nodeid, RTCNode rtcN) {
        RTCNodeKey key = new RTCNodeKey(nodeid, null, null);
        List<RTCNode> nodesList = this.m_map.get(key);
        if (nodesList != null) {
            nodesList.add(rtcN);
        } else {
            nodesList = new ArrayList<RTCNode>();
            nodesList.add(rtcN);
            this.m_map.put(key, nodesList);
        }
    }

    private void add(int nodeid, InetAddress inetAddress, RTCNode rtcN) {
        RTCNodeKey key = new RTCNodeKey(nodeid, inetAddress, null);
        List<RTCNode> nodesList = this.m_map.get(key);
        if (nodesList != null) {
            nodesList.add(rtcN);
        } else {
            nodesList = new ArrayList<RTCNode>();
            nodesList.add(rtcN);
            this.m_map.put(key, nodesList);
        }
    }

    private void add(int nodeid, InetAddress ip, String svcName, RTCNode rtcN) {
        this.m_map.put(new RTCNodeKey(nodeid, ip, svcName), Collections.singletonList(rtcN));
    }

    public void add(RTCNode rtcN) {
        this.add(rtcN.getNodeID(), rtcN);
        this.add(rtcN.getNodeID(), rtcN.getIP(), rtcN);
        this.add(rtcN.getNodeID(), rtcN.getIP(), rtcN.getSvcName(), rtcN);
    }

    public void delete(RTCNode rtcN) {
        this.delete(rtcN.getNodeID(), rtcN);
        this.delete(rtcN.getNodeID(), rtcN.getIP(), rtcN);
        this.delete(rtcN.getNodeID(), rtcN.getIP(), rtcN.getSvcName(), rtcN);
    }

    private void delete(int nodeid, RTCNode rtcN) {
        RTCNodeKey key = new RTCNodeKey(nodeid, null, null);
        List<RTCNode> nodesList = this.m_map.get(key);
        if (nodesList != null) {
            nodesList.remove(rtcN);
        }
    }

    private void delete(int nodeid, InetAddress inetAddress, RTCNode rtcN) {
        RTCNodeKey key = new RTCNodeKey(nodeid, inetAddress, null);
        List<RTCNode> nodesList = this.m_map.get(key);
        if (nodesList != null) {
            nodesList.remove(rtcN);
        }
    }

    private void delete(int nodeid, InetAddress ip, String svcName, RTCNode rtcN) {
        RTCNodeKey key = new RTCNodeKey(nodeid, ip, svcName);
        this.m_map.remove(key);
    }

    public double getValue(String catLabel, long curTime, long rollingWindow) {
        double outageTime = 0.0;
        int count = 0;
        for (Integer key : this.getNodeIDs()) {
            List<RTCNode> valList = this.getRTCNodes(key);
            if (valList == null || valList.size() == 0) continue;
            for (RTCNode node : valList) {
                try {
                    long downTime = node.getDownTime(catLabel, curTime, rollingWindow);
                    ++count;
                    outageTime += (double)downTime;
                }
                catch (NodeNotInCategoryException e) {}
            }
        }
        return RTCUtils.getOutagePercentage(outageTime, rollingWindow, count);
    }

    public double getValue(int nodeid, String catLabel, long curTime, long rollingWindow) {
        double outageTime = 0.0;
        int count = 0;
        for (RTCNode node : this.getRTCNodes(nodeid)) {
            if (node.getNodeID() != nodeid) continue;
            try {
                long downTime = node.getDownTime(catLabel, curTime, rollingWindow);
                ++count;
                outageTime += (double)downTime;
            }
            catch (NodeNotInCategoryException e) {}
        }
        return RTCUtils.getOutagePercentage(outageTime, rollingWindow, count);
    }

    public int getServiceCount(int nodeid, String catLabel) {
        int count = 0;
        for (RTCNode node : this.getRTCNodes(nodeid)) {
            if (!node.belongsTo(catLabel)) continue;
            ++count;
        }
        return count;
    }

    public int getServiceDownCount(int nodeid, String catLabel) {
        int count = 0;
        for (RTCNode node : this.getRTCNodes(nodeid)) {
            if (!node.belongsTo(catLabel) || !node.isServiceCurrentlyDown()) continue;
            ++count;
        }
        return count;
    }

    public RTCNode getRTCNode(RTCNodeKey key) {
        List<RTCNode> nodes = this.m_map.get(key);
        if (nodes == null) {
            return null;
        }
        if (nodes.size() != 1) {
            throw new IllegalStateException("Could not find single RTCNode that matched key: " + key.toString());
        }
        return nodes.get(0);
    }

    public List<RTCNode> getRTCNodes(int nodeid) {
        RTCNodeKey key = new RTCNodeKey(nodeid, null, null);
        List<RTCNode> nodes = this.m_map.get(key);
        if (nodes == null) {
            return Collections.emptyList();
        }
        return Collections.unmodifiableList(nodes);
    }

    public List<RTCNode> getRTCNodes(int nodeid, InetAddress ip) {
        RTCNodeKey key = new RTCNodeKey(nodeid, ip, null);
        List<RTCNode> nodes = this.m_map.get(key);
        if (nodes == null) {
            return Collections.emptyList();
        }
        return Collections.unmodifiableList(nodes);
    }

    public void deleteNode(int nodeid) {
        for (RTCNode node : new ArrayList<RTCNode>(this.getRTCNodes(nodeid))) {
            this.delete(node);
        }
    }
}

