/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.poller.monitors;

import com.google.common.base.Strings;
import java.net.InetAddress;
import java.util.Map;
import java.util.TreeMap;
import org.opennms.core.utils.InetAddressUtils;
import org.opennms.core.utils.ParameterMap;
import org.opennms.core.utils.TimeoutTracker;
import org.opennms.netmgt.poller.MonitoredService;
import org.opennms.netmgt.poller.PollStatus;
import org.opennms.netmgt.poller.monitors.SnmpMonitorStrategy;
import org.opennms.netmgt.snmp.CollectionTracker;
import org.opennms.netmgt.snmp.RowCallback;
import org.opennms.netmgt.snmp.SnmpAgentConfig;
import org.opennms.netmgt.snmp.SnmpObjId;
import org.opennms.netmgt.snmp.SnmpRowResult;
import org.opennms.netmgt.snmp.SnmpUtils;
import org.opennms.netmgt.snmp.SnmpValue;
import org.opennms.netmgt.snmp.SnmpWalker;
import org.opennms.netmgt.snmp.TableTracker;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PtpMonitor
extends SnmpMonitorStrategy {
    private static final Logger LOG = LoggerFactory.getLogger(PtpMonitor.class);
    private final SnmpObjId CLOCKPORT_OID = SnmpObjId.get((String)".1.3.6.1.2.1.241.1.2.9.1.5.90");
    private final SnmpObjId PORTSTATE_OID = SnmpObjId.get((String)".1.3.6.1.2.1.241.1.2.9.1.6.90");
    private static final int DEFAULT_RETRY = 0;
    public static final int DEFAULT_TIMEOUT = 3000;

    public PollStatus poll(MonitoredService svc, Map<String, Object> parameters) {
        State desiredPortState;
        TimeoutTracker tracker = new TimeoutTracker(parameters, 0, 3000);
        PollStatus ps = PollStatus.unavailable();
        InetAddress inetAddress = svc.getAddress();
        SnmpAgentConfig snmpAgentConfig = this.getAgentConfig(svc, parameters);
        String hostAddress = InetAddressUtils.str((InetAddress)inetAddress);
        String watchedClockPort = ParameterMap.getKeyedString(parameters, (String)"clock-port", (String)"");
        String desiredPortStateString = ParameterMap.getKeyedString(parameters, (String)"port-state", (String)"").toLowerCase();
        if (Strings.isNullOrEmpty((String)watchedClockPort)) {
            LOG.debug("Missing required parameter: clock-port");
            return PollStatus.unknown("Missing required parameter: clock-port");
        }
        if (Strings.isNullOrEmpty((String)desiredPortStateString)) {
            LOG.debug("Missing required parameter: port-state");
            return PollStatus.unknown("Missing required parameter: port-state");
        }
        try {
            desiredPortState = State.valueOf(desiredPortStateString);
        }
        catch (IllegalArgumentException e) {
            LOG.debug("Unknown port state: " + desiredPortStateString, (Throwable)e);
            return PollStatus.unknown("Unknown port state: " + desiredPortStateString);
        }
        tracker.reset();
        while (tracker.shouldRetry() && !ps.isAvailable()) {
            block19: {
                tracker.startAttempt();
                final TreeMap portStates = new TreeMap(String.CASE_INSENSITIVE_ORDER);
                RowCallback rowCallback = new RowCallback(){

                    public void rowCompleted(SnmpRowResult result) {
                        SnmpValue clockPort = result.getValue(PtpMonitor.this.CLOCKPORT_OID);
                        SnmpValue portState = result.getValue(PtpMonitor.this.PORTSTATE_OID);
                        if (clockPort != null && portState != null) {
                            portStates.put(clockPort.toDisplayString(), State.get(portState.toInt()));
                        }
                    }
                };
                TableTracker tableTracker = new TableTracker(rowCallback, new SnmpObjId[]{this.CLOCKPORT_OID, this.PORTSTATE_OID});
                try {
                    block18: {
                        try (SnmpWalker snmpWalker = SnmpUtils.createWalker((SnmpAgentConfig)snmpAgentConfig, (String)"ptpPortState", (CollectionTracker)tableTracker);){
                            snmpWalker.start();
                            snmpWalker.waitFor();
                            String errorMessage = snmpWalker.getErrorMessage();
                            if (errorMessage == null || errorMessage.trim().isEmpty()) break block18;
                            ps = PollStatus.unavailable(errorMessage);
                            break block19;
                        }
                    }
                    if (!portStates.containsKey(watchedClockPort)) {
                        ps = PollStatus.unknown("Unknown clock-port: " + watchedClockPort);
                    } else {
                        State reportedPortState = (State)((Object)portStates.get(watchedClockPort));
                        if (reportedPortState == null) {
                            ps = PollStatus.unknown("Cannot determine port-state for given clock-port");
                        } else {
                            if (reportedPortState.equals((Object)desiredPortState)) {
                                return PollStatus.up(tracker.elapsedTimeInMillis());
                            }
                            ps = PollStatus.down("State '" + reportedPortState + "' for clock-port " + watchedClockPort + " does not match state '" + desiredPortState + "'");
                        }
                    }
                }
                catch (Throwable t) {
                    String reason = "Unexpected exception during SNMP poll of interface " + hostAddress;
                    LOG.debug(reason, t);
                    ps = PollStatus.down(reason);
                }
            }
            tracker.nextAttempt();
        }
        return ps;
    }

    private static enum State {
        initializing(1),
        faulty(2),
        disabled(3),
        listening(4),
        preMaster(5),
        master(6),
        passive(7),
        uncalibrated(8),
        slave(9);

        private final int value;

        private State(int value) {
            this.value = value;
        }

        public static State get(int value) {
            for (State state : State.values()) {
                if (value != state.value) continue;
                return state;
            }
            return null;
        }
    }
}

