/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.notifd;

import java.util.List;
import org.opennms.javamail.JavaMailer;
import org.opennms.javamail.JavaMailerException;
import org.opennms.netmgt.model.notifd.Argument;
import org.opennms.netmgt.model.notifd.NotificationStrategy;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JavaMailNotificationStrategy
implements NotificationStrategy {
    private static final Logger LOG = LoggerFactory.getLogger(JavaMailNotificationStrategy.class);

    public int send(List<Argument> arguments) {
        LOG.debug("In the JavaMailNotification class.");
        try {
            JavaMailer jm = this.buildMessage(arguments);
            jm.mailSend();
        }
        catch (JavaMailerException e) {
            LOG.error("send: Error sending notification.", (Throwable)e);
            return 1;
        }
        return 0;
    }

    private JavaMailer buildMessage(List<Argument> arguments) throws JavaMailerException {
        JavaMailer jm = new JavaMailer();
        for (int i = 0; i < arguments.size(); ++i) {
            Argument arg = arguments.get(i);
            LOG.debug("Current arg switch: {} of {} is: {}", new Object[]{i, arguments.size(), arg.getSwitch()});
            LOG.debug("Current arg  value: {} of {} is: {}", new Object[]{i, arguments.size(), arg.getValue()});
            if ("-email".equals(arg.getSwitch())) {
                LOG.debug("Found: PARAM_EMAIL");
                jm.setTo(arg.getValue());
                continue;
            }
            if ("-pemail".equals(arg.getSwitch())) {
                LOG.debug("Found: PARAM_PAGER_EMAIL");
                jm.setTo(arg.getValue());
                continue;
            }
            if ("-subject".equals(arg.getSwitch())) {
                LOG.debug("Found: PARAM_SUBJECT");
                jm.setSubject(arg.getValue());
                continue;
            }
            if ("-nm".equals(arg.getSwitch())) {
                LOG.debug("Found: PARAM_NUM_MSG");
                jm.setMessageText(arg.getValue());
                continue;
            }
            if (!"-tm".equals(arg.getSwitch())) continue;
            LOG.debug("Found: PARAM_TEXT_MSG");
            jm.setMessageText(arg.getValue());
        }
        return jm;
    }
}

