/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.collectd.jmx;

import java.net.InetAddress;
import java.util.List;
import java.util.concurrent.ThreadPoolExecutor;
import javax.management.openmbean.CompositeData;
import javax.management.openmbean.CompositeDataSupport;
import javax.management.openmbean.CompositeType;
import javax.management.openmbean.OpenDataException;
import javax.management.openmbean.OpenType;
import javax.management.openmbean.SimpleType;
import javax.management.openmbean.TabularData;
import javax.management.openmbean.TabularDataSupport;
import javax.management.openmbean.TabularType;
import org.opennms.core.utils.InetAddressUtils;
import org.opennms.netmgt.collectd.CollectableService;
import org.opennms.netmgt.collectd.jmx.CollectdMBean;
import org.opennms.netmgt.daemon.AbstractSpringContextJmxServiceDaemon;
import org.opennms.netmgt.scheduler.LegacyScheduler;

public class Collectd
extends AbstractSpringContextJmxServiceDaemon<org.opennms.netmgt.collectd.Collectd>
implements CollectdMBean {
    private static final String[] SCHEDULE_ITEMS = new String[]{"nodeId", "ipAddress", "package", "service", "intervalMs", "lastRunMs", "nextRunMs", "lastRunAbsoluteMs", "nextRunAbsoluteMs"};
    private static final String[] SCHEDULE_DESCS = new String[]{"nodeId", "ipAddress", "package", "service", "intervalMs", "lastRunMs", "nextRunMs", "lastRunAbsoluteMs", "nextRunAbsoluteMs"};
    private static final OpenType<?>[] SCHEDULE_TYPES = new OpenType[]{SimpleType.INTEGER, SimpleType.STRING, SimpleType.STRING, SimpleType.STRING, SimpleType.LONG, SimpleType.LONG, SimpleType.LONG, SimpleType.LONG, SimpleType.LONG};
    public static final CompositeType SCHEDULE_COMPOSITE_TYPE;
    public static final TabularType SCHEDULE_TABULAR_TYPE;

    protected String getLoggingPrefix() {
        return org.opennms.netmgt.collectd.Collectd.getLoggingCategory();
    }

    protected String getSpringContext() {
        return "collectdContext";
    }

    @Override
    public long getActiveThreads() {
        if (this.getThreadPoolStatsStatus()) {
            return this.getExecutor().getActiveCount();
        }
        return 0L;
    }

    @Override
    public long getTasksTotal() {
        if (this.getThreadPoolStatsStatus()) {
            return this.getExecutor().getTaskCount();
        }
        return 0L;
    }

    @Override
    public long getTasksCompleted() {
        if (this.getThreadPoolStatsStatus()) {
            return this.getExecutor().getCompletedTaskCount();
        }
        return 0L;
    }

    @Override
    public double getTaskCompletionRatio() {
        if (this.getThreadPoolStatsStatus()) {
            if (this.getExecutor().getTaskCount() > 0L) {
                return new Double((double)this.getExecutor().getCompletedTaskCount() / new Double(this.getExecutor().getTaskCount()));
            }
            return 0.0;
        }
        return 0.0;
    }

    @Override
    public long getNumPoolThreads() {
        if (this.getThreadPoolStatsStatus()) {
            return this.getExecutor().getPoolSize();
        }
        return 0L;
    }

    @Override
    public long getCorePoolThreads() {
        if (this.getThreadPoolStatsStatus()) {
            return this.getExecutor().getCorePoolSize();
        }
        return 0L;
    }

    @Override
    public long getMaxPoolThreads() {
        if (this.getThreadPoolStatsStatus()) {
            return this.getExecutor().getMaximumPoolSize();
        }
        return 0L;
    }

    @Override
    public long getPeakPoolThreads() {
        if (this.getThreadPoolStatsStatus()) {
            return this.getExecutor().getLargestPoolSize();
        }
        return 0L;
    }

    @Override
    public long getTaskQueuePendingCount() {
        if (this.getThreadPoolStatsStatus()) {
            return this.getExecutor().getQueue().size();
        }
        return 0L;
    }

    @Override
    public long getTaskQueueRemainingCapacity() {
        if (this.getThreadPoolStatsStatus()) {
            return this.getExecutor().getQueue().remainingCapacity();
        }
        return 0L;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public TabularData getSchedule() throws OpenDataException {
        List<CollectableService> collectableServiceList;
        long currentTimeMs = System.currentTimeMillis();
        TabularDataSupport tabularData = new TabularDataSupport(SCHEDULE_TABULAR_TYPE);
        List<CollectableService> list = collectableServiceList = ((org.opennms.netmgt.collectd.Collectd)this.getDaemon()).getCollectableServices();
        synchronized (list) {
            CompositeData[] compositeData = (CompositeDataSupport[])collectableServiceList.stream().map(c -> {
                try {
                    long timeLeftMs;
                    String ipAddress = InetAddressUtils.str((InetAddress)c.getAddress());
                    String pkg = c.getPackageName();
                    String service = c.getServiceName();
                    int nodeId = c.getNodeId();
                    long intervalMs = c.getSpecification().getInterval();
                    long lastRunAbsolute = c.getLastScheduledCollectionTime();
                    long lastRunMs = lastRunAbsolute - currentTimeMs;
                    long nextRunMs = timeLeftMs = c.getSpecification().getInterval() - (currentTimeMs - lastRunAbsolute);
                    long nextRunAbsolute = lastRunAbsolute + timeLeftMs;
                    return new CompositeDataSupport(SCHEDULE_COMPOSITE_TYPE, SCHEDULE_ITEMS, new Object[]{nodeId, ipAddress, pkg, service, intervalMs, lastRunMs, nextRunMs, lastRunAbsolute, nextRunAbsolute});
                }
                catch (OpenDataException e) {
                    throw new RuntimeException(e);
                }
            }).toArray(CompositeDataSupport[]::new);
            tabularData.putAll(compositeData);
            return tabularData;
        }
    }

    @Override
    public long getCollectableServiceCount() {
        return ((org.opennms.netmgt.collectd.Collectd)this.getDaemon()).getCollectableServiceCount();
    }

    private ThreadPoolExecutor getExecutor() {
        return (ThreadPoolExecutor)((LegacyScheduler)((org.opennms.netmgt.collectd.Collectd)this.getDaemon()).getScheduler()).getRunner();
    }

    private boolean getThreadPoolStatsStatus() {
        return ((org.opennms.netmgt.collectd.Collectd)this.getDaemon()).getScheduler() instanceof LegacyScheduler;
    }

    static {
        try {
            SCHEDULE_COMPOSITE_TYPE = new CompositeType("Collectable Service", "Scheduled Collectable Services", SCHEDULE_ITEMS, SCHEDULE_DESCS, SCHEDULE_TYPES);
            SCHEDULE_TABULAR_TYPE = new TabularType("Collectable Services", "Scheduled Collectable Service", SCHEDULE_COMPOSITE_TYPE, new String[]{"nodeId", "ipAddress", "package", "service"});
        }
        catch (OpenDataException e) {
            throw new RuntimeException(e);
        }
    }
}

