/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.collectd;

import com.google.common.base.Strings;
import java.util.LinkedHashSet;
import java.util.Set;
import org.opennms.netmgt.collectd.DefaultSnmpCollectionAgentService;
import org.opennms.netmgt.collectd.IfInfo;
import org.opennms.netmgt.collectd.IfResourceType;
import org.opennms.netmgt.collectd.SnmpCollectionAgent;
import org.opennms.netmgt.collectd.SnmpCollectionAgentService;
import org.opennms.netmgt.collectd.SnmpIfData;
import org.opennms.netmgt.collection.api.CollectionAgentService;
import org.opennms.netmgt.collection.api.CollectionInitializationException;
import org.opennms.netmgt.collection.core.DefaultCollectionAgent;
import org.opennms.netmgt.config.SnmpPeerFactory;
import org.opennms.netmgt.dao.api.IpInterfaceDao;
import org.opennms.netmgt.model.PrimaryType;
import org.opennms.netmgt.snmp.SnmpAgentConfig;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.transaction.PlatformTransactionManager;

public class DefaultSnmpCollectionAgent
extends DefaultCollectionAgent
implements SnmpCollectionAgent {
    private static final Logger LOG = LoggerFactory.getLogger(DefaultSnmpCollectionAgent.class);
    private int m_ifCount = -1;
    private int m_ifIndex = -1;
    private PrimaryType m_isSnmpPrimary = null;
    private String m_sysObjId = null;
    private Set<SnmpIfData> m_snmpIfData;

    public static SnmpCollectionAgent create(Integer ifaceId, IpInterfaceDao ifaceDao, PlatformTransactionManager transMgr) {
        return new DefaultSnmpCollectionAgent(DefaultSnmpCollectionAgentService.create(ifaceId, ifaceDao, transMgr));
    }

    public static SnmpCollectionAgent create(Integer ifaceId, IpInterfaceDao ifaceDao, PlatformTransactionManager transMgr, String location) {
        return new DefaultSnmpCollectionAgent(DefaultSnmpCollectionAgentService.create(ifaceId, ifaceDao, transMgr), location);
    }

    private DefaultSnmpCollectionAgent(SnmpCollectionAgentService agentService) {
        this(agentService, null);
    }

    protected DefaultSnmpCollectionAgent(SnmpCollectionAgentService agentService, String location) {
        super((CollectionAgentService)agentService, location);
        if (Boolean.getBoolean("org.opennms.netmgt.collectd.DefaultCollectionAgent.loadSnmpDataOnInit")) {
            this.getSnmpInterfaceData();
        }
    }

    @Override
    public void setSavedIfCount(int ifCount) {
        this.m_ifCount = ifCount;
    }

    @Override
    public int getSavedIfCount() {
        return this.m_ifCount;
    }

    private int getIfIndex() {
        if (this.m_ifIndex == -1) {
            this.m_ifIndex = ((SnmpCollectionAgentService)this.m_agentService).getIfIndex();
        }
        return this.m_ifIndex;
    }

    @Override
    public String getSysObjectId() {
        if (this.m_sysObjId == null) {
            this.m_sysObjId = ((SnmpCollectionAgentService)this.m_agentService).getSysObjectId();
            this.m_sysObjId = this.m_sysObjId == null ? null : this.m_sysObjId.intern();
        }
        return this.m_sysObjId;
    }

    private PrimaryType getIsSnmpPrimary() {
        if (this.m_isSnmpPrimary == null) {
            this.m_isSnmpPrimary = ((SnmpCollectionAgentService)this.m_agentService).getIsSnmpPrimary();
        }
        return this.m_isSnmpPrimary;
    }

    protected void logCompletion() {
        LOG.debug("initialize: initialization completed: nodeid = {}, address = {}, primaryIfIndex = {}, isSnmpPrimary = {}, sysoid = {}", new Object[]{this.getNodeId(), this.getHostAddress(), this.getIfIndex(), this.getIsSnmpPrimary(), this.getSysObjectId()});
    }

    private void validateSysObjId() throws CollectionInitializationException {
        if (this.getSysObjectId() == null) {
            throw new CollectionInitializationException("System Object ID for interface " + this.getHostAddress() + " does not exist in the database.");
        }
    }

    protected void logCollectionParms() {
        LOG.debug("initialize: db retrieval info: nodeid = {}, address = {}, primaryIfIndex = {}, isSnmpPrimary = {}, sysoid = {}", new Object[]{this.getNodeId(), this.getHostAddress(), this.getIfIndex(), this.getIsSnmpPrimary(), this.getSysObjectId()});
    }

    private void validateIsSnmpPrimary() throws CollectionInitializationException {
        if (!PrimaryType.PRIMARY.equals((Object)this.getIsSnmpPrimary())) {
            throw new CollectionInitializationException("Interface " + this.getHostAddress() + " is not the primary SNMP interface for nodeid " + this.getNodeId());
        }
    }

    private void validatePrimaryIfIndex() {
        if (this.getIfIndex() < 0) {
            LOG.debug("initialize: db retrieval info: node {} does not have a legitimate primaryIfIndex.  Assume node does not supply ipAddrTable and continue...", (Object)this.getNodeId());
        }
    }

    @Override
    public void validateAgent() throws CollectionInitializationException {
        this.logCollectionParms();
        this.validateIsSnmpPrimary();
        this.validatePrimaryIfIndex();
        this.validateSysObjId();
        this.logCompletion();
    }

    public SnmpAgentConfig getAgentConfig() {
        return SnmpPeerFactory.getInstance().getAgentConfig(this.getAddress(), this.getLocationName());
    }

    private Set<SnmpIfData> getSnmpInterfaceData() {
        if (this.m_snmpIfData == null) {
            this.m_snmpIfData = ((SnmpCollectionAgentService)this.m_agentService).getSnmpInterfaceData();
        }
        return this.m_snmpIfData;
    }

    @Override
    public Set<IfInfo> getSnmpInterfaceInfo(IfResourceType type) {
        Set<SnmpIfData> snmpIfData = this.getSnmpInterfaceData();
        LinkedHashSet<IfInfo> ifInfos = new LinkedHashSet<IfInfo>(snmpIfData.size());
        for (SnmpIfData ifData : snmpIfData) {
            if (Strings.isNullOrEmpty((String)ifData.getLabelForRRD())) {
                LOG.warn("Unable to compute resource index for interface: {}. Associated metrics will not be added to the CollectionSet and will not be considered for persistence,thresholding or other processing.", (Object)ifData);
                continue;
            }
            ifInfos.add(new IfInfo(type, this, ifData));
        }
        return ifInfos;
    }

    public String getSnmpInterfaceLabel(int ifIndex) {
        for (SnmpIfData ifData : this.getSnmpInterfaceData()) {
            if (ifData.getIfIndex() != ifIndex) continue;
            return ifData.getLabelForRRD();
        }
        return null;
    }
}

