/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.alarmd.api.support;

import java.io.Serializable;
import java.io.StringWriter;
import java.io.Writer;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBElement;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Marshaller;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.namespace.QName;
import org.opennms.core.utils.StringUtils;
import org.opennms.netmgt.alarmd.api.NorthboundAlarm;
import org.opennms.netmgt.alarmd.api.Northbounder;
import org.opennms.netmgt.alarmd.api.NorthbounderException;
import org.opennms.netmgt.alarmd.api.support.AlarmQueue;
import org.opennms.netmgt.alarmd.api.support.StatusFactory;
import org.opennms.netmgt.model.OnmsEventParameter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractNorthbounder
implements Northbounder,
Runnable,
StatusFactory<NorthboundAlarm> {
    private static final Logger LOG = LoggerFactory.getLogger(AbstractNorthbounder.class);
    private final String m_name;
    private final AlarmQueue<NorthboundAlarm> m_queue;
    private volatile boolean m_stopped = true;
    private long m_retryInterval = 1000L;
    private static JAXBContext ONMS_EVENT_PARM_CONTEXT = AbstractNorthbounder.initOnmsEventParameterContext();

    private static JAXBContext initOnmsEventParameterContext() {
        try {
            return JAXBContext.newInstance((Class[])new Class[]{EventParms.class});
        }
        catch (JAXBException e) {
            throw new RuntimeException(e);
        }
    }

    protected AbstractNorthbounder(String name) {
        this.m_name = name;
        this.m_queue = new AlarmQueue<NorthboundAlarm>(this);
        LOG.debug("Creating Northbounder instance {}", (Object)this.getName());
    }

    @Override
    public String getName() {
        return this.m_name;
    }

    public void setNaglesDelay(long delay) {
        this.m_queue.setNaglesDelay(delay);
    }

    public void setRetryInterval(int retryInterval) {
        this.m_retryInterval = retryInterval;
    }

    public void setMaxBatchSize(int maxBatchSize) {
        this.m_queue.setMaxBatchSize(maxBatchSize);
    }

    public void setMaxPreservedAlarms(int maxPreservedAlarms) {
        this.m_queue.setMaxPreservedAlarms(maxPreservedAlarms);
    }

    protected void onPreStart() {
    }

    protected void onPostStart() {
    }

    @Override
    public final void start() throws NorthbounderException {
        if (!this.m_stopped) {
            return;
        }
        this.onPreStart();
        this.m_stopped = false;
        this.m_queue.init();
        Thread thread = new Thread((Runnable)this, this.getName() + "-Thread");
        thread.start();
        this.onPostStart();
    }

    @Override
    public final void onAlarm(NorthboundAlarm alarm) throws NorthbounderException {
        if (this.accepts(alarm)) {
            this.m_queue.accept(alarm);
        }
    }

    protected abstract boolean accepts(NorthboundAlarm var1);

    protected void preserve(NorthboundAlarm alarm) throws NorthbounderException {
        this.m_queue.preserve(alarm);
    }

    protected void discard(NorthboundAlarm alarm) throws NorthbounderException {
        this.m_queue.discard(alarm);
    }

    protected void onStop() {
    }

    @Override
    public void reloadConfig() {
    }

    @Override
    public final void stop() throws NorthbounderException {
        this.onStop();
        this.m_stopped = true;
    }

    @Override
    public void run() {
        block4: while (true) {
            try {
                while (!this.m_stopped) {
                    List<NorthboundAlarm> alarmsToForward = this.m_queue.getAlarmsToForward();
                    try {
                        this.forwardAlarms(alarmsToForward);
                        this.m_queue.forwardSuccessful(alarmsToForward);
                        continue block4;
                    }
                    catch (Exception e) {
                        this.m_queue.forwardFailed(alarmsToForward);
                        if (this.m_stopped) continue;
                        Thread.sleep(this.m_retryInterval);
                    }
                }
                break;
            }
            catch (InterruptedException e) {
                LOG.warn("Thread '{}' was interrupted unexpected.", (Object)this.getName());
                break;
            }
        }
    }

    @Override
    public NorthboundAlarm createSyncLostMessage() {
        return NorthboundAlarm.SYNC_LOST_ALARM;
    }

    public abstract void forwardAlarms(List<NorthboundAlarm> var1) throws NorthbounderException;

    protected Map<String, Object> createMapping(NorthboundAlarm alarm, String dateFormat) {
        HashMap<String, Object> mapping = new HashMap<String, Object>();
        String defaultMapping = "";
        mapping.put("ackUser", this.nullSafeToString(alarm.getAckUser(), defaultMapping));
        mapping.put("appDn", this.nullSafeToString(alarm.getAppDn(), defaultMapping));
        mapping.put("logMsg", this.nullSafeToString(alarm.getLogMsg(), defaultMapping));
        mapping.put("description", this.nullSafeToString(alarm.getDesc(), defaultMapping));
        mapping.put("objectInstance", this.nullSafeToString(alarm.getObjectInstance(), defaultMapping));
        mapping.put("objectType", this.nullSafeToString(alarm.getObjectType(), defaultMapping));
        mapping.put("ossKey", this.nullSafeToString(alarm.getOssKey(), defaultMapping));
        mapping.put("ossState", this.nullSafeToString(alarm.getOssState(), defaultMapping));
        mapping.put("ticketId", this.nullSafeToString(alarm.getTicketId(), defaultMapping));
        mapping.put("ticketState", this.nullSafeToString(alarm.getTicketState(), defaultMapping));
        mapping.put("alarmUei", this.nullSafeToString(alarm.getUei(), defaultMapping));
        mapping.put("alarmKey", this.nullSafeToString(alarm.getAlarmKey(), defaultMapping));
        mapping.put("clearKey", this.nullSafeToString(alarm.getClearKey(), defaultMapping));
        mapping.put("operInstruct", this.nullSafeToString(alarm.getOperInst(), defaultMapping));
        mapping.put("ackTime", this.nullSafeToString(alarm.getAckTime(), defaultMapping));
        NorthboundAlarm.AlarmType alarmType = alarm.getAlarmType() == null ? NorthboundAlarm.AlarmType.NOTIFICATION : alarm.getAlarmType();
        mapping.put("alarmType", alarmType.name());
        String count = alarm.getCount() == null ? "1" : alarm.getCount().toString();
        mapping.put("count", count);
        mapping.put("alarmId", alarm.getId().toString());
        mapping.put("ipAddr", this.nullSafeToString(alarm.getIpAddr(), defaultMapping));
        if (dateFormat != null) {
            SimpleDateFormat simpleDateFormat = new SimpleDateFormat(dateFormat);
            if (alarm.getFirstOccurrence() != null) {
                mapping.put("firstOccurrence", simpleDateFormat.format(alarm.getFirstOccurrence()));
            }
            if (alarm.getLastOccurrence() != null) {
                mapping.put("lastOccurrence", simpleDateFormat.format(alarm.getLastOccurrence()));
            }
        } else {
            mapping.put("firstOccurrence", this.nullSafeIso8601String(alarm.getFirstOccurrence(), defaultMapping));
            mapping.put("lastOccurrence", this.nullSafeIso8601String(alarm.getLastOccurrence(), defaultMapping));
        }
        if (alarm.getNodeId() != null) {
            LOG.debug("Adding nodeId: " + alarm.getNodeId().toString());
            mapping.put("nodeId", alarm.getNodeId().toString());
            mapping.put("nodeLabel", alarm.getNodeLabel() == null ? "?" : alarm.getNodeLabel());
            mapping.put("nodeSysObjectId", alarm.getNodeSysObjectId() == null ? "?" : alarm.getNodeSysObjectId());
            mapping.put("foreignSource", alarm.getForeignSource() == null ? "?" : alarm.getForeignSource());
            mapping.put("foreignId", alarm.getForeignId() == null ? "?" : alarm.getForeignId());
        } else {
            mapping.put("nodeId", "");
            mapping.put("nodeLabel", "");
            mapping.put("nodeSysObjectId", "");
            mapping.put("foreignSource", "");
            mapping.put("foreignId", "");
        }
        String poller = alarm.getPoller() == null ? "00000000-0000-0000-0000-000000000000" : alarm.getPoller().getId();
        mapping.put("distPoller", poller);
        String service = alarm.getService() == null ? "" : alarm.getService();
        mapping.put("ifService", service);
        mapping.put("severity", this.nullSafeToString(alarm.getSeverity(), defaultMapping));
        mapping.put("ticketState", this.nullSafeToString(alarm.getTicketState(), defaultMapping));
        mapping.put("x733AlarmType", this.nullSafeToString(alarm.getX733Type(), defaultMapping));
        try {
            mapping.put("x733ProbableCause", this.nullSafeToString((Object)NorthboundAlarm.x733ProbableCause.get(alarm.getX733Cause()), defaultMapping));
        }
        catch (Exception e) {
            LOG.info("Exception caught setting X733 Cause: {}", (Object)alarm.getX733Cause(), (Object)e);
            mapping.put("x733ProbableCause", this.nullSafeToString((Object)NorthboundAlarm.x733ProbableCause.other, defaultMapping));
        }
        this.buildParmMappings(alarm, mapping);
        this.buildParmMappingXml(alarm, mapping);
        return mapping;
    }

    private String nullSafeToString(Object obj, String defaultString) {
        if (obj != null) {
            defaultString = obj.toString();
        }
        return defaultString;
    }

    private String nullSafeIso8601String(Date d, String defaultString) {
        if (d != null) {
            defaultString = StringUtils.iso8601LocalOffsetString((Date)d);
        }
        return defaultString;
    }

    private void buildParmMappings(NorthboundAlarm alarm, Map<String, Object> mapping) {
        if (alarm.getParameters().isEmpty()) {
            return;
        }
        int parmOffset = 1;
        for (OnmsEventParameter parm : alarm.getEventParametersCollection()) {
            mapping.put("parm[name-#" + parmOffset + "]", parm.getName());
            mapping.put("parm[#" + parmOffset + "]", parm.getValue());
            mapping.put("parm[" + parm.getName() + "]", parm.getValue());
            ++parmOffset;
        }
    }

    private void buildParmMappingXml(NorthboundAlarm alarm, Map<String, Object> mapping) {
        List<OnmsEventParameter> parms = alarm.getEventParametersCollection();
        EventParms eventParms = new EventParms(parms);
        try {
            JAXBElement rootElement = new JAXBElement(new QName("eventParms"), EventParms.class, (Object)eventParms);
            StringWriter sw = new StringWriter();
            Marshaller marshaller = ONMS_EVENT_PARM_CONTEXT.createMarshaller();
            marshaller.setProperty("jaxb.formatted.output", (Object)true);
            marshaller.setProperty("jaxb.fragment", (Object)true);
            marshaller.marshal((Object)rootElement, (Writer)sw);
            LOG.debug("Adding eventParmsXML mapping with contents {}.", (Object)sw);
            mapping.put("eventParmsXml", sw);
        }
        catch (JAXBException e) {
            LOG.error("Error marshalling event params to XML for alarm ID: {}", (Object)alarm.getId(), (Object)e);
        }
    }

    @XmlRootElement(name="eventParms")
    private static class EventParms
    implements Serializable {
        private List<OnmsEventParameter> m_eventParm = new ArrayList<OnmsEventParameter>();

        public EventParms() {
        }

        public EventParms(List<OnmsEventParameter> eventParm) {
            this.m_eventParm = eventParm;
        }

        public List<OnmsEventParameter> getParm() {
            return this.m_eventParm;
        }

        public void setParm(List<OnmsEventParameter> parms) {
            this.m_eventParm = parms;
        }
    }
}

