/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.flows.classification.internal;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicReference;
import org.opennms.netmgt.flows.classification.ClassificationEngine;
import org.opennms.netmgt.flows.classification.ClassificationRequest;
import org.opennms.netmgt.flows.classification.ClassificationRuleProvider;
import org.opennms.netmgt.flows.classification.FilterService;
import org.opennms.netmgt.flows.classification.internal.decision.PreprocessedRule;
import org.opennms.netmgt.flows.classification.internal.decision.Tree;
import org.opennms.netmgt.flows.classification.persistence.api.Rule;
import org.opennms.netmgt.flows.classification.persistence.api.RuleDefinition;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultClassificationEngine
implements ClassificationEngine {
    private List<ClassificationEngine.ClassificationRulesReloadedListener> classificationRulesReloadedListeners = new ArrayList<ClassificationEngine.ClassificationRulesReloadedListener>();
    private static Logger LOG = LoggerFactory.getLogger(DefaultClassificationEngine.class);
    private final AtomicReference<TreeAndInvalidRules> treeAndInvalidRules = new AtomicReference<TreeAndInvalidRules>(new TreeAndInvalidRules(Tree.EMPTY, Collections.emptyList()));
    private final ClassificationRuleProvider ruleProvider;
    private final FilterService filterService;

    public DefaultClassificationEngine(ClassificationRuleProvider ruleProvider, FilterService filterService) throws InterruptedException {
        this(ruleProvider, filterService, true);
    }

    public DefaultClassificationEngine(ClassificationRuleProvider ruleProvider, FilterService filterService, boolean initialize) throws InterruptedException {
        this.ruleProvider = Objects.requireNonNull(ruleProvider);
        this.filterService = Objects.requireNonNull(filterService);
        if (initialize) {
            this.reload();
        }
    }

    public void reload() throws InterruptedException {
        long start = System.currentTimeMillis();
        ArrayList<Rule> invalid = new ArrayList<Rule>();
        ArrayList preprocessedRules = Lists.newArrayList();
        List rules = this.ruleProvider.getRules();
        rules.forEach(rule -> {
            try {
                PreprocessedRule preprocessedRule = PreprocessedRule.of((RuleDefinition)rule);
                preprocessedRules.add(preprocessedRule);
                if (rule.canBeReversed()) {
                    preprocessedRules.add(preprocessedRule.reverse());
                }
            }
            catch (Exception ex) {
                LoggerFactory.getLogger(this.getClass()).error("Rule {} is not valid. Ignoring rule.", rule, (Object)ex);
                invalid.add((Rule)rule);
            }
        });
        Tree tree = Tree.of(preprocessedRules, this.filterService);
        long elapsed = System.currentTimeMillis() - start;
        if (LOG.isInfoEnabled()) {
            StringBuilder sb = new StringBuilder();
            sb.append("calculated flow classification decision tree\n").append("time (ms): " + elapsed).append('\n').append("rules    : " + rules.size() + " (including reversed rules: " + preprocessedRules.size() + ")").append('\n').append("leaves   : " + tree.info.leaves).append('\n').append("nodes    : " + tree.info.nodes).append('\n').append("choices  : " + tree.info.choices).append(" (nodes with rules that ignore the aspect of the node's threshold)\n").append("minDepth : " + tree.info.minDepth).append('\n').append("maxDepth : " + tree.info.maxDepth).append('\n').append("avgDepth : " + (double)tree.info.sumDepth / (double)tree.info.leaves).append('\n').append("minComp  : " + tree.info.minComp).append('\n').append("maxComp  : " + tree.info.maxComp).append('\n').append("avgComp  : " + (double)tree.info.sumComp / (double)tree.info.leaves).append('\n').append("minLeafSize : " + tree.info.minLeafSize).append('\n').append("maxLeafSize : " + tree.info.maxLeafSize).append('\n').append("avgLeafSize : " + (double)tree.info.sumLeafSize / (double)tree.info.leaves).append('\n');
            LOG.info(sb.toString());
        }
        this.treeAndInvalidRules.set(new TreeAndInvalidRules(tree, invalid));
        this.fireClassificationReloadedListeners(Collections.unmodifiableList(rules));
    }

    private void fireClassificationReloadedListeners(List<Rule> rules) {
        for (ClassificationEngine.ClassificationRulesReloadedListener classificationRulesReloadedListener : this.classificationRulesReloadedListeners) {
            classificationRulesReloadedListener.classificationRulesReloaded(rules);
        }
    }

    public List<Rule> getInvalidRules() {
        return Collections.unmodifiableList(this.treeAndInvalidRules.get().invalidRules);
    }

    public Tree getTree() {
        return this.treeAndInvalidRules.get().tree;
    }

    public String classify(ClassificationRequest classificationRequest) {
        return this.treeAndInvalidRules.get().tree.classify(classificationRequest);
    }

    public void addClassificationRulesReloadedListener(ClassificationEngine.ClassificationRulesReloadedListener classificationRulesReloadedListener) {
        this.classificationRulesReloadedListeners.add(classificationRulesReloadedListener);
    }

    public void removeClassificationRulesReloadedListener(ClassificationEngine.ClassificationRulesReloadedListener classificationRulesReloadedListener) {
        this.classificationRulesReloadedListeners.remove(classificationRulesReloadedListener);
    }

    private static class TreeAndInvalidRules {
        private final Tree tree;
        private final List<Rule> invalidRules;

        public TreeAndInvalidRules(Tree tree, List<Rule> invalidRules) {
            this.tree = tree;
            this.invalidRules = invalidRules;
        }
    }
}

