/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.flows.classification.internal;

import com.google.common.cache.CacheLoader;
import java.util.Objects;
import java.util.concurrent.ExecutionException;
import org.opennms.core.cache.Cache;
import org.opennms.core.cache.CacheBuilder;
import org.opennms.core.cache.CacheConfig;
import org.opennms.netmgt.flows.classification.FilterService;
import org.opennms.netmgt.flows.classification.exception.InvalidFilterException;

public class CachingFilterService
implements FilterService {
    private final Cache<Key, Boolean> cache;
    private final FilterService delegate;

    public CachingFilterService(final FilterService delegate, CacheConfig cacheConfig) {
        Objects.requireNonNull(cacheConfig);
        Objects.requireNonNull(delegate);
        this.delegate = delegate;
        this.cache = new CacheBuilder().withConfig(cacheConfig).withCacheLoader((CacheLoader)new CacheLoader<Key, Boolean>(){

            public Boolean load(Key key) {
                return delegate.matches(key.address, key.filterExpression);
            }
        }).build();
    }

    public void validate(String filterExpression) throws InvalidFilterException {
        this.delegate.validate(filterExpression);
    }

    public boolean matches(String address, String filterExpression) {
        try {
            return (Boolean)this.cache.get((Object)new Key(address, filterExpression));
        }
        catch (ExecutionException e) {
            throw new RuntimeException("Error loading entry from cache", e);
        }
    }

    private static class Key {
        public final String address;
        public final String filterExpression;

        private Key(String address, String filterExpression) {
            this.address = address;
            this.filterExpression = filterExpression;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Key key = (Key)o;
            return Objects.equals(this.address, key.address) && Objects.equals(this.filterExpression, key.filterExpression);
        }

        public int hashCode() {
            return Objects.hash(this.address, this.filterExpression);
        }
    }
}

