/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.install;

import java.io.BufferedReader;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.Reader;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.nio.channels.FileChannel;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.sql.DataSource;
import joptsimple.internal.Strings;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.HelpFormatter;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.PosixParser;
import org.apache.commons.io.IOUtils;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.core.config.Configurator;
import org.opennms.bootstrap.Bootstrap;
import org.opennms.bootstrap.FilesystemPermissionException;
import org.opennms.bootstrap.FilesystemPermissionValidator;
import org.opennms.core.db.DataSourceConfigurationFactory;
import org.opennms.core.db.install.SimpleDataSource;
import org.opennms.core.logging.Logging;
import org.opennms.core.schema.Migrator;
import org.opennms.core.utils.ConfigFileConstants;
import org.opennms.core.utils.ProcessExec;
import org.opennms.install.IPv6Validator;
import org.opennms.netmgt.config.UserFactory;
import org.opennms.netmgt.config.UserManager;
import org.opennms.netmgt.config.opennmsDataSources.JdbcDataSource;
import org.opennms.netmgt.icmp.Pinger;
import org.opennms.netmgt.icmp.best.BestMatchPingerFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.ApplicationContext;
import org.springframework.context.support.GenericApplicationContext;
import org.springframework.util.StringUtils;

public class Installer {
    private static final Logger LOG = LoggerFactory.getLogger(Installer.class);
    private static final Pattern SHELL_VAR_PATTERN = Pattern.compile("^(?:\\s*export\\s+)?\\s*(\\p{Alnum}+)\\s*=\\s*(.*?)\\s*$", 8);
    private static final Pattern QUOTE_PATTERN = Pattern.compile("^\"(.*)\"");
    static final String LIBRARY_PROPERTY_FILE = "libraries.properties";
    String m_opennms_home = null;
    boolean m_update_database = false;
    boolean m_update_iplike = false;
    boolean m_do_full_vacuum = false;
    boolean m_do_vacuum = false;
    boolean m_install_webapp = false;
    boolean m_fix_constraint = false;
    boolean m_validate_ownership = true;
    boolean m_ignore_database_version = false;
    boolean m_remove_database = false;
    boolean m_skip_upgrade_tools = false;
    String m_etc_dir = "";
    String m_tomcat_conf = null;
    String m_webappdir = null;
    String m_resetWebAppAdminPassword = null;
    String m_import_dir = null;
    String m_install_servletdir = null;
    String m_library_search_path = null;
    String m_fix_constraint_name = null;
    boolean m_fix_constraint_remove_rows = false;
    boolean m_timescaleDB = false;
    protected Options options = new Options();
    protected CommandLine m_commandLine;
    private Migrator m_migrator = new Migrator();
    Properties m_properties = null;
    String m_required_options = "At least one of -d, -i, -s, -y, -C, or -T is required.";
    private static final String OPENNMS_DATA_SOURCE_NAME = "opennms";
    private static final String ADMIN_DATA_SOURCE_NAME = "opennms-admin";
    private String RUNAS_USER = null;

    public void install(String[] argv) throws Exception {
        GenericApplicationContext context;
        boolean doDatabase;
        block14: {
            File rrd_binary;
            this.printHeader();
            this.loadProperties();
            this.parseArguments(argv);
            doDatabase = this.m_update_database || this.m_update_iplike;
            context = null;
            if (doDatabase) {
                File cfgFile = ConfigFileConstants.getFile((int)ConfigFileConstants.OPENNMS_DATASOURCE_CONFIG_FILE_NAME);
                FileInputStream is = new FileInputStream(cfgFile);
                JdbcDataSource adminDsConfig = new DataSourceConfigurationFactory((InputStream)is).getJdbcDataSource(ADMIN_DATA_SOURCE_NAME);
                SimpleDataSource adminDs = new SimpleDataSource(adminDsConfig);
                ((InputStream)is).close();
                is = new FileInputStream(cfgFile);
                JdbcDataSource dsConfig = new DataSourceConfigurationFactory((InputStream)is).getJdbcDataSource(OPENNMS_DATA_SOURCE_NAME);
                SimpleDataSource ds = new SimpleDataSource(dsConfig);
                ((InputStream)is).close();
                context = new GenericApplicationContext();
                context.setClassLoader(Bootstrap.loadClasses((File)new File(this.m_opennms_home), (boolean)true));
                this.m_migrator.setApplicationContext((ApplicationContext)context);
                this.m_migrator.getLiquibaseChangelogs(true);
                this.m_migrator.setDataSource((DataSource)ds);
                this.m_migrator.setAdminDataSource((DataSource)adminDs);
                this.m_migrator.setValidateDatabaseVersion(!this.m_ignore_database_version);
                this.m_migrator.setDatabaseName(dsConfig.getDatabaseName());
                this.m_migrator.setSchemaName(dsConfig.getSchemaName());
                this.m_migrator.setAdminUser(adminDsConfig.getUserName());
                this.m_migrator.setAdminPassword(adminDsConfig.getPassword());
                this.m_migrator.setDatabaseUser(dsConfig.getUserName());
                this.m_migrator.setDatabasePassword(dsConfig.getPassword());
            }
            this.checkIPv6();
            boolean using_jni_rrd_strategy = System.getProperty("org.opennms.rrd.strategyClass", "").contains("JniRrdStrategy");
            if (using_jni_rrd_strategy && !(rrd_binary = new File(System.getProperty("rrd.binary"))).canExecute()) {
                throw new Exception("Cannot execute the rrdtool binary '" + rrd_binary.getAbsolutePath() + "' required by the current RRD strategy. Update the rrd.binary field in opennms.properties appropriately.");
            }
            if (!Boolean.getBoolean("skip-native")) {
                String icmp_path = this.findLibrary("jicmp", this.m_library_search_path, false);
                String icmp6_path = this.findLibrary("jicmp6", this.m_library_search_path, false);
                String jrrd_path = this.findLibrary("jrrd", this.m_library_search_path, false);
                String jrrd2_path = this.findLibrary("jrrd2", this.m_library_search_path, false);
                this.writeLibraryConfig(icmp_path, icmp6_path, jrrd_path, jrrd2_path);
            }
            try {
                this.verifyFilesAndDirectories();
            }
            catch (FilesystemPermissionException e) {
                LOG.error("OpenNMS is configured to run as '{}' but '{}' is not writable by that account.", (Object)this.getRunas(), (Object)e.path);
                LOG.error("To fix permissions, run '{}/bin/fix-permissions' as root", (Object)this.m_opennms_home);
                System.out.println();
                if (!this.m_validate_ownership) break block14;
                throw e;
            }
        }
        if (this.m_install_webapp) {
            this.checkWebappOldOpennmsDir();
            this.checkServerXmlOldOpennmsContext();
        }
        if (doDatabase) {
            LOG.info(String.format("* using '%s' as the PostgreSQL user for OpenNMS", this.m_migrator.getAdminUser()));
            LOG.info(String.format("* using '%s' as the PostgreSQL database name for OpenNMS", this.m_migrator.getDatabaseName()));
            if (this.m_migrator.getSchemaName() != null) {
                LOG.info(String.format("* using '%s' as the PostgreSQL schema name for OpenNMS", this.m_migrator.getSchemaName()));
            }
            this.m_migrator.setupDatabase(this.m_update_database, this.m_do_vacuum, this.m_do_vacuum, this.m_update_iplike, this.m_timescaleDB);
            if (this.m_update_database && this.m_remove_database) {
                this.m_migrator.dropDatabase();
            }
            if (this.m_update_database) {
                this.createConfiguredFile();
            }
            context.close();
        }
        this.handleConfigurationChanges();
        if (this.m_install_webapp) {
            this.installWebApp();
        }
        if (this.m_tomcat_conf != null) {
            this.updateTomcatConf();
        }
        if (!Strings.isNullOrEmpty((String)this.m_resetWebAppAdminPassword)) {
            this.resetWebAppAdminPassword();
        }
        System.out.println();
        System.out.println("*** Thanks for using OpenNMS!");
        System.out.println("***");
        System.out.println("*** Consider joining our active and supportive online community through");
        System.out.println("***");
        System.out.println("*** https://www.opennms.com/participate/");
        System.out.println("***");
        System.out.println("*** To connect with users, testers, experts, and contributors.");
        System.out.println("***");
        System.out.println("*** Or email us directly at contactus@opennms.com to learn more.");
        System.out.println();
        System.out.println("Installer completed successfully!");
        if (!this.m_skip_upgrade_tools) {
            System.setProperty("opennms.manager.class", "org.opennms.upgrade.support.Upgrade");
            Bootstrap.main((String[])new String[0]);
        }
    }

    protected void resetWebAppAdminPassword() throws Exception {
        UserFactory.init();
        UserManager userManager = UserFactory.getInstance();
        userManager.setUnencryptedPassword("admin", this.m_resetWebAppAdminPassword);
        System.out.println("Password for the web application admin user was set.");
    }

    private void checkIPv6() {
        IPv6Validator v6Validator = new IPv6Validator();
        if (!v6Validator.isPlatformIPv6Ready()) {
            System.out.println("Your OS does not support IPv6.");
        }
    }

    private void handleConfigurationChanges() {
        File etcDir = new File(this.m_opennms_home + File.separator + "etc");
        File importDir = new File(this.m_import_dir);
        File[] files = etcDir.listFiles(this.getImportFileFilter());
        if (!importDir.exists()) {
            System.out.print("- Creating imports directory (" + importDir.getAbsolutePath() + "... ");
            if (!importDir.mkdirs()) {
                System.out.println("FAILED");
                System.exit(1);
            }
            System.out.println("OK");
        }
        System.out.print("- Checking for old import files in " + etcDir.getAbsolutePath() + "... ");
        if (files.length > 0) {
            System.out.println("FOUND");
            for (File f : files) {
                String newFileName = f.getName().replace("imports-", "");
                File newFile = new File(importDir, newFileName);
                System.out.print("  - moving " + f.getName() + " to " + importDir.getPath() + "... ");
                if (f.renameTo(newFile)) {
                    System.out.println("OK");
                    continue;
                }
                System.out.println("FAILED");
            }
        } else {
            System.out.println("DONE");
        }
    }

    private FilenameFilter getImportFileFilter() {
        return new FilenameFilter(){

            @Override
            public boolean accept(File dir, String name) {
                return name.matches("imports-.*\\.xml");
            }
        };
    }

    public void createConfiguredFile() throws IOException {
        File f = new File(this.m_opennms_home + File.separator + "etc" + File.separator + "configured");
        if (!f.createNewFile()) {
            LOG.warn("Could not create file: {}", (Object)f.getPath());
        }
    }

    public void printHeader() {
        System.out.println("==============================================================================");
        System.out.println("OpenNMS Installer");
        System.out.println("==============================================================================");
        System.out.println("");
        System.out.println("Configures PostgreSQL tables, users, and other miscellaneous settings.");
        System.out.println("");
    }

    public void loadProperties() throws IOException {
        this.m_properties = new Properties();
        this.m_properties.load(Installer.class.getResourceAsStream("/installer.properties"));
        Properties sys = System.getProperties();
        this.m_properties.putAll((Map<?, ?>)sys);
        this.m_opennms_home = this.fetchProperty("install.dir");
        this.m_etc_dir = this.fetchProperty("install.etc.dir");
        this.loadEtcPropertiesFile("opennms.properties");
        this.loadEtcPropertiesFile("rrd-configuration.properties");
        this.m_install_servletdir = this.fetchProperty("install.servlet.dir");
        try {
            this.m_import_dir = this.fetchProperty("importer.requisition.dir");
        }
        catch (Exception e) {
            this.m_import_dir = this.m_opennms_home + File.separator + "etc" + File.separator + "imports";
        }
        System.setProperty("opennms.home", this.m_opennms_home);
    }

    private void loadEtcPropertiesFile(String propertiesFile) throws IOException {
        try {
            Properties opennmsProperties = new Properties();
            FileInputStream ois = new FileInputStream(this.m_etc_dir + File.separator + propertiesFile);
            opennmsProperties.load(ois);
            for (Map.Entry<Object, Object> p : opennmsProperties.entrySet()) {
                if (this.m_properties.containsKey(p.getKey())) continue;
                this.m_properties.put(p.getKey(), p.getValue());
            }
        }
        catch (FileNotFoundException e) {
            System.out.println("WARNING: unable to load " + this.m_etc_dir + File.separator + propertiesFile);
        }
    }

    public String fetchProperty(String property) throws IllegalStateException {
        String value = this.m_properties.getProperty(property);
        if (value == null) {
            throw new IllegalStateException("property \"" + property + "\" not set from bundled installer.properties file");
        }
        return value;
    }

    public void parseArguments(String[] argv) throws Exception {
        this.options.addOption("h", "help", false, "this help");
        this.options.addOption("d", "do-database", false, "perform database actions");
        this.options.addOption("Z", "remove-database", false, "remove the OpenNMS database");
        this.options.addOption("u", "username", true, "username of the database account (default: 'opennms')");
        this.options.addOption("p", "password", true, "password of the database account (default: 'opennms')");
        this.options.addOption("a", "admin-username", true, "username of the database administrator (default: 'postgres')");
        this.options.addOption("A", "admin-password", true, "password of the database administrator (default: '')");
        this.options.addOption("D", "database-url", true, "JDBC database URL (default: jdbc:postgresql://localhost:5432/");
        this.options.addOption("P", "database-name", true, "name of the PostgreSQL database (default: opennms)");
        this.options.addOption("c", "clean-database", false, "this option does nothing");
        this.options.addOption("i", "insert-data", false, "(obsolete)");
        this.options.addOption("s", "stored-procedure", false, "add the IPLIKE stored procedure if it's missing");
        this.options.addOption("v", "vacuum", false, "vacuum (optimize) the database");
        this.options.addOption("f", "vacuum-full", false, "vacuum full the database (recovers unused disk space)");
        this.options.addOption("Q", "ignore-database-version", false, "disable the database version check");
        this.options.addOption("x", "database-debug", false, "turn on debugging for the database data transformation");
        this.options.addOption("e", "extended-repairs", false, "enable extended repairs of old schemas");
        this.options.addOption("y", "do-webapp", false, "install web application (see '-w')");
        this.options.addOption("T", "tomcat-conf", true, "location of tomcat.conf");
        this.options.addOption("w", "tomcat-context", true, "location of the tomcat context (eg, conf/Catalina/localhost)");
        this.options.addOption("l", "library-path", true, "library search path (directories separated by '" + File.pathSeparator + "')");
        this.options.addOption("R", "reset-webui-password", true, "set password of the web application admin account");
        this.options.addOption("r", "rpm-install", false, "RPM install (deprecated)");
        this.options.addOption("o", "skip-ownership-validation", false, "whether to skip validating file ownership in OpenNMS home");
        this.options.addOption("S", "skip-upgrade-tools", false, "Skip the execution of the upgrade tools (post-processing tasks)");
        this.options.addOption("t", "timescaledb", false, "Installs TimescaleDB extension");
        PosixParser parser = new PosixParser();
        this.m_commandLine = parser.parse(this.options, argv);
        if (this.m_commandLine.hasOption("h")) {
            this.usage(this.options, this.m_commandLine);
            System.exit(0);
        }
        this.options.addOption("u", "username", true, "replaced by opennms-datasources.xml");
        this.options.addOption("p", "password", true, "replaced by opennms-datasources.xml");
        this.options.addOption("a", "admin-username", true, "replaced by opennms-datasources.xml");
        this.options.addOption("A", "admin-password", true, "replaced by opennms-datasources.xml");
        this.options.addOption("D", "database-url", true, "replaced by opennms-datasources.xml");
        this.options.addOption("P", "database-name", true, "replaced by opennms-datasources.xml");
        if (this.m_commandLine.hasOption("c")) {
            this.usage(this.options, this.m_commandLine, "The 'c' option was deprecated in 1.6, and disabled in 1.8.  You should backup and then drop the database before running install to reset your data.", null);
            System.exit(1);
        }
        if (this.m_commandLine.hasOption("u") || this.m_commandLine.hasOption("p") || this.m_commandLine.hasOption("a") || this.m_commandLine.hasOption("A") || this.m_commandLine.hasOption("D") || this.m_commandLine.hasOption("P")) {
            this.usage(this.options, this.m_commandLine, "The 'u', 'p', 'a', 'A', 'D', and 'P' options have all been superseded.\nPlease edit $OPENNMS_HOME/etc/opennms-datasources.xml instead.", null);
            System.exit(1);
        }
        this.m_fix_constraint = this.m_commandLine.hasOption("C");
        this.m_fix_constraint_name = this.m_commandLine.getOptionValue("C");
        if (this.m_commandLine.hasOption("e")) {
            System.setProperty("opennms.contexts", "production,repair");
        }
        this.m_update_database = this.m_commandLine.hasOption("d");
        this.m_remove_database = this.m_commandLine.hasOption("Z");
        this.m_do_full_vacuum = this.m_commandLine.hasOption("f");
        this.m_library_search_path = this.m_commandLine.getOptionValue("l", this.m_library_search_path);
        this.m_ignore_database_version = this.m_commandLine.hasOption("Q");
        this.m_update_iplike = this.m_commandLine.hasOption("s");
        this.m_tomcat_conf = this.m_commandLine.getOptionValue("T", this.m_tomcat_conf);
        this.m_do_vacuum = this.m_commandLine.hasOption("v");
        this.m_webappdir = this.m_commandLine.getOptionValue("w", this.m_webappdir);
        this.m_timescaleDB = this.m_commandLine.hasOption("t");
        this.m_resetWebAppAdminPassword = this.m_commandLine.getOptionValue("R", this.m_resetWebAppAdminPassword);
        this.m_validate_ownership = !this.m_commandLine.hasOption("o");
        Configurator.setRootLevel((Level)Level.INFO);
        if (this.m_commandLine.hasOption("x")) {
            Configurator.setRootLevel((Level)Level.DEBUG);
        }
        this.m_fix_constraint_remove_rows = this.m_commandLine.hasOption("X");
        this.m_install_webapp = this.m_commandLine.hasOption("y");
        this.m_skip_upgrade_tools = this.m_commandLine.hasOption("S");
        if (this.m_commandLine.getArgList().size() > 0) {
            this.usage(this.options, this.m_commandLine, "Unknown command-line arguments: " + Arrays.toString(this.m_commandLine.getArgs()), null);
            System.exit(1);
        }
        if (!this.m_update_database && !this.m_update_iplike && this.m_library_search_path == null && this.m_resetWebAppAdminPassword == null) {
            this.usage(this.options, this.m_commandLine, "Nothing to do.  Use -h for help.", null);
            System.exit(1);
        }
    }

    public void verifyFilesAndDirectories() throws IOException, FilesystemPermissionException {
        if (this.m_tomcat_conf != null) {
            this.verifyFileExists(false, this.m_tomcat_conf, "Tomcat startup configuration file tomcat4.conf", "-T option");
        }
        if (this.m_install_webapp) {
            this.verifyFileExists(true, this.m_webappdir, "Tomcat context directory", "-w option");
            this.verifyFileExists(true, this.m_install_servletdir, "OpenNMS servlet directory", "install.servlet.dir property");
        }
        FilesystemPermissionValidator validator = new FilesystemPermissionValidator();
        String user = this.getRunas();
        Path opennmsHome = Paths.get(this.m_opennms_home, new String[0]);
        validator.validate(user, opennmsHome);
    }

    protected String getRunas() throws IOException {
        if (this.RUNAS_USER == null) {
            Properties opennmsConf = this.readOpennmsConf();
            this.RUNAS_USER = opennmsConf.getProperty("RUNAS", System.getProperty("opennms.runas", OPENNMS_DATA_SOURCE_NAME));
        }
        return this.RUNAS_USER;
    }

    protected Properties readOpennmsConf() throws IOException {
        if (this.m_opennms_home == null) {
            this.loadProperties();
        }
        Path opennmsConf = Paths.get(this.m_opennms_home, "etc", "opennms.conf");
        Properties props = new Properties();
        if (opennmsConf.toFile().exists()) {
            List<String> lines = Files.readAllLines(opennmsConf);
            lines.forEach(line -> {
                Matcher shell = SHELL_VAR_PATTERN.matcher((CharSequence)line);
                if (shell.matches()) {
                    String key = shell.group(1);
                    String value = shell.group(2);
                    Matcher quotes = QUOTE_PATTERN.matcher(value);
                    if (quotes.matches()) {
                        value = quotes.group(1);
                    }
                    LOG.debug("opennms.conf: {}={}", (Object)key, (Object)value);
                    props.put(key, value);
                }
            });
        }
        return props;
    }

    public void verifyFileExists(boolean isDir, String file, String description, String option) throws FileNotFoundException {
        if (file == null) {
            throw new FileNotFoundException("The user most provide the location of " + description + ", but this is not specified.  Use the " + option + " to specify this file.");
        }
        System.out.print("- using " + description + "... ");
        File f = new File(file);
        if (!f.exists()) {
            throw new FileNotFoundException(description + " does not exist at \"" + file + "\".  Use the " + option + " to specify another location.");
        }
        if (!isDir) {
            if (!f.isFile()) {
                throw new FileNotFoundException(description + " not a file at \"" + file + "\".  Use the " + option + " to specify another file.");
            }
        } else if (!f.isDirectory()) {
            throw new FileNotFoundException(description + " not a directory at \"" + file + "\".  Use the " + option + " to specify another directory.");
        }
        System.out.println(f.getAbsolutePath());
    }

    public void checkWebappOldOpennmsDir() throws Exception {
        File f = new File(this.m_webappdir + File.separator + OPENNMS_DATA_SOURCE_NAME);
        System.out.print("- Checking for old opennms webapp directory in " + f.getAbsolutePath() + "... ");
        if (f.exists()) {
            throw new Exception("Old OpenNMS web application exists: " + f.getAbsolutePath() + ".  You need to remove this before continuing.");
        }
        System.out.println("OK");
    }

    public void checkServerXmlOldOpennmsContext() throws Exception {
        String line;
        String search_regexp = "(?ms).*<Context\\s+path=\"/opennms\".*";
        StringBuilder b = new StringBuilder();
        File f = new File(this.m_webappdir + File.separator + ".." + File.separator + "conf" + File.separator + "server.xml");
        System.out.print("- Checking for old opennms context in " + f.getAbsolutePath() + "... ");
        if (!f.exists()) {
            System.out.println("DID NOT CHECK (file does not exist)");
            return;
        }
        InputStreamReader fr = new InputStreamReader((InputStream)new FileInputStream(f), StandardCharsets.UTF_8);
        BufferedReader r = new BufferedReader(fr);
        while ((line = r.readLine()) != null) {
            b.append(line);
            b.append("\n");
        }
        r.close();
        ((Reader)fr).close();
        if (b.toString().matches(search_regexp)) {
            throw new Exception("Old OpenNMS context found in " + f.getAbsolutePath() + ".  You must remove this context from server.xml and re-run the installer.");
        }
        System.out.println("OK");
    }

    public void installWebApp() throws Exception {
        System.out.println("- Install OpenNMS webapp... ");
        this.copyFile(this.m_install_servletdir + File.separator + "META-INF" + File.separator + "context.xml", this.m_webappdir + File.separator + "opennms.xml", "web application context", false);
        System.out.println("- Installing OpenNMS webapp... DONE");
    }

    public void copyFile(String source, String destination, String description, boolean recursive) throws Exception {
        File sourceFile = new File(source);
        File destinationFile = new File(destination);
        if (!sourceFile.exists()) {
            throw new Exception("source file (" + source + ") does not exist!");
        }
        if (!sourceFile.isFile()) {
            throw new Exception("source file (" + source + ") is not a file!");
        }
        if (!sourceFile.canRead()) {
            throw new Exception("source file (" + source + ") is not readable!");
        }
        if (destinationFile.exists()) {
            System.out.print("  - " + destination + " exists, removing... ");
            if (destinationFile.delete()) {
                System.out.println("REMOVED");
            } else {
                System.out.println("FAILED");
                throw new Exception("unable to delete existing file: " + sourceFile);
            }
        }
        System.out.print("  - copying " + source + " to " + destination + "... ");
        if (!destinationFile.getParentFile().exists() && !destinationFile.getParentFile().mkdirs()) {
            throw new Exception("unable to create directory: " + destinationFile.getParent());
        }
        if (!destinationFile.createNewFile()) {
            throw new Exception("unable to create file: " + destinationFile);
        }
        FileChannel from = null;
        FileInputStream fisFrom = null;
        FileChannel to = null;
        FileOutputStream fisTo = null;
        try {
            fisFrom = new FileInputStream(sourceFile);
            from = fisFrom.getChannel();
            fisTo = new FileOutputStream(destinationFile);
            to = fisTo.getChannel();
            to.transferFrom(from, 0L, from.size());
        }
        catch (FileNotFoundException e) {
            try {
                throw new Exception("unable to copy " + sourceFile + " to " + destinationFile, e);
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly(fisTo);
                IOUtils.closeQuietly(to);
                IOUtils.closeQuietly((InputStream)fisFrom);
                IOUtils.closeQuietly((Closeable)from);
                throw throwable;
            }
        }
        IOUtils.closeQuietly((OutputStream)fisTo);
        IOUtils.closeQuietly((Closeable)to);
        IOUtils.closeQuietly((InputStream)fisFrom);
        IOUtils.closeQuietly((Closeable)from);
        System.out.println("DONE");
    }

    public void installLink(String source, String destination, String description, boolean recursive) throws Exception {
        ProcessExec e = new ProcessExec(System.out, System.out);
        if (new File(destination).exists()) {
            System.out.print("  - " + destination + " exists, removing... ");
            this.removeFile(destination, description, recursive);
            System.out.println("REMOVED");
        }
        System.out.print("  - creating link to " + destination + "... ");
        String[] cmd = new String[]{"ln", "-sf", source, destination};
        if (e.exec(cmd) != 0) {
            throw new Exception("Non-zero exit value returned while linking " + description + ", " + source + " into " + destination);
        }
        System.out.println("DONE");
    }

    public void updateTomcatConf() throws Exception {
        String line;
        File f = new File(this.m_tomcat_conf);
        System.out.print("- setting tomcat4 user to 'root'... ");
        BufferedReader r = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(f), StandardCharsets.UTF_8));
        StringBuilder b = new StringBuilder();
        while ((line = r.readLine()) != null) {
            if (line.startsWith("TOMCAT_USER=")) {
                b.append("TOMCAT_USER=\"root\"\n");
                continue;
            }
            b.append(line);
            b.append("\n");
        }
        r.close();
        if (!f.renameTo(new File(this.m_tomcat_conf + ".before-opennms-" + System.currentTimeMillis()))) {
            LOG.warn("Could not rename file: {}", (Object)f.getPath());
        }
        f = new File(this.m_tomcat_conf);
        PrintWriter w = new PrintWriter(new FileOutputStream(f));
        w.print(b.toString());
        w.close();
        System.out.println("DONE");
    }

    public void removeFile(String destination, String description, boolean recursive) throws IOException, InterruptedException, Exception {
        ProcessExec e = new ProcessExec(System.out, System.out);
        Object[] cmd = recursive ? new String[]{"rm", "-r", destination} : new String[]{"rm", destination};
        if (e.exec((String[])cmd) != 0) {
            throw new Exception("Non-zero exit value returned while removing " + description + ", " + destination + ", using \"" + StringUtils.arrayToDelimitedString((Object[])cmd, (String)" ") + "\"");
        }
        if (new File(destination).exists()) {
            this.usage(this.options, this.m_commandLine, "Could not delete existing " + description + ": " + destination, null);
            System.exit(1);
        }
    }

    private void usage(Options options, CommandLine cmd) {
        this.usage(options, cmd, null, null);
    }

    private void usage(Options options, CommandLine cmd, String error, Exception e) {
        HelpFormatter formatter = new HelpFormatter();
        PrintWriter pw = new PrintWriter(System.out);
        if (error != null) {
            pw.println("An error occurred: " + error + "\n");
        }
        formatter.printHelp("usage: install [options]", options);
        if (e != null) {
            pw.println(e.getMessage());
            e.printStackTrace(pw);
        }
        pw.close();
    }

    public static void main(String[] argv) throws Exception {
        Map mdc = Logging.getCopyOfContextMap();
        Logging.putPrefix((String)"install");
        new Installer().install(argv);
        Logging.setContextMap((Map)mdc);
    }

    public String checkServerVersion() throws IOException {
        File catalinaHome = new File(this.m_webappdir).getParentFile();
        String readmeVersion = this.getTomcatVersion(new File(catalinaHome, "README.txt"));
        String runningVersion = this.getTomcatVersion(new File(catalinaHome, "RUNNING.txt"));
        if (readmeVersion == null && runningVersion == null) {
            return null;
        }
        if (readmeVersion != null && runningVersion != null) {
            return readmeVersion;
        }
        if (readmeVersion != null && runningVersion == null) {
            return readmeVersion;
        }
        return runningVersion;
    }

    public String getTomcatVersion(File file) throws IOException {
        if (file == null || !file.exists()) {
            return null;
        }
        Pattern p = Pattern.compile("The Tomcat (\\S+) Servlet/JSP Container");
        BufferedReader in = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(file), StandardCharsets.UTF_8));
        for (int i = 0; i < 5; ++i) {
            String line = in.readLine();
            if (line == null) {
                in.close();
                return null;
            }
            Matcher m = p.matcher(line);
            if (!m.find()) continue;
            in.close();
            return m.group(1);
        }
        in.close();
        return null;
    }

    /*
     * WARNING - void declaration
     */
    public String findLibrary(String libname, String path, boolean isRequired) throws Exception {
        String fullname = System.mapLibraryName(libname);
        ArrayList<String> searchPaths = new ArrayList<String>();
        if (path != null) {
            for (String string : path.split(File.pathSeparator)) {
                searchPaths.add(string);
            }
        }
        try {
            String[] confFile = new File(this.m_opennms_home + File.separator + "etc" + File.separator + LIBRARY_PROPERTY_FILE);
            Properties p = new Properties();
            FileInputStream is = new FileInputStream((File)confFile);
            p.load(is);
            ((InputStream)is).close();
            for (Object k : p.keySet()) {
                String key = (String)k;
                if (!key.startsWith("opennms.library")) continue;
                String value = p.getProperty(key);
                value = value.replaceAll(File.separator + "[^" + File.separator + "]*$", "");
                searchPaths.add(value);
            }
        }
        catch (Throwable confFile) {
            // empty catch block
        }
        if (System.getProperty("java.library.path") != null) {
            for (String string : System.getProperty("java.library.path").split(File.pathSeparator)) {
                searchPaths.add(string);
            }
        }
        if (!System.getProperty("os.name").contains("Windows")) {
            void var9_26;
            String[] defaults;
            String[] p = defaults = new String[]{"/usr/lib/jni", "/usr/lib", "/usr/local/lib", "/opt/NMSjicmp/lib/32", "/opt/NMSjicmp/lib/64", "/opt/NMSjicmp6/lib/32", "/opt/NMSjicmp6/lib/64"};
            int is = p.length;
            boolean bl = false;
            while (var9_26 < is) {
                String entry = p[var9_26];
                searchPaths.add(entry);
                ++var9_26;
            }
        }
        if (Files.exists(Paths.get("/usr/lib64", new String[0]), new LinkOption[0])) {
            searchPaths.add("/usr/lib64");
        }
        if (Files.exists(Paths.get("/usr/lib/jni", new String[0]), new LinkOption[0])) {
            searchPaths.add("/usr/lib/jni");
        }
        System.out.println("- searching for " + fullname + ":");
        for (String dirname : searchPaths) {
            String fullPathOldExtension;
            String string;
            File entry = new File(dirname);
            if (entry.isFile()) {
                dirname = entry.getParent();
            }
            if (this.loadLibrary(string = dirname + File.separator + fullname)) {
                return string;
            }
            if (!fullname.endsWith(".dylib") || !this.loadLibrary(fullPathOldExtension = string.replace(".dylib", ".jnilib"))) continue;
            return fullPathOldExtension;
        }
        if (isRequired) {
            void var9_29;
            StringBuilder buf = new StringBuilder();
            String[] stringArray = System.getProperty("java.library.path").split(File.pathSeparator);
            int n = stringArray.length;
            boolean bl = false;
            while (var9_29 < n) {
                String pathEntry = stringArray[var9_29];
                buf.append(" ");
                buf.append(pathEntry);
                ++var9_29;
            }
            throw new Exception("Failed to load the required " + libname + " library that is required at runtime.  By default, we search the Java library path:" + buf.toString() + ".  For more information, see http://www.opennms.org/index.php/" + libname);
        }
        System.out.println("- Failed to load the optional " + libname + " library.");
        System.out.println("  - This error is not fatal, since " + libname + " is only required for optional features.");
        System.out.println("  - For more information, see http://www.opennms.org/index.php/" + libname);
        return null;
    }

    public boolean loadLibrary(String path) {
        try {
            System.out.print("  - trying to load " + path + ": ");
            System.load(path);
            System.out.println("OK");
            return true;
        }
        catch (UnsatisfiedLinkError ule) {
            System.out.println("NO");
            return false;
        }
    }

    public void writeLibraryConfig(String jicmp_path, String jicmp6_path, String jrrd_path, String jrrd2_path) throws IOException {
        Properties libraryProps = new Properties();
        if (jicmp_path != null && jicmp_path.length() != 0) {
            libraryProps.put("opennms.library.jicmp", jicmp_path);
        }
        if (jicmp6_path != null && jicmp6_path.length() != 0) {
            libraryProps.put("opennms.library.jicmp6", jicmp6_path);
        }
        if (jrrd_path != null && jrrd_path.length() != 0) {
            libraryProps.put("opennms.library.jrrd", jrrd_path);
        }
        if (jrrd2_path != null && jrrd2_path.length() != 0) {
            libraryProps.put("opennms.library.jrrd2", jrrd2_path);
        }
        File f = null;
        try {
            f = new File(this.m_opennms_home + File.separator + "etc" + File.separator + LIBRARY_PROPERTY_FILE);
            if (!f.createNewFile()) {
                LOG.warn("Could not create file: {}", (Object)f.getPath());
            }
            FileOutputStream os = new FileOutputStream(f);
            libraryProps.store(os, null);
        }
        catch (IOException e) {
            System.out.println("unable to write to " + f.getPath());
            throw e;
        }
    }

    public void pingLocalhost() throws Exception {
        Pinger pinger;
        String host = "127.0.0.1";
        InetAddress addr = null;
        try {
            addr = InetAddress.getByName(host);
        }
        catch (UnknownHostException e) {
            System.out.println("UnknownHostException when looking up " + host + ".");
            throw e;
        }
        try {
            pinger = new BestMatchPingerFactory().getInstance();
        }
        catch (UnsatisfiedLinkError e) {
            System.out.println("UnsatisfiedLinkError while creating an ICMP Pinger.  Most likely failed to load libjicmp.so.  Try setting the property 'opennms.library.jicmp' to point at the full path name of the libjicmp.so shared library or switch to using the JnaPinger (e.g. 'java -Dopennms.library.jicmp=/some/path/libjicmp.so ...')\nYou can also set the 'opennms.library.jicmp6' property in the same manner to specify the location of the JICMP6 library.");
            throw e;
        }
        catch (NoClassDefFoundError e) {
            System.out.println("NoClassDefFoundError while creating an IcmpSocket.  Most likely failed to load libjicmp.soor libjicmp6.so.");
            throw e;
        }
        catch (Exception e) {
            System.out.println("Exception while creating Pinger.");
            throw e;
        }
        System.out.print("Pinging " + host + " (" + addr + ")...");
        Number rtt = pinger.ping(addr);
        if (rtt == null) {
            System.out.println("failed.!");
        } else {
            System.out.printf("successful.. round trip time: %.3f ms%n", rtt.doubleValue() / 1000.0);
        }
    }
}

