/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.provision.service.requisition;

import java.net.URI;
import java.util.Map;
import org.apache.http.HttpResponse;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.impl.client.BasicResponseHandler;
import org.opennms.core.web.HttpClientWrapper;
import org.opennms.core.xml.JaxbUtils;
import org.opennms.netmgt.provision.persist.AbstractRequisitionProvider;
import org.opennms.netmgt.provision.persist.requisition.Requisition;
import org.opennms.netmgt.provision.service.requisition.HttpRequisitionRequest;

public class HttpRequisitionProvider
extends AbstractRequisitionProvider<HttpRequisitionRequest> {
    public static final String TYPE_NAME = "http";

    public HttpRequisitionProvider() {
        super(HttpRequisitionRequest.class);
    }

    public String getType() {
        return TYPE_NAME;
    }

    public HttpRequisitionRequest getRequest(Map<String, String> parameters) {
        return new HttpRequisitionRequest(parameters);
    }

    /*
     * Enabled aggressive exception aggregation
     */
    public Requisition getRequisitionFor(HttpRequisitionRequest request) {
        try (HttpClientWrapper client = HttpClientWrapper.create();){
            Requisition requisition;
            block17: {
                URI uri = new URI(request.getUrl());
                HttpGet get = new HttpGet(uri);
                if (Boolean.FALSE.equals(request.getStrictSsl())) {
                    client.trustSelfSigned(uri.getScheme());
                }
                if (Boolean.TRUE.equals(request.getUseSystemProxy())) {
                    client.useSystemProxySettings();
                }
                if (request.getUsername() != null) {
                    client.addBasicCredentials(request.getPassword(), request.getPassword());
                }
                CloseableHttpResponse response = client.execute((HttpUriRequest)get);
                try {
                    String responseString = new BasicResponseHandler().handleResponse((HttpResponse)response);
                    requisition = (Requisition)JaxbUtils.unmarshal(Requisition.class, (String)responseString);
                    if (response == null) break block17;
                }
                catch (Throwable throwable) {
                    if (response != null) {
                        try {
                            response.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                response.close();
            }
            return requisition;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }
}

