/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.telemetry.protocols.bmp.adapter.stats;

import java.io.IOException;
import java.util.Optional;
import org.apache.commons.net.whois.WhoisClient;
import org.opennms.netmgt.telemetry.protocols.bmp.adapter.stats.AsnInfo;
import org.opennms.netmgt.telemetry.protocols.bmp.adapter.stats.RouteInfo;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class BmpWhoIsClient {
    private static final Logger LOG = LoggerFactory.getLogger(BmpWhoIsClient.class);
    private static String[] hosts = new String[]{"whois.arin.net", "whois.ripe.net", "whois.apnic.net", "whois.afrinic.net", "whois.lacnic.net", "rr.ntt.net"};

    BmpWhoIsClient() {
    }

    public static Optional<AsnInfo> getAsnInfo(Long asn) {
        WhoisClient whoisClient = new WhoisClient();
        Optional<AsnInfo> asnInfo = Optional.empty();
        for (String host : hosts) {
            try {
                whoisClient.connect(host, 43);
                String output = whoisClient.query("AS" + asn);
                whoisClient.disconnect();
                if (!output.contains("ASName") && !output.contains("as-name")) continue;
                asnInfo = Optional.of(AsnInfo.parseOutput(asn, host, output));
                break;
            }
            catch (IOException e) {
                LOG.warn("Exception while fetching whois info with host `{}` for asn = {} ", new Object[]{host, asn, e});
            }
        }
        return asnInfo;
    }

    static Optional<RouteInfo> getRouteInfo(String prefix) {
        WhoisClient whoisClient = new WhoisClient();
        Optional<RouteInfo> routeInfo = Optional.empty();
        for (String host : hosts) {
            try {
                whoisClient.connect(host, 43);
                String rawOutput = whoisClient.query(prefix);
                whoisClient.disconnect();
                if (!rawOutput.contains("route")) continue;
                RouteInfo parsed = RouteInfo.parseOneRecord(rawOutput);
                if (parsed.getPrefix() != null && parsed.getPrefixLen() != null && parsed.getOriginAs() != null) {
                    routeInfo = Optional.of(parsed);
                    break;
                }
                LOG.warn("Not able to parse RouteInfo from {}", (Object)rawOutput);
            }
            catch (IOException e) {
                LOG.warn("Exception while fetching whois info with host `{}` for prefix = {} ", new Object[]{host, prefix, e});
            }
        }
        return routeInfo;
    }
}

