/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.measurements.shell;

import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import org.apache.karaf.shell.api.action.Action;
import org.apache.karaf.shell.api.action.Argument;
import org.apache.karaf.shell.api.action.Command;
import org.apache.karaf.shell.api.action.Option;
import org.apache.karaf.shell.api.action.lifecycle.Reference;
import org.apache.karaf.shell.api.action.lifecycle.Service;
import org.opennms.netmgt.dao.api.ResourceDao;
import org.opennms.netmgt.measurements.api.MeasurementsService;
import org.opennms.netmgt.measurements.api.exceptions.MeasurementException;
import org.opennms.netmgt.measurements.model.QueryRequest;
import org.opennms.netmgt.measurements.model.QueryResponse;
import org.opennms.netmgt.measurements.model.Source;
import org.opennms.netmgt.model.OnmsResource;
import org.opennms.netmgt.model.ResourceId;

@Command(scope="opennms", name="show-measurements", description="Measurements")
@Service
public class ShowMeasurements
implements Action {
    @Reference
    ResourceDao resourceDao;
    @Reference
    MeasurementsService measurementsService;
    @Option(name="-a", aliases={"--attribute"}, description="Attribute", multiValued=true)
    List<String> attributesSelected;
    @Option(name="-i", aliases={"--interval"}, description="Requested step interval (ms)")
    long stepMs = TimeUnit.MINUTES.toMillis(5L);
    @Option(name="-t", aliases={"--raw-timestamps"}, description="Display timestamps as milliseconds from epoch")
    boolean rawTimestamps = false;
    @Option(name="-s", aliases={"--start"}, description="Start Timestamp (epoch ms)")
    long start = System.currentTimeMillis() - TimeUnit.HOURS.toMillis(1L);
    @Option(name="-e", aliases={"--end"}, description="End Timestamp (epoch ms)")
    long end = System.currentTimeMillis();
    @Argument(index=0, name="resourceId", description="Resource ID", required=true)
    String resourceId;

    public Object execute() throws MeasurementException {
        ResourceId resourceIdd = ResourceId.fromString((String)this.resourceId);
        OnmsResource resource = this.resourceDao.getResourceById(resourceIdd);
        if (resource == null) {
            System.out.printf("No resource with ID '%s' found.\n", this.resourceId);
            return null;
        }
        Map attrsByName = resource.getRrdGraphAttributes();
        System.out.printf("Resource with ID '%s' has attributes: %s\n", this.resourceId, attrsByName.keySet());
        Set<Object> filteredAttrNames = attrsByName.keySet();
        if (this.attributesSelected != null && !this.attributesSelected.isEmpty()) {
            filteredAttrNames = attrsByName.keySet().stream().filter(a -> this.attributesSelected.contains(a)).collect(Collectors.toSet());
            System.out.printf("Limiting attributes to: %s\n", filteredAttrNames);
        }
        QueryRequest queryRequest = new QueryRequest();
        queryRequest.setStart(this.start);
        queryRequest.setEnd(this.end);
        queryRequest.setStep(this.stepMs);
        for (String string : filteredAttrNames) {
            Source source = new Source();
            source.setAttribute(string);
            source.setLabel(string);
            source.setAggregation("AVERAGE");
            source.setResourceId(this.resourceId);
            queryRequest.getSources().add(source);
        }
        QueryResponse queryResponse = this.measurementsService.query(queryRequest);
        System.out.println();
        this.printResponseAsTable(queryResponse);
        return null;
    }

    private void printResponseAsTable(QueryResponse queryResponse) {
        long[] timestamps = queryResponse.getTimestamps();
        String[] labels = queryResponse.getLabels();
        QueryResponse.WrappedPrimitive[] columns = queryResponse.getColumns();
        System.out.print("timestamp");
        for (String label : labels) {
            System.out.printf(",%s", label);
        }
        System.out.println();
        for (int i = 0; i < timestamps.length; ++i) {
            if (this.rawTimestamps) {
                System.out.printf("%d", timestamps[i]);
            } else {
                System.out.printf("%s", new Date(timestamps[i]));
            }
            for (int k = 0; k < labels.length; ++k) {
                System.out.printf(",%.4f", columns[k].getList()[i]);
            }
            System.out.println();
        }
    }
}

