/*
 * Decompiled with CFR 0.152.
 */
package org.apache.felix.framework.security.permissionadmin;

import java.io.IOException;
import java.security.Permission;
import java.security.ProtectionDomain;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.apache.felix.framework.cache.Content;
import org.apache.felix.framework.security.condpermadmin.ConditionalPermissionAdminImpl;
import org.apache.felix.framework.security.util.Permissions;
import org.apache.felix.framework.security.util.PropertiesCache;
import org.osgi.framework.Bundle;
import org.osgi.service.permissionadmin.PermissionAdmin;
import org.osgi.service.permissionadmin.PermissionInfo;

public final class PermissionAdminImpl
implements PermissionAdmin {
    private static final PermissionInfo[] ALL_PERMISSION = new PermissionInfo[]{new PermissionInfo((class$java$security$AllPermission == null ? (class$java$security$AllPermission = PermissionAdminImpl.class$("java.security.AllPermission")) : class$java$security$AllPermission).getName(), "", "")};
    private final Map m_store = new HashMap();
    private final PropertiesCache m_cache;
    private final Permissions m_permissions;
    private PermissionInfo[] m_default = null;
    static /* synthetic */ Class class$java$security$AllPermission;
    static /* synthetic */ Class array$Lorg$osgi$service$permissionadmin$PermissionInfo;

    public PermissionAdminImpl(Permissions permissions, PropertiesCache cache) throws IOException {
        this.m_permissions = permissions;
        this.m_cache = cache;
        this.m_cache.read(array$Lorg$osgi$service$permissionadmin$PermissionInfo == null ? (array$Lorg$osgi$service$permissionadmin$PermissionInfo = PermissionAdminImpl.class$("[Lorg.osgi.service.permissionadmin.PermissionInfo;")) : array$Lorg$osgi$service$permissionadmin$PermissionInfo, this.m_store);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public PermissionInfo[] getDefaultPermissions() {
        Map map = this.m_store;
        synchronized (map) {
            if (this.m_default == null) {
                return null;
            }
            return (PermissionInfo[])this.m_default.clone();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized String[] getLocations() {
        Map map = this.m_store;
        synchronized (map) {
            if (this.m_store.isEmpty()) {
                return null;
            }
            return this.m_store.keySet().toArray(new String[this.m_store.size()]);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public PermissionInfo[] getPermissions(String location) {
        Map map = this.m_store;
        synchronized (map) {
            if (this.m_store.containsKey(location)) {
                return (PermissionInfo[])((PermissionInfo[])this.m_store.get(location)).clone();
            }
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Boolean hasPermission(String location, Bundle bundle, Permission permission, ConditionalPermissionAdminImpl cpai, ProtectionDomain pd, Content content) {
        PermissionInfo[] permissions = null;
        PermissionInfo[] defaults = null;
        boolean contains = false;
        Map map = this.m_store;
        synchronized (map) {
            contains = this.m_store.containsKey(location);
            permissions = (PermissionInfo[])this.m_store.get(location);
            defaults = this.m_default;
        }
        if (contains) {
            if (this.check(permissions, permission, bundle)) {
                return Boolean.TRUE;
            }
            return this.check(this.m_permissions.getImplicit(bundle), permission, bundle) ? Boolean.TRUE : Boolean.FALSE;
        }
        if (cpai == null || cpai.isEmpty() && cpai.impliesLocal(bundle, content, permission)) {
            if (defaults != null) {
                if (this.check(defaults, permission, null)) {
                    return Boolean.TRUE;
                }
                return this.check(this.m_permissions.getImplicit(bundle), permission, bundle) ? Boolean.TRUE : Boolean.FALSE;
            }
            return Boolean.TRUE;
        }
        return null;
    }

    private boolean check(PermissionInfo[] permissions, Permission permission, Bundle bundle) {
        Permissions permissionsObject = this.m_permissions.getPermissions(permissions);
        return permissionsObject.implies(permission, bundle);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setDefaultPermissions(PermissionInfo[] permissions) {
        SecurityManager sm = System.getSecurityManager();
        if (sm != null) {
            sm.checkPermission(Permissions.ALL_PERMISSION);
        }
        PropertiesCache propertiesCache = this.m_cache;
        synchronized (propertiesCache) {
            PermissionInfo[] def = null;
            HashMap store = null;
            Map map = this.m_store;
            synchronized (map) {
                def = this.m_default;
                store = new HashMap(this.m_store);
                this.m_default = permissions != null ? this.notNull(permissions) : null;
            }
            try {
                this.m_cache.write(this.setDefaults(store, def));
            }
            catch (IOException ex) {
                Map map2 = this.m_store;
                synchronized (map2) {
                    this.m_default = def;
                }
                ex.printStackTrace();
                throw new IllegalStateException(ex.getMessage());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setPermissions(String location, PermissionInfo[] permissions) {
        SecurityManager sm = System.getSecurityManager();
        if (sm != null) {
            sm.checkPermission(Permissions.ALL_PERMISSION);
        }
        PropertiesCache propertiesCache = this.m_cache;
        synchronized (propertiesCache) {
            if (location != null) {
                HashMap store = null;
                HashMap storeCopy = null;
                PermissionInfo[] def = null;
                Map map = this.m_store;
                synchronized (map) {
                    storeCopy = new HashMap(this.m_store);
                    if (permissions != null) {
                        this.m_store.put(location, this.notNull(permissions));
                    } else {
                        this.m_store.remove(location);
                    }
                    store = new HashMap(this.m_store);
                }
                try {
                    this.m_cache.write(this.setDefaults(store, def));
                }
                catch (IOException ex) {
                    Map map2 = this.m_store;
                    synchronized (map2) {
                        this.m_store.clear();
                        this.m_store.putAll(storeCopy);
                    }
                    ex.printStackTrace();
                    throw new IllegalStateException(ex.getMessage());
                }
            }
        }
    }

    private Map setDefaults(Map store, PermissionInfo[] def) {
        if (def != null) {
            store.put("DEFAULT", def);
        } else {
            store.remove("DEFAULT");
        }
        return store;
    }

    private PermissionInfo[] notNull(PermissionInfo[] permissions) {
        ArrayList<PermissionInfo> result = new ArrayList<PermissionInfo>();
        for (int i = 0; i < permissions.length; ++i) {
            if (permissions[i] == null) continue;
            result.add(permissions[i]);
        }
        return result.toArray(new PermissionInfo[result.size()]);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

