/*
 * Decompiled with CFR 0.152.
 */
package org.jolokia.client;

import java.io.IOException;
import org.apache.http.HttpException;
import org.apache.http.HttpHost;
import org.apache.http.HttpRequest;
import org.apache.http.HttpRequestInterceptor;
import org.apache.http.auth.AuthScheme;
import org.apache.http.auth.AuthScope;
import org.apache.http.auth.AuthState;
import org.apache.http.auth.Credentials;
import org.apache.http.auth.UsernamePasswordCredentials;
import org.apache.http.client.CredentialsProvider;
import org.apache.http.impl.auth.BasicScheme;
import org.apache.http.impl.client.BasicCredentialsProvider;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.http.protocol.HttpContext;
import org.jolokia.client.J4pAuthenticator;

public class BasicAuthenticator
implements J4pAuthenticator {
    private boolean preemptive = false;

    public BasicAuthenticator() {
        this(false);
    }

    public BasicAuthenticator(boolean pPreemptive) {
        this.preemptive = pPreemptive;
    }

    public J4pAuthenticator preemptive() {
        this.preemptive = true;
        return this;
    }

    @Override
    public void authenticate(HttpClientBuilder pBuilder, String pUser, String pPassword) {
        BasicCredentialsProvider credentialsProvider = new BasicCredentialsProvider();
        credentialsProvider.setCredentials(new AuthScope(AuthScope.ANY), (Credentials)new UsernamePasswordCredentials(pUser, pPassword));
        pBuilder.setDefaultCredentialsProvider((CredentialsProvider)credentialsProvider);
        if (this.preemptive) {
            pBuilder.addInterceptorFirst((HttpRequestInterceptor)new PreemptiveAuthInterceptor((AuthScheme)new BasicScheme()));
        }
    }

    static class PreemptiveAuthInterceptor
    implements HttpRequestInterceptor {
        private AuthScheme authScheme;

        PreemptiveAuthInterceptor(AuthScheme pScheme) {
            this.authScheme = pScheme;
        }

        public void process(HttpRequest request, HttpContext context) throws HttpException, IOException {
            AuthState authState = (AuthState)context.getAttribute("http.auth.target-scope");
            if (authState.getAuthScheme() == null) {
                HttpHost targetHost;
                CredentialsProvider credsProvider = (CredentialsProvider)context.getAttribute("http.auth.credentials-provider");
                Credentials creds = credsProvider.getCredentials(new AuthScope((targetHost = (HttpHost)context.getAttribute("http.target_host")).getHostName(), targetHost.getPort()));
                if (creds == null) {
                    throw new HttpException("No credentials given for preemptive authentication");
                }
                authState.update(this.authScheme, creds);
            }
        }
    }
}

