/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.features.topology.plugins.topo.bsm;

import org.opennms.features.topology.api.topo.AbstractEdge;
import org.opennms.features.topology.api.topo.VertexRef;
import org.opennms.features.topology.plugins.topo.bsm.AbstractBusinessServiceVertex;
import org.opennms.netmgt.bsm.service.model.functions.map.MapFunction;
import org.opennms.netmgt.bsm.service.model.graph.GraphEdge;

public class BusinessServiceEdge
extends AbstractEdge {
    private final AbstractBusinessServiceVertex source;
    private final AbstractBusinessServiceVertex target;
    private final MapFunction mapFunction;
    private final float weight;

    public BusinessServiceEdge(GraphEdge graphEdge, AbstractBusinessServiceVertex source, AbstractBusinessServiceVertex target) {
        super("bsm", String.format("connection:%s:%s", source.getId(), target.getId()), (VertexRef)source, (VertexRef)target);
        this.source = source;
        this.target = target;
        this.mapFunction = graphEdge.getMapFunction();
        this.weight = graphEdge.getWeight();
        this.setTooltipText(String.format("Map function: %s, Weight: %s", graphEdge.getMapFunction().getClass().getSimpleName(), graphEdge.getWeight()));
    }

    private BusinessServiceEdge(BusinessServiceEdge edgeToClone) {
        super((AbstractEdge)edgeToClone);
        this.source = edgeToClone.source;
        this.target = edgeToClone.target;
        this.mapFunction = edgeToClone.mapFunction;
        this.weight = edgeToClone.weight;
    }

    public AbstractEdge clone() {
        return new BusinessServiceEdge(this);
    }

    public AbstractBusinessServiceVertex getBusinessServiceSource() {
        return this.source;
    }

    public AbstractBusinessServiceVertex getBusinessServiceTarget() {
        return this.target;
    }

    public MapFunction getMapFunction() {
        return this.mapFunction;
    }

    public float getWeight() {
        return this.weight;
    }
}

