/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.threshd;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.Lists;
import java.util.List;
import java.util.Objects;
import java.util.Timer;
import java.util.TimerTask;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import javax.annotation.PostConstruct;
import org.opennms.core.soa.ServiceRegistry;
import org.opennms.core.soa.lookup.ServiceLookup;
import org.opennms.core.soa.lookup.ServiceLookupBuilder;
import org.opennms.core.soa.lookup.ServiceRegistryLookup;
import org.opennms.core.soa.support.DefaultServiceRegistry;
import org.opennms.features.distributed.kvstore.api.BlobStore;
import org.opennms.netmgt.collection.api.ServiceParameters;
import org.opennms.netmgt.config.dao.thresholding.api.ReadableThreshdDao;
import org.opennms.netmgt.config.dao.thresholding.api.ReadableThresholdingDao;
import org.opennms.netmgt.dao.api.ResourceStorageDao;
import org.opennms.netmgt.events.api.EventForwarder;
import org.opennms.netmgt.events.api.EventIpcManager;
import org.opennms.netmgt.events.api.EventListener;
import org.opennms.netmgt.events.api.model.IEvent;
import org.opennms.netmgt.events.api.model.IParm;
import org.opennms.netmgt.threshd.ThresholdingEventProxyImpl;
import org.opennms.netmgt.threshd.ThresholdingSessionImpl;
import org.opennms.netmgt.threshd.ThresholdingSessionKeyImpl;
import org.opennms.netmgt.threshd.ThresholdingSetImpl;
import org.opennms.netmgt.threshd.ThresholdingVisitorImpl;
import org.opennms.netmgt.threshd.api.ThresholdInitializationException;
import org.opennms.netmgt.threshd.api.ThresholdStateMonitor;
import org.opennms.netmgt.threshd.api.ThresholdingEventProxy;
import org.opennms.netmgt.threshd.api.ThresholdingService;
import org.opennms.netmgt.threshd.api.ThresholdingSession;
import org.opennms.netmgt.threshd.api.ThresholdingSetPersister;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;

public class ThresholdingServiceImpl
implements ThresholdingService,
EventListener {
    private static final Logger LOG = LoggerFactory.getLogger(ThresholdingServiceImpl.class);
    public static final List<String> UEI_LIST = Lists.newArrayList((Object[])new String[]{"uei.opennms.org/nodes/nodeGainedService", "uei.opennms.org/nodes/nodeCategoryMembershipChanged", "uei.opennms.org/internal/reloadDaemonConfig", "uei.opennms.org/internal/thresholdConfigChange"});
    private ThresholdingSetPersister thresholdingSetPersister;
    private ThresholdingEventProxy eventProxy;
    @Autowired
    private ResourceStorageDao resourceStorageDao;
    @Autowired
    private EventIpcManager eventIpcManager;
    private final AtomicReference<BlobStore> kvStore = new AtomicReference();
    @Autowired
    private ReadableThreshdDao threshdDao;
    @Autowired
    private ReadableThresholdingDao thresholdingDao;
    @Autowired
    private ThresholdStateMonitor thresholdStateMonitor;
    private static final ServiceLookup<Class<?>, String> SERVICE_LOOKUP = new ServiceLookupBuilder((ServiceLookup)new ServiceRegistryLookup((ServiceRegistry)DefaultServiceRegistry.INSTANCE)).blocking().build();
    private final Timer reInitializeTimer = new Timer();
    private boolean isDistributed = false;

    @PostConstruct
    private void init() {
        this.eventIpcManager.addEventListener((EventListener)this, UEI_LIST);
    }

    public void initOsgi() {
        this.isDistributed = true;
        this.reInitializeTimer.scheduleAtFixedRate(new TimerTask(){

            @Override
            public void run() {
                ThresholdingServiceImpl.this.reinitializeOnTimer();
            }
        }, 0L, TimeUnit.MILLISECONDS.convert(5L, TimeUnit.MINUTES));
    }

    private void reinitializeOnTimer() {
        this.thresholdingSetPersister.reinitializeThresholdingSets();
    }

    public String getName() {
        return "ThresholdingService";
    }

    public void onEvent(IEvent e) {
        switch (e.getUei()) {
            case "uei.opennms.org/nodes/nodeGainedService": {
                this.nodeGainedService(e);
                break;
            }
            case "uei.opennms.org/nodes/nodeCategoryMembershipChanged": {
                this.handleNodeCategoryChanged(e);
                break;
            }
            case "uei.opennms.org/internal/reloadDaemonConfig": {
                this.daemonReload(e);
                break;
            }
            case "uei.opennms.org/internal/thresholdConfigChange": {
                this.reinitializeThresholdingSets(e);
                break;
            }
            default: {
                LOG.debug("Unexpected Event for Thresholding: {}", (Object)e);
            }
        }
    }

    public void nodeGainedService(IEvent event) {
        LOG.debug(event.toString());
        this.threshdDao.rebuildPackageIpListMap();
        this.reinitializeThresholdingSets(event);
    }

    public void handleNodeCategoryChanged(IEvent event) {
        LOG.debug(event.toString());
        this.threshdDao.rebuildPackageIpListMap();
        this.reinitializeThresholdingSets(event);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ThresholdingSession createSession(int nodeId, String hostAddress, String serviceName, ServiceParameters serviceParams) throws ThresholdInitializationException {
        Objects.requireNonNull(serviceParams, "ServiceParameters must not be null");
        AtomicReference<BlobStore> atomicReference = this.kvStore;
        synchronized (atomicReference) {
            if (this.kvStore.get() == null) {
                this.waitForKvStore();
            }
        }
        ThresholdingSessionKeyImpl sessionKey = new ThresholdingSessionKeyImpl(nodeId, hostAddress, serviceName);
        return new ThresholdingSessionImpl(this, sessionKey, serviceParams, this.kvStore.get(), this.isDistributed, this.thresholdStateMonitor);
    }

    public ThresholdingVisitorImpl getThresholdingVistor(ThresholdingSession session, Long sequenceNumber) throws ThresholdInitializationException {
        ThresholdingSetImpl thresholdingSet = (ThresholdingSetImpl)this.thresholdingSetPersister.getThresholdingSet(session, this.eventProxy);
        return new ThresholdingVisitorImpl(thresholdingSet, this.eventProxy, sequenceNumber);
    }

    public EventIpcManager getEventIpcManager() {
        return this.eventIpcManager;
    }

    public void setEventIpcManager(EventIpcManager eventIpcManager) {
        this.eventIpcManager = eventIpcManager;
    }

    @Autowired
    public void setEventProxy(EventForwarder eventForwarder) {
        Objects.requireNonNull(eventForwarder);
        this.eventProxy = new ThresholdingEventProxyImpl(eventForwarder);
    }

    public ThresholdingSetPersister getThresholdingSetPersister() {
        return this.thresholdingSetPersister;
    }

    public void setThresholdingSetPersister(ThresholdingSetPersister thresholdingSetPersister) {
        this.thresholdingSetPersister = thresholdingSetPersister;
    }

    public void close(ThresholdingSessionImpl session) {
        this.thresholdingSetPersister.clear((ThresholdingSession)session);
    }

    private void daemonReload(IEvent event) {
        String thresholdsDaemonName = "Threshd";
        boolean isThresholds = false;
        for (IParm parm : event.getParmCollection()) {
            if (!"daemonName".equals(parm.getParmName()) || !"Threshd".equalsIgnoreCase(parm.getValue().getContent())) continue;
            isThresholds = true;
            break;
        }
        if (isThresholds) {
            try {
                this.threshdDao.reload();
                this.thresholdingDao.reload();
                this.thresholdingSetPersister.reinitializeThresholdingSets();
            }
            catch (Exception e) {
                throw new RuntimeException("Unable to reload thresholding.", e);
            }
        }
    }

    private void reinitializeThresholdingSets(IEvent e) {
        this.thresholdingSetPersister.reinitializeThresholdingSets();
    }

    private void waitForKvStore() {
        BlobStore osgiKvStore = (BlobStore)SERVICE_LOOKUP.lookup(BlobStore.class, null);
        if (osgiKvStore == null) {
            throw new RuntimeException("Timed out waiting for a key value store");
        }
        this.kvStore.set(osgiKvStore);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setKvStore(BlobStore keyValueStore) {
        Objects.requireNonNull(keyValueStore);
        AtomicReference<BlobStore> atomicReference = this.kvStore;
        synchronized (atomicReference) {
            if (this.kvStore.get() == null) {
                this.kvStore.set(keyValueStore);
            }
        }
    }

    @VisibleForTesting
    public void setDistributed(boolean distributed) {
        this.isDistributed = distributed;
    }

    public void setThresholdStateMonitor(ThresholdStateMonitor thresholdStateMonitor) {
        this.thresholdStateMonitor = Objects.requireNonNull(thresholdStateMonitor);
    }
}

