/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.bsm.service.model.graph.internal;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.opennms.netmgt.bsm.service.internal.DefaultBusinessServiceStateMachine;
import org.opennms.netmgt.bsm.service.model.Status;
import org.opennms.netmgt.bsm.service.model.StatusWithIndex;
import org.opennms.netmgt.bsm.service.model.StatusWithIndices;
import org.opennms.netmgt.bsm.service.model.graph.BusinessServiceGraph;
import org.opennms.netmgt.bsm.service.model.graph.GraphEdge;
import org.opennms.netmgt.bsm.service.model.graph.GraphVertex;

public class GraphAlgorithms {
    public static List<GraphVertex> calculateRootCause(BusinessServiceGraph graph, GraphVertex vertex) {
        if (vertex == null || vertex.getStatus().isLessThanOrEqual(Status.NORMAL)) {
            return Collections.emptyList();
        }
        List childVerticesWithImpact = GraphAlgorithms.calculateImpacting(graph, vertex).stream().map(e -> (GraphVertex)graph.getOpposite((Object)vertex, e)).sorted().collect(Collectors.toList());
        ArrayList causes = Lists.newArrayList(childVerticesWithImpact);
        for (GraphVertex childVertexWithImpact : childVerticesWithImpact) {
            causes.addAll(GraphAlgorithms.calculateRootCause(graph, childVertexWithImpact));
        }
        return causes;
    }

    public static List<GraphVertex> calculateImpact(BusinessServiceGraph graph, GraphVertex vertex) {
        if (vertex == null) {
            return Collections.emptyList();
        }
        List impactedParentVertices = graph.getInEdges((Object)vertex).stream().filter(e -> GraphAlgorithms.calculateImpacting(graph, (GraphVertex)graph.getOpposite((Object)vertex, e)).contains(e)).map(e -> (GraphVertex)graph.getOpposite((Object)vertex, e)).sorted().collect(Collectors.toList());
        ArrayList impacts = Lists.newArrayList(impactedParentVertices);
        for (GraphVertex impactedParentVertex : impactedParentVertices) {
            impacts.addAll(GraphAlgorithms.calculateImpact(graph, impactedParentVertex));
        }
        return impacts;
    }

    public static Set<GraphEdge> calculateImpacting(BusinessServiceGraph graph, GraphVertex parent) {
        List<GraphEdge> childEdges = graph.getOutEdges((Object)parent).stream().collect(Collectors.toList());
        List<StatusWithIndex> statuses = DefaultBusinessServiceStateMachine.weighEdges(childEdges);
        Optional reducedStatus = parent.getReductionFunction().reduce(statuses);
        if (!reducedStatus.isPresent()) {
            return Collections.emptySet();
        }
        return ((StatusWithIndices)reducedStatus.get()).getIndices().stream().map(childEdges::get).collect(Collectors.toSet());
    }
}

