/*
 * Decompiled with CFR 0.152.
 */
package io.searchbox.indices.reindex;

import com.google.gson.Gson;
import io.searchbox.action.AbstractAction;
import io.searchbox.action.GenericResultAbstractAction;
import java.util.HashMap;
import java.util.Map;

public class Reindex
extends GenericResultAbstractAction {
    private Object source;
    private Object destination;
    private Object script;
    Map<String, Object> body = new HashMap<String, Object>();

    Reindex(Builder builder) {
        super(builder);
        this.source = builder.source;
        this.destination = builder.dest;
        this.script = builder.script;
        if (builder.conflicts != null) {
            this.body.put("conflicts", builder.conflicts);
        }
        if (builder.size != null) {
            this.body.put("size", builder.size);
        }
        this.setURI(this.buildURI());
    }

    @Override
    public String getData(Gson gson) {
        if (this.source != null) {
            if (this.source instanceof String) {
                this.body.put("source", gson.fromJson((String)this.source, Map.class));
            } else if (this.source instanceof Map) {
                HashMap<String, Map> source = new HashMap<String, Map>((Map)this.source);
                Object query = source.get("query");
                if (query instanceof String) {
                    Map queryMap = (Map)gson.fromJson((String)query, Map.class);
                    source.put("query", queryMap);
                    this.body.put("source", source);
                } else {
                    this.body.put("source", this.source);
                }
            }
        }
        if (this.destination != null) {
            if (this.destination instanceof String) {
                this.body.put("dest", gson.fromJson((String)this.destination, Map.class));
            } else {
                this.body.put("dest", this.destination);
            }
        }
        if (this.script != null) {
            if (this.script instanceof String) {
                this.body.put("script", gson.fromJson((String)this.script, Map.class));
            } else if (this.script instanceof Map) {
                HashMap<String, Map> script = new HashMap<String, Map>((Map)this.script);
                Object params = script.get("params");
                if (params instanceof String) {
                    Map paramMap = (Map)gson.fromJson((String)params, Map.class);
                    script.put("params", paramMap);
                    this.body.put("script", script);
                } else {
                    this.body.put("script", this.script);
                }
            }
        }
        return gson.toJson(this.body);
    }

    @Override
    protected String buildURI() {
        return super.buildURI() + "/_reindex";
    }

    @Override
    public String getRestMethodName() {
        return "POST";
    }

    public static class Builder
    extends AbstractAction.Builder<Reindex, Builder> {
        private Object source;
        private Object dest;
        private String conflicts;
        private Long size;
        private Object script;

        public Builder(Object source, Object dest) {
            this.source = source;
            this.dest = dest;
        }

        public Builder conflicts(String conflicts) {
            this.conflicts = conflicts;
            return this;
        }

        public Builder size(Long size) {
            this.size = size;
            return this;
        }

        public Builder script(Object script) {
            this.script = script;
            return this;
        }

        public Builder waitForCompletion(boolean waitForCompletion) {
            return (Builder)this.setParameter("wait_for_completion", waitForCompletion);
        }

        public Builder waitForActiveShards(int waitForActiveShards) {
            return (Builder)this.setParameter("wait_for_active_shards", waitForActiveShards);
        }

        public Builder timeout(long timeout) {
            return (Builder)this.setParameter("timeout", timeout);
        }

        public Builder requestsPerSecond(double requestsPerSecond) {
            return (Builder)this.setParameter("requests_per_second", requestsPerSecond);
        }

        @Override
        public Reindex build() {
            return new Reindex(this);
        }
    }
}

