/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.config;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Strings;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.StringWriter;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.net.InetAddress;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.apache.commons.io.IOUtils;
import org.opennms.core.config.api.TextEncryptor;
import org.opennms.core.mate.api.EntityScopeProvider;
import org.opennms.core.mate.api.Interpolator;
import org.opennms.core.mate.api.Scope;
import org.opennms.core.spring.BeanUtils;
import org.opennms.core.spring.FileReloadCallback;
import org.opennms.core.spring.FileReloadContainer;
import org.opennms.core.utils.ByteArrayComparator;
import org.opennms.core.utils.ConfigFileConstants;
import org.opennms.core.utils.InetAddressUtils;
import org.opennms.core.utils.LocationUtils;
import org.opennms.core.xml.JaxbUtils;
import org.opennms.netmgt.config.SnmpConfigManager;
import org.opennms.netmgt.config.SnmpEventInfo;
import org.opennms.netmgt.config.api.SnmpAgentConfigFactory;
import org.opennms.netmgt.config.snmp.AddressSnmpConfigVisitor;
import org.opennms.netmgt.config.snmp.Configuration;
import org.opennms.netmgt.config.snmp.Definition;
import org.opennms.netmgt.config.snmp.Range;
import org.opennms.netmgt.config.snmp.SnmpConfig;
import org.opennms.netmgt.config.snmp.SnmpConfigVisitor;
import org.opennms.netmgt.config.snmp.SnmpProfile;
import org.opennms.netmgt.snmp.SnmpAgentConfig;
import org.opennms.netmgt.snmp.SnmpConfiguration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.FatalBeanException;
import org.springframework.core.io.FileSystemResource;
import org.springframework.core.io.Resource;

public class SnmpPeerFactory
implements SnmpAgentConfigFactory {
    private static final Logger LOG = LoggerFactory.getLogger(SnmpPeerFactory.class);
    private static final int VERSION_UNSPECIFIED = -1;
    private static final String SNMP_ENCRYPTION_CONTEXT = "snmp-config";
    protected static final String ENCRYPTION_ENABLED = "org.opennms.snmp.encryption.enabled";
    private static File s_configFile;
    private static SnmpPeerFactory s_singleton;
    private static AtomicBoolean s_loaded;
    private final ReadWriteLock m_lock = new ReentrantReadWriteLock();
    private SnmpConfig m_config;
    private FileReloadContainer<SnmpConfig> m_container;
    private FileReloadCallback<SnmpConfig> m_callback;
    private TextEncryptor textEncryptor;
    private final Boolean encryptionEnabled = Boolean.getBoolean("org.opennms.snmp.encryption.enabled");
    private static Scope secureCredentialsVaultScope;

    public SnmpPeerFactory(Resource resource) {
        LOG.debug("creating new instance for resource {}: {}", (Object)resource, (Object)this);
        SnmpConfig config = (SnmpConfig)JaxbUtils.unmarshal(SnmpConfig.class, (Resource)resource);
        try {
            File file = resource.getFile();
            if (file != null) {
                this.m_callback = new FileReloadCallback<SnmpConfig>(){

                    public SnmpConfig reload(SnmpConfig object, Resource resource) throws IOException {
                        return (SnmpConfig)JaxbUtils.unmarshal(SnmpConfig.class, (Resource)resource);
                    }
                };
                this.m_container = new FileReloadContainer((Object)config, resource, this.m_callback);
                return;
            }
        }
        catch (IOException e) {
            LOG.debug("No file associated with resource {}, skipping reload container initialization. Reason: ", (Object)resource, (Object)e.getMessage());
        }
        this.m_config = config;
    }

    private Lock getReadLock() {
        return this.m_lock.readLock();
    }

    private Lock getWriteLock() {
        return this.m_lock.writeLock();
    }

    public static synchronized void init() throws IOException {
        if (!s_loaded.get()) {
            File cfgFile = SnmpPeerFactory.getFile();
            LOG.debug("init: config file path: {}", (Object)cfgFile.getPath());
            FileSystemResource resource = new FileSystemResource(cfgFile);
            s_singleton = new SnmpPeerFactory((Resource)resource);
            s_loaded.set(true);
        }
        if (SnmpPeerFactory.s_singleton.encryptionEnabled.booleanValue()) {
            s_singleton.encryptSnmpConfig();
        }
    }

    private void encryptSnmpConfig() {
        this.initializeTextEncryptor();
        if (this.textEncryptor != null) {
            try {
                s_singleton.saveCurrent();
            }
            catch (IOException e) {
                LOG.debug("Exception while saving encrypted credentials");
            }
        }
    }

    public static void setSecureCredentialsVaultScope(Scope secureCredentialsVaultScope) {
        SnmpPeerFactory.secureCredentialsVaultScope = secureCredentialsVaultScope;
    }

    public static synchronized SnmpPeerFactory getInstance() {
        if (!s_loaded.get()) {
            try {
                SnmpPeerFactory.init();
            }
            catch (IOException e) {
                LOG.error("Failed to initialize SnmpPeerFactory instance!", (Throwable)e);
            }
        }
        return s_singleton;
    }

    public static synchronized void setInstance(SnmpPeerFactory singleton) {
        LOG.debug("setting new singleton instance {}", (Object)singleton);
        s_singleton = singleton;
        s_loaded.set(true);
    }

    public static synchronized File getFile() throws IOException {
        if (s_configFile == null) {
            SnmpPeerFactory.setFile(ConfigFileConstants.getFile((int)ConfigFileConstants.SNMP_CONF_FILE_NAME));
        }
        return s_configFile;
    }

    public static synchronized void setFile(File configFile) {
        File oldFile = s_configFile;
        s_configFile = configFile;
        if (oldFile == null || s_configFile == null || !oldFile.equals(s_configFile)) {
            s_singleton = null;
            s_loaded.set(false);
        }
    }

    public void saveCurrent() throws IOException {
        this.saveToFile(SnmpPeerFactory.getFile());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void saveToFile(File file) throws UnsupportedEncodingException, FileNotFoundException, IOException {
        this.getWriteLock().lock();
        try {
            String marshalledConfig = this.getSnmpConfigAsString();
            FileOutputStream out = null;
            OutputStreamWriter fileWriter = null;
            try {
                if (marshalledConfig != null) {
                    out = new FileOutputStream(file);
                    fileWriter = new OutputStreamWriter((OutputStream)out, StandardCharsets.UTF_8);
                    fileWriter.write(marshalledConfig);
                    ((Writer)fileWriter).flush();
                    ((Writer)fileWriter).close();
                    if (this.m_container != null) {
                        this.m_container.reload();
                    }
                }
            }
            finally {
                IOUtils.closeQuietly(fileWriter);
                IOUtils.closeQuietly(out);
            }
        }
        finally {
            this.getWriteLock().unlock();
        }
    }

    private static synchronized Scope getSecureCredentialsScope() {
        if (secureCredentialsVaultScope == null) {
            try {
                EntityScopeProvider entityScopeProvider = (EntityScopeProvider)BeanUtils.getBean((String)"daoContext", (String)"entityScopeProvider", EntityScopeProvider.class);
                if (entityScopeProvider != null) {
                    secureCredentialsVaultScope = entityScopeProvider.getScopeForScv();
                } else {
                    LOG.warn("SnmpPeerFactory: EntityScopeProvider is null, SecureCredentialsVault not available for metadata interpolation");
                }
            }
            catch (FatalBeanException e) {
                LOG.warn("SnmpPeerFactory: Error retrieving EntityScopeProvider bean");
            }
        }
        return secureCredentialsVaultScope;
    }

    public SnmpAgentConfig getAgentConfig(InetAddress agentAddress, boolean metaDataInterpolation) {
        return this.getAgentConfig(agentAddress, null, -1, metaDataInterpolation);
    }

    public SnmpAgentConfig getAgentConfig(InetAddress agentAddress) {
        return this.getAgentConfig(agentAddress, null, -1, true);
    }

    public SnmpAgentConfig getAgentConfig(InetAddress agentAddress, String location) {
        return this.getAgentConfig(agentAddress, location, -1, true);
    }

    public SnmpAgentConfig getAgentConfigFromProfile(SnmpProfile snmpProfile, InetAddress address) {
        return this.getAgentConfigFromProfile(snmpProfile, address, true);
    }

    public SnmpAgentConfig getAgentConfig(InetAddress agentAddress, String location, boolean metaDataInterpolation) {
        return this.getAgentConfig(agentAddress, location, -1, metaDataInterpolation);
    }

    public SnmpAgentConfig getAgentConfigFromProfile(SnmpProfile snmpProfile, InetAddress address, boolean metaDataInterpolation) {
        SnmpAgentConfig agentConfig = new SnmpAgentConfig(address);
        AddressSnmpConfigVisitor visitor = new AddressSnmpConfigVisitor(address);
        visitor.visitSnmpConfig(this.getSnmpConfig());
        snmpProfile.visit((SnmpConfigVisitor)visitor);
        Definition definition = visitor.getDefinition();
        this.setSnmpAgentConfig(agentConfig, definition, -1);
        agentConfig.setDefault(false);
        agentConfig.setProfileLabel(snmpProfile.getLabel());
        if (!metaDataInterpolation) {
            return agentConfig;
        }
        Scope scope = SnmpPeerFactory.getSecureCredentialsScope();
        if (scope != null) {
            agentConfig.setSecurityName(Interpolator.interpolate((String)agentConfig.getSecurityName(), (Scope)scope).output);
            agentConfig.setReadCommunity(Interpolator.interpolate((String)agentConfig.getReadCommunity(), (Scope)scope).output);
            agentConfig.setWriteCommunity(Interpolator.interpolate((String)agentConfig.getWriteCommunity(), (Scope)scope).output);
            agentConfig.setAuthPassPhrase(Interpolator.interpolate((String)agentConfig.getAuthPassPhrase(), (Scope)scope).output);
            agentConfig.setPrivPassPhrase(Interpolator.interpolate((String)agentConfig.getPrivPassPhrase(), (Scope)scope).output);
        } else {
            LOG.warn("Failed metadata interpolation for SNMP profile {}/{}", (Object)snmpProfile.getLabel(), (Object)InetAddressUtils.str((InetAddress)address));
        }
        return agentConfig;
    }

    public SnmpAgentConfig getAgentConfig(InetAddress agentInetAddress, int requestedSnmpVersion) {
        return this.getAgentConfig(agentInetAddress, null, requestedSnmpVersion, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SnmpAgentConfig getAgentConfig(InetAddress agentInetAddress, String location, int requestedSnmpVersion, boolean metaDataInterpolation) {
        this.getReadLock().lock();
        try {
            if (this.getSnmpConfig() == null) {
                SnmpAgentConfig agentConfig = new SnmpAgentConfig(agentInetAddress);
                if (requestedSnmpVersion == -1) {
                    agentConfig.setVersion(1);
                } else {
                    agentConfig.setVersion(requestedSnmpVersion);
                }
                SnmpAgentConfig snmpAgentConfig = agentConfig;
                return snmpAgentConfig;
            }
            SnmpAgentConfig agentConfig = new SnmpAgentConfig(agentInetAddress);
            this.setSnmpAgentConfig(agentConfig, new Definition(), requestedSnmpVersion);
            AddressSnmpConfigVisitor visitor = new AddressSnmpConfigVisitor(agentInetAddress, location);
            this.getSnmpConfig().visit((SnmpConfigVisitor)visitor);
            Definition matchingDef = visitor.getDefinition();
            if (!visitor.isMatchingDefaultConfig()) {
                agentConfig.setDefault(false);
            }
            if (matchingDef != null) {
                this.setSnmpAgentConfig(agentConfig, matchingDef, requestedSnmpVersion);
            }
            if (!metaDataInterpolation) {
                SnmpAgentConfig snmpAgentConfig = agentConfig;
                return snmpAgentConfig;
            }
            Scope scope = SnmpPeerFactory.getSecureCredentialsScope();
            if (scope != null) {
                agentConfig.setSecurityName(Interpolator.interpolate((String)agentConfig.getSecurityName(), (Scope)scope).output);
                agentConfig.setReadCommunity(Interpolator.interpolate((String)agentConfig.getReadCommunity(), (Scope)scope).output);
                agentConfig.setWriteCommunity(Interpolator.interpolate((String)agentConfig.getWriteCommunity(), (Scope)scope).output);
                agentConfig.setAuthPassPhrase(Interpolator.interpolate((String)agentConfig.getAuthPassPhrase(), (Scope)scope).output);
                agentConfig.setPrivPassPhrase(Interpolator.interpolate((String)agentConfig.getPrivPassPhrase(), (Scope)scope).output);
            } else {
                LOG.warn("Failed metadata interpolation for agent config {}/{}/{}", new Object[]{location, InetAddressUtils.str((InetAddress)agentInetAddress), requestedSnmpVersion});
            }
            SnmpAgentConfig snmpAgentConfig = agentConfig;
            return snmpAgentConfig;
        }
        finally {
            this.getReadLock().unlock();
        }
    }

    private void setSnmpAgentConfig(SnmpAgentConfig agentConfig, Definition def, int requestedSnmpVersion) {
        int version = this.getVersionCode(def, this.getSnmpConfig(), requestedSnmpVersion);
        this.setCommonAttributes(agentConfig, def, version);
        agentConfig.setSecurityLevel(def.getSecurityLevel().intValue());
        agentConfig.setSecurityName(def.getSecurityName());
        agentConfig.setAuthProtocol(def.getAuthProtocol());
        agentConfig.setAuthPassPhrase(def.getAuthPassphrase());
        agentConfig.setPrivPassPhrase(def.getPrivacyPassphrase());
        agentConfig.setPrivProtocol(def.getPrivacyProtocol());
        agentConfig.setReadCommunity(def.getReadCommunity());
        agentConfig.setWriteCommunity(def.getWriteCommunity());
        agentConfig.setContextName(def.getContextName());
        agentConfig.setEngineId(def.getEngineId());
        agentConfig.setContextEngineId(def.getContextEngineId());
        agentConfig.setEnterpriseId(def.getEnterpriseId());
        agentConfig.setProfileLabel(def.getProfileLabel());
    }

    private void setCommonAttributes(SnmpAgentConfig agentConfig, Definition def, int version) {
        agentConfig.setVersion(version);
        agentConfig.setPort(def.getPort().intValue());
        agentConfig.setRetries(def.getRetry().intValue());
        agentConfig.setTimeout(def.getTimeout().intValue());
        agentConfig.setMaxRequestSize(def.getMaxRequestSize().intValue());
        agentConfig.setMaxVarsPerPdu(def.getMaxVarsPerPdu().intValue());
        agentConfig.setMaxRepetitions(def.getMaxRepetitions().intValue());
        agentConfig.setTTL(def.getTTL());
        InetAddress proxyHost = InetAddressUtils.addr((String)def.getProxyHost());
        if (proxyHost != null) {
            agentConfig.setProxyFor(agentConfig.getAddress());
            agentConfig.setAddress(proxyHost);
        }
    }

    private void setDefinitionFromAgentConfig(Definition definition, SnmpAgentConfig snmpAgentConfig) {
        definition.setVersion(SnmpConfiguration.versionToString((int)snmpAgentConfig.getVersion()));
        definition.setPort(Integer.valueOf(snmpAgentConfig.getPort()));
        definition.setRetry(Integer.valueOf(snmpAgentConfig.getRetries()));
        definition.setTimeout(Integer.valueOf(snmpAgentConfig.getTimeout()));
        definition.setMaxRequestSize(Integer.valueOf(snmpAgentConfig.getMaxRequestSize()));
        definition.setMaxVarsPerPdu(Integer.valueOf(snmpAgentConfig.getMaxVarsPerPdu()));
        definition.setMaxRepetitions(Integer.valueOf(snmpAgentConfig.getMaxRepetitions()));
        definition.setTTL(snmpAgentConfig.getTTL());
        if (snmpAgentConfig.getProxyFor() != null) {
            definition.addSpecific(snmpAgentConfig.getProxyFor().getHostAddress());
            definition.setProxyHost(snmpAgentConfig.getAddress().getHostAddress());
        } else {
            definition.addSpecific(snmpAgentConfig.getAddress().getHostAddress());
        }
        if (1 != snmpAgentConfig.getSecurityLevel()) {
            definition.setSecurityLevel(Integer.valueOf(snmpAgentConfig.getSecurityLevel()));
        }
        if (!"opennmsUser".equals(snmpAgentConfig.getSecurityName())) {
            definition.setSecurityName(snmpAgentConfig.getSecurityName());
        }
        definition.setAuthProtocol(snmpAgentConfig.getAuthProtocol());
        definition.setAuthPassphrase(snmpAgentConfig.getAuthPassPhrase());
        definition.setPrivacyPassphrase(snmpAgentConfig.getPrivPassPhrase());
        definition.setPrivacyProtocol(snmpAgentConfig.getPrivProtocol());
        definition.setReadCommunity(snmpAgentConfig.getReadCommunity());
        definition.setWriteCommunity(snmpAgentConfig.getWriteCommunity());
        definition.setContextName(snmpAgentConfig.getContextName());
        definition.setEngineId(snmpAgentConfig.getEngineId());
        definition.setContextEngineId(snmpAgentConfig.getContextEngineId());
        definition.setEnterpriseId(snmpAgentConfig.getEnterpriseId());
        definition.setProfileLabel(snmpAgentConfig.getProfileLabel());
    }

    public int getVersionCode(Definition def, SnmpConfig config, int requestedSnmpVersion) {
        if (requestedSnmpVersion == -1) {
            if (def.getVersion() == null) {
                if (config.getVersion() == null) {
                    return 1;
                }
                return SnmpConfiguration.stringToVersion((String)config.getVersion());
            }
            return SnmpConfiguration.stringToVersion((String)def.getVersion());
        }
        return requestedSnmpVersion;
    }

    public SnmpConfig getSnmpConfig() {
        this.getReadLock().lock();
        try {
            if (this.m_container == null) {
                this.decryptSnmpConfig(this.m_config);
                SnmpConfig snmpConfig = this.m_config;
                return snmpConfig;
            }
            SnmpConfig config = (SnmpConfig)this.m_container.getObject();
            this.decryptSnmpConfig(config);
            SnmpConfig snmpConfig = config;
            return snmpConfig;
        }
        finally {
            this.getReadLock().unlock();
        }
    }

    public void define(SnmpEventInfo info) {
        this.saveDefinition(info.createDef());
    }

    public void saveDefinition(Definition definition) {
        this.getWriteLock().lock();
        try {
            SnmpConfigManager mgr = new SnmpConfigManager(this.getSnmpConfig());
            mgr.mergeIntoConfig(definition);
        }
        finally {
            this.getWriteLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean removeFromDefinition(InetAddress inetAddress, String location, String module) {
        boolean succeeded = false;
        this.getWriteLock().lock();
        try {
            Definition matchingDefinition = this.findMatchingDefinition(inetAddress, location);
            if (matchingDefinition != null) {
                Definition definition = SnmpPeerFactory.createDefinition(matchingDefinition);
                ArrayList<String> specifics = new ArrayList<String>();
                specifics.add(InetAddressUtils.toIpAddrString((InetAddress)inetAddress));
                definition.setSpecifics(specifics);
                SnmpConfigManager mgr = new SnmpConfigManager(this.getSnmpConfig());
                succeeded = mgr.removeDefinition(definition);
            }
        }
        finally {
            this.getWriteLock().unlock();
        }
        if (succeeded) {
            try {
                this.saveCurrent();
                LOG.info("Removed {} at location {} from definitions by module {}", new Object[]{inetAddress.getHostAddress(), location, module});
            }
            catch (IOException e) {
                LOG.error("Exception while saving current config", (Throwable)e);
            }
        }
        return succeeded;
    }

    private Definition findMatchingDefinition(InetAddress inetAddress, String location) {
        SnmpConfig config = this.getSnmpConfig();
        List definitions = config.getDefinitions();
        return definitions.stream().filter(definition -> this.matchDefinition((Definition)definition, inetAddress, location)).findFirst().orElse(null);
    }

    private static Definition createDefinition(Definition matchingDefinition) {
        Definition definition = new Definition();
        definition.setProfileLabel(matchingDefinition.getProfileLabel());
        definition.setLocation(matchingDefinition.getLocation());
        definition.setProxyHost(matchingDefinition.getProxyHost());
        definition.setMaxVarsPerPdu(matchingDefinition.getMaxVarsPerPdu());
        definition.setMaxRepetitions(matchingDefinition.getMaxRepetitions());
        definition.setMaxRequestSize(matchingDefinition.getMaxRequestSize());
        definition.setSecurityName(matchingDefinition.getSecurityName());
        definition.setSecurityLevel(matchingDefinition.getSecurityLevel());
        definition.setAuthPassphrase(matchingDefinition.getAuthPassphrase());
        definition.setAuthProtocol(matchingDefinition.getAuthProtocol());
        definition.setEngineId(matchingDefinition.getEngineId());
        definition.setContextEngineId(matchingDefinition.getContextEngineId());
        definition.setContextName(matchingDefinition.getContextName());
        definition.setEnterpriseId(matchingDefinition.getEnterpriseId());
        definition.setPrivacyPassphrase(matchingDefinition.getPrivacyPassphrase());
        definition.setPrivacyProtocol(matchingDefinition.getPrivacyProtocol());
        definition.setVersion(matchingDefinition.getVersion());
        definition.setReadCommunity(matchingDefinition.getReadCommunity());
        definition.setWriteCommunity(matchingDefinition.getWriteCommunity());
        definition.setPort(matchingDefinition.getPort());
        definition.setTimeout(matchingDefinition.getTimeout());
        definition.setTTL(matchingDefinition.getTTL());
        definition.setRetry(matchingDefinition.getRetry());
        return definition;
    }

    private boolean matchDefinition(Definition definition, InetAddress inetAddress, String location) {
        boolean locationMatched = LocationUtils.doesLocationsMatch((String)location, (String)definition.getLocation());
        return locationMatched && SnmpPeerFactory.matchingIpAddress(inetAddress, definition);
    }

    private static boolean matchingIpAddress(InetAddress inetAddress, Definition definition) {
        boolean matchingIpAddress = definition.getSpecifics().stream().anyMatch(saddr -> saddr.equals(inetAddress.getHostAddress()));
        if (!matchingIpAddress) {
            return definition.getRanges().stream().anyMatch(range -> SnmpPeerFactory.matchingRanges(inetAddress, range));
        }
        return true;
    }

    private static boolean matchingRanges(InetAddress inetAddress, Range range) {
        byte[] end;
        byte[] addr = inetAddress.getAddress();
        ByteArrayComparator BYTE_ARRAY_COMPARATOR = new ByteArrayComparator();
        byte[] begin = InetAddressUtils.toIpAddrBytes((String)range.getBegin());
        boolean inRange = BYTE_ARRAY_COMPARATOR.compare(begin, end = InetAddressUtils.toIpAddrBytes((String)range.getEnd())) <= 0 ? InetAddressUtils.isInetAddressInRange((byte[])addr, (byte[])begin, (byte[])end) : InetAddressUtils.isInetAddressInRange((byte[])addr, (byte[])end, (byte[])begin);
        return inRange;
    }

    public void saveAgentConfigAsDefinition(SnmpAgentConfig snmpAgentConfig, String location, String module) {
        Definition definition = new Definition();
        String ipAddress = snmpAgentConfig.getAddress().getHostAddress();
        definition.setLocation(location);
        this.setDefinitionFromAgentConfig(definition, snmpAgentConfig);
        this.saveDefinition(definition);
        LOG.info("Definition saved for {} by module {}", (Object)ipAddress, (Object)module);
        try {
            this.saveCurrent();
        }
        catch (IOException e) {
            LOG.error("Exception while saving current config", (Throwable)e);
        }
    }

    public List<SnmpProfile> getProfiles() {
        SnmpConfig snmpConfig = this.getSnmpConfig();
        if (snmpConfig != null && snmpConfig.getSnmpProfiles() != null) {
            return snmpConfig.getSnmpProfiles().getSnmpProfiles();
        }
        return new ArrayList<SnmpProfile>();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getSnmpConfigAsString() {
        String marshalledConfig = null;
        StringWriter writer = null;
        SnmpConfig snmpConfig = this.getSnmpConfig();
        this.encryptSnmpConfig(snmpConfig);
        try {
            writer = new StringWriter();
            JaxbUtils.marshal((Object)snmpConfig, (Writer)writer);
            marshalledConfig = writer.toString();
        }
        finally {
            IOUtils.closeQuietly((Writer)writer);
        }
        return marshalledConfig;
    }

    private void encryptSnmpConfig(SnmpConfig snmpConfig) {
        if (!this.encryptionEnabled.booleanValue()) {
            return;
        }
        this.initializeTextEncryptor();
        if (this.textEncryptor == null) {
            return;
        }
        this.encryptConfig((Configuration)snmpConfig);
        snmpConfig.getDefinitions().forEach(this::encryptConfig);
        if (snmpConfig.getSnmpProfiles() != null) {
            snmpConfig.getSnmpProfiles().getSnmpProfiles().forEach(this::encryptConfig);
        }
    }

    private void decryptSnmpConfig(SnmpConfig snmpConfig) {
        if (!this.encryptionEnabled.booleanValue()) {
            return;
        }
        this.initializeTextEncryptor();
        if (this.textEncryptor == null) {
            return;
        }
        this.decryptConfig((Configuration)snmpConfig);
        snmpConfig.getDefinitions().forEach(this::decryptConfig);
        if (snmpConfig.getSnmpProfiles() != null) {
            snmpConfig.getSnmpProfiles().getSnmpProfiles().forEach(this::decryptConfig);
        }
    }

    private void decryptConfig(Configuration config) {
        if (!config.getEncrypted().booleanValue()) {
            return;
        }
        try {
            if (!Strings.isNullOrEmpty((String)config.getAuthPassphrase())) {
                String authPassPhrase = this.textEncryptor.decrypt(SNMP_ENCRYPTION_CONTEXT, config.getAuthPassphrase());
                config.setAuthPassphrase(authPassPhrase);
            }
            if (!Strings.isNullOrEmpty((String)config.getPrivacyPassphrase())) {
                String privPassPhrase = this.textEncryptor.decrypt(SNMP_ENCRYPTION_CONTEXT, config.getPrivacyPassphrase());
                config.setPrivacyPassphrase(privPassPhrase);
            }
            if (!Strings.isNullOrEmpty((String)config.getReadCommunity())) {
                String readCommunity = this.textEncryptor.decrypt(SNMP_ENCRYPTION_CONTEXT, config.getReadCommunity());
                config.setReadCommunity(readCommunity);
            }
            if (!Strings.isNullOrEmpty((String)config.getWriteCommunity())) {
                String writeCommunity = this.textEncryptor.decrypt(SNMP_ENCRYPTION_CONTEXT, config.getWriteCommunity());
                config.setWriteCommunity(writeCommunity);
            }
            config.setEncrypted(Boolean.valueOf(false));
        }
        catch (Exception e) {
            LOG.error("Exception while trying to decrypt snmp config", (Throwable)e);
        }
    }

    private void encryptConfig(Configuration config) {
        if (config.getEncrypted().booleanValue()) {
            return;
        }
        try {
            if (!Strings.isNullOrEmpty((String)config.getAuthPassphrase())) {
                String authPassPhrase = this.textEncryptor.encrypt(SNMP_ENCRYPTION_CONTEXT, config.getAuthPassphrase());
                config.setAuthPassphrase(authPassPhrase);
            }
            if (!Strings.isNullOrEmpty((String)config.getPrivacyPassphrase())) {
                String privPassPhrase = this.textEncryptor.encrypt(SNMP_ENCRYPTION_CONTEXT, config.getPrivacyPassphrase());
                config.setPrivacyPassphrase(privPassPhrase);
            }
            if (!Strings.isNullOrEmpty((String)config.getReadCommunity())) {
                String readCommunity = this.textEncryptor.encrypt(SNMP_ENCRYPTION_CONTEXT, config.getReadCommunity());
                config.setReadCommunity(readCommunity);
            }
            if (!Strings.isNullOrEmpty((String)config.getWriteCommunity())) {
                String writeCommunity = this.textEncryptor.encrypt(SNMP_ENCRYPTION_CONTEXT, config.getWriteCommunity());
                config.setWriteCommunity(writeCommunity);
            }
            config.setEncrypted(Boolean.valueOf(true));
        }
        catch (Exception e) {
            LOG.error("Exception while trying to encrypt snmp config", (Throwable)e);
        }
    }

    private void initializeTextEncryptor() {
        if (this.textEncryptor == null) {
            try {
                this.textEncryptor = (TextEncryptor)BeanUtils.getBean((String)"daoContext", (String)"textEncryptor", TextEncryptor.class);
            }
            catch (Exception e) {
                LOG.warn("Exception while trying to get textEncryptor", (Throwable)e);
            }
        }
    }

    @VisibleForTesting
    Boolean getEncryptionEnabled() {
        return this.encryptionEnabled;
    }

    @VisibleForTesting
    void setTextEncryptor(TextEncryptor textEncryptor) {
        this.textEncryptor = textEncryptor;
    }

    static {
        s_singleton = null;
        s_loaded = new AtomicBoolean(false);
    }
}

