/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.config;

import com.google.common.base.Strings;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.StringWriter;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.net.InetAddress;
import java.net.URL;
import java.net.UnknownHostException;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Spliterators;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import java.util.stream.StreamSupport;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.tuple.Pair;
import org.opennms.core.spring.BeanUtils;
import org.opennms.core.utils.ConfigFileConstants;
import org.opennms.core.utils.InetAddressUtils;
import org.opennms.core.utils.IteratorUtils;
import org.opennms.core.xml.JaxbUtils;
import org.opennms.netmgt.config.api.DiscoveryConfigurationFactory;
import org.opennms.netmgt.config.discovery.Definition;
import org.opennms.netmgt.config.discovery.Detector;
import org.opennms.netmgt.config.discovery.DiscoveryConfiguration;
import org.opennms.netmgt.config.discovery.ExcludeRange;
import org.opennms.netmgt.config.discovery.ExcludeUrl;
import org.opennms.netmgt.config.discovery.IncludeRange;
import org.opennms.netmgt.config.discovery.IncludeUrl;
import org.opennms.netmgt.config.discovery.Specific;
import org.opennms.netmgt.model.discovery.IPPollAddress;
import org.opennms.netmgt.model.discovery.IPPollRange;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.io.FileSystemResource;
import org.springframework.core.io.Resource;

public class DiscoveryConfigFactory
implements DiscoveryConfigurationFactory {
    private static final Logger LOG = LoggerFactory.getLogger(DiscoveryConfigFactory.class);
    private final ReadWriteLock m_globalLock = new ReentrantReadWriteLock();
    private final Lock m_readLock = this.m_globalLock.readLock();
    private final Lock m_writeLock = this.m_globalLock.writeLock();
    private Map<String, List<String>> m_urlSpecifics = new HashMap<String, List<String>>();
    private List<ExcludeRange> m_excludeRanges = new ArrayList<ExcludeRange>();
    private Map<String, Pair<Optional<String>, List<String>>> m_excludeUrlsMap = new HashMap<String, Pair<Optional<String>, List<String>>>();
    public static final String COMMENT_STR = "#";
    public static final char COMMENT_CHAR = '#';
    public static final double DEFAULT_PACKETS_PER_SECOND = 1.0;
    public static final int DEFAULT_INITIAL_SLEEP_TIME = 30000;
    public static final int DEFAULT_RESTART_SLEEP_TIME = 86400000;
    public static final int DEFAULT_RETRIES = 1;
    public static final long DEFAULT_TIMEOUT = 2000L;
    public static final int DEFAULT_CHUNK_SIZE = 100;
    private DiscoveryConfiguration m_config;

    public static DiscoveryConfigFactory getInstance() {
        return (DiscoveryConfigFactory)BeanUtils.getBean((String)"commonContext", (String)"discoveryFactory", DiscoveryConfigFactory.class);
    }

    public DiscoveryConfigFactory() throws IOException {
        this.reload();
    }

    public DiscoveryConfigFactory(DiscoveryConfiguration config) {
        this.m_config = config;
    }

    public Lock getReadLock() {
        return this.m_readLock;
    }

    public Lock getWriteLock() {
        return this.m_writeLock;
    }

    public synchronized void reload() throws IOException {
        try {
            File cfgFile = ConfigFileConstants.getFile((int)ConfigFileConstants.DISCOVERY_CONFIG_FILE_NAME);
            LOG.debug("reload: config file path {}", (Object)cfgFile.getPath());
            FileSystemResource resource = new FileSystemResource(cfgFile);
            this.m_config = (DiscoveryConfiguration)JaxbUtils.unmarshal(DiscoveryConfiguration.class, (Resource)resource);
            try {
                this.clearUrlSpecifics();
                this.clearExcludeRanges();
                this.clearExcludeUrls();
                this.getInitialSleepTime();
                this.getRestartSleepTime();
                this.getIntraPacketDelay();
                this.getConfiguredAddresses();
            }
            catch (Throwable e) {
                throw new IOException("An error occurred while validating the configuration: " + e.getMessage(), e);
            }
        }
        catch (IOException e) {
            LOG.error("Could not unmarshal configuration file: " + ConfigFileConstants.getFileName((int)ConfigFileConstants.DISCOVERY_CONFIG_FILE_NAME), (Throwable)e);
            throw e;
        }
    }

    public synchronized DiscoveryConfiguration getConfiguration() {
        return this.m_config;
    }

    protected void saveXml(String xml) throws IOException {
        if (xml != null) {
            block4: {
                OutputStreamWriter fileWriter = null;
                this.getWriteLock().lock();
                try {
                    fileWriter = new OutputStreamWriter((OutputStream)new FileOutputStream(ConfigFileConstants.getFile((int)ConfigFileConstants.DISCOVERY_CONFIG_FILE_NAME)), StandardCharsets.UTF_8);
                    fileWriter.write(xml);
                    ((Writer)fileWriter).flush();
                    if (fileWriter == null) break block4;
                }
                catch (Throwable throwable) {
                    if (fileWriter != null) {
                        IOUtils.closeQuietly(fileWriter);
                    }
                    this.getWriteLock().unlock();
                    throw throwable;
                }
                IOUtils.closeQuietly((Writer)fileWriter);
            }
            this.getWriteLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void saveConfiguration(DiscoveryConfiguration configuration) throws IOException {
        this.getWriteLock().lock();
        try {
            StringWriter stringWriter = new StringWriter();
            JaxbUtils.marshal((Object)configuration, (Writer)stringWriter);
            String xml = stringWriter.toString();
            LOG.debug("saving configuration...");
            this.saveXml(xml);
        }
        finally {
            this.getWriteLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List<String> addToSpecificsFromURL(List<IPPollAddress> specifics, String url, String foreignSource, String location, long timeout, int retries) {
        List<String> list;
        URL fileURL;
        ArrayList<String> ipAddressList;
        InputStream is;
        block5: {
            is = null;
            ipAddressList = new ArrayList<String>();
            fileURL = new URL(url);
            is = fileURL.openStream();
            if (is != null) break block5;
            LOG.warn("URL does not exist: {}", (Object)url);
            ArrayList<String> arrayList = ipAddressList;
            IOUtils.closeQuietly((InputStream)is);
            return arrayList;
        }
        try {
            list = DiscoveryConfigFactory.addToSpecificsFromURL(specifics, fileURL.openStream(), foreignSource, location, timeout, retries, url);
        }
        catch (IOException e) {
            ArrayList<String> arrayList;
            try {
                LOG.error("Error reading URL: {}", (Object)url);
                arrayList = ipAddressList;
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly(is);
                throw throwable;
            }
            IOUtils.closeQuietly((InputStream)is);
            return arrayList;
        }
        IOUtils.closeQuietly((InputStream)is);
        return list;
    }

    public static List<String> addToSpecificsFromURL(List<IPPollAddress> specifics, InputStream is, String foreignSource, String location, long timeout, int retries, String url) throws IOException {
        boolean bRet = true;
        ArrayList<String> ipAddressList = new ArrayList<String>();
        try {
            BufferedReader buffer = new BufferedReader(new InputStreamReader(is, StandardCharsets.UTF_8));
            String ipLine = null;
            String specIP = null;
            while ((ipLine = buffer.readLine()) != null) {
                if ((ipLine = ipLine.trim()).length() == 0 || ipLine.charAt(0) == '#') continue;
                int comIndex = ipLine.indexOf(COMMENT_STR);
                if (comIndex == -1) {
                    specIP = ipLine;
                } else {
                    specIP = ipLine.substring(0, comIndex);
                    specIP = specIP.trim();
                }
                try {
                    InetAddress specific = InetAddressUtils.addr((String)specIP);
                    specifics.add(new IPPollAddress(foreignSource, location, specific, timeout, retries));
                    String ipAddress = InetAddressUtils.toIpAddrString((InetAddress)specific);
                    ipAddressList.add(ipAddress);
                }
                catch (IllegalArgumentException e) {
                    LOG.warn("Unknown host '{}' inside discovery include file: address ignored", (Object)specIP);
                }
                specIP = null;
            }
        }
        catch (UnsupportedEncodingException e) {
            LOG.error("Your JVM doesn't support UTF-8");
        }
        return ipAddressList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<IPPollAddress> getURLSpecifics() {
        LinkedList<IPPollAddress> specifics = new LinkedList<IPPollAddress>();
        this.getReadLock().lock();
        try {
            Long defaultTimeout = this.getConfiguration().getTimeout().orElse(2000L);
            Integer defaultRetries = this.getConfiguration().getRetries().orElse(1);
            for (IncludeUrl url : this.getConfiguration().getIncludeUrls()) {
                long timeout = url.getTimeout().orElse(defaultTimeout);
                int retries = url.getRetries().orElse(defaultRetries);
                if (!url.getUrl().isPresent()) continue;
                String urlString = (String)url.getUrl().get();
                List<String> ipAddressList = DiscoveryConfigFactory.addToSpecificsFromURL(specifics, urlString, url.getForeignSource().orElse(null), url.getLocation().orElse(null), timeout, retries);
                this.m_urlSpecifics.put(urlString, ipAddressList);
            }
            this.getConfiguration().getDefinitions().forEach(def -> {
                long timeoutFromDef = def.getTimeout().orElse(defaultTimeout);
                int retriesFromDef = def.getRetries().orElse(defaultRetries);
                for (IncludeUrl url : def.getIncludeUrls()) {
                    long timeout = url.getTimeout().orElse(timeoutFromDef);
                    int retries = url.getRetries().orElse(retriesFromDef);
                    if (!url.getUrl().isPresent()) continue;
                    String urlString = (String)url.getUrl().get();
                    List<String> ipAddressList = DiscoveryConfigFactory.addToSpecificsFromURL(specifics, urlString, url.getForeignSource().orElse(def.getForeignSource()), url.getLocation().orElse(def.getLocationName()), timeout, retries);
                    this.m_urlSpecifics.put(urlString, ipAddressList);
                }
            });
            LinkedList<IPPollAddress> linkedList = specifics;
            return linkedList;
        }
        finally {
            this.getReadLock().unlock();
        }
    }

    private void clearUrlSpecifics() {
        this.m_urlSpecifics.clear();
    }

    private void clearExcludeRanges() {
        this.m_excludeRanges.clear();
    }

    private void clearExcludeUrls() {
        this.m_excludeUrlsMap.clear();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<IPPollRange> getRanges() {
        LinkedList<IPPollRange> includes = new LinkedList<IPPollRange>();
        this.getReadLock().lock();
        try {
            Long defaultTimeout = this.getConfiguration().getTimeout().orElse(2000L);
            Integer defaultRetries = this.getConfiguration().getRetries().orElse(1);
            for (IncludeRange ir : this.getConfiguration().getIncludeRanges()) {
                try {
                    InetAddressUtils.toIpAddrBytes((String)ir.getBegin());
                }
                catch (Throwable e) {
                    LOG.warn("Begin address of discovery range is invalid, discarding: {}", (Object)ir.getBegin());
                    continue;
                }
                try {
                    InetAddressUtils.toIpAddrBytes((String)ir.getEnd());
                }
                catch (Throwable e) {
                    LOG.warn("End address of discovery range is invalid, discarding: {}", (Object)ir.getEnd());
                    continue;
                }
                long timeout = ir.getTimeout().orElse(defaultTimeout);
                int retries = ir.getRetries().orElse(defaultRetries);
                try {
                    includes.add(new IPPollRange((String)ir.getForeignSource().orElse(null), (String)ir.getLocation().orElse(null), ir.getBegin(), ir.getEnd(), timeout, retries));
                }
                catch (UnknownHostException uhE) {
                    LOG.warn("Failed to convert address range ({}, {})", new Object[]{ir.getBegin(), ir.getEnd(), uhE});
                }
            }
            this.getConfiguration().getDefinitions().forEach(def -> {
                long timeoutFromDef = def.getTimeout().orElse(defaultTimeout);
                int retriesFromDef = def.getRetries().orElse(defaultRetries);
                for (IncludeRange ir : def.getIncludeRanges()) {
                    try {
                        InetAddressUtils.toIpAddrBytes((String)ir.getBegin());
                    }
                    catch (Throwable e) {
                        LOG.warn("Definition: Begin address of discovery range is invalid, discarding: {}", (Object)ir.getBegin());
                        continue;
                    }
                    try {
                        InetAddressUtils.toIpAddrBytes((String)ir.getEnd());
                    }
                    catch (Throwable e) {
                        LOG.warn("Definition : End address of discovery range is invalid, discarding: {}", (Object)ir.getEnd());
                        continue;
                    }
                    long timeout = ir.getTimeout().orElse(timeoutFromDef);
                    int retries = ir.getRetries().orElse(retriesFromDef);
                    try {
                        includes.add(new IPPollRange(ir.getForeignSource().orElse(def.getForeignSource()), ir.getLocation().orElse(def.getLocationName()), ir.getBegin(), ir.getEnd(), timeout, retries));
                    }
                    catch (UnknownHostException uhE) {
                        LOG.warn("Definition: Failed to convert address range ({}, {})", new Object[]{ir.getBegin(), ir.getEnd(), uhE});
                    }
                }
            });
            LinkedList<IPPollRange> linkedList = includes;
            return linkedList;
        }
        finally {
            this.getReadLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<IPPollAddress> getSpecifics() {
        LinkedList<IPPollAddress> specifics = new LinkedList<IPPollAddress>();
        this.getReadLock().lock();
        try {
            Long defaultTimeout = this.getConfiguration().getTimeout().orElse(2000L);
            Integer defaultRetries = this.getConfiguration().getRetries().orElse(1);
            for (Specific s : this.getConfiguration().getSpecifics()) {
                long timeout = s.getTimeout().orElse(defaultTimeout);
                int retries = s.getRetries().orElse(defaultRetries);
                String address = s.getAddress();
                try {
                    specifics.add(new IPPollAddress((String)s.getForeignSource().orElse(null), (String)s.getLocation().orElse(null), InetAddressUtils.addr((String)address), timeout, retries));
                }
                catch (IllegalArgumentException e) {
                    LOG.warn("Failed to convert address {}", (Object)address, (Object)e);
                }
            }
            this.getConfiguration().getDefinitions().forEach(def -> {
                long timeoutFromDef = def.getTimeout().orElse(defaultTimeout);
                int retriesFromDef = def.getRetries().orElse(defaultRetries);
                for (Specific s : def.getSpecifics()) {
                    long timeout = s.getTimeout().orElse(timeoutFromDef);
                    int retries = s.getRetries().orElse(retriesFromDef);
                    String address = s.getAddress();
                    try {
                        specifics.add(new IPPollAddress(s.getForeignSource().orElse(def.getForeignSource()), s.getLocation().orElse(def.getLocationName()), InetAddressUtils.addr((String)address), timeout, retries));
                    }
                    catch (IllegalArgumentException e) {
                        LOG.warn("Definition: Specific: Failed to convert address {}", (Object)address, (Object)e);
                    }
                }
            });
            LinkedList<IPPollAddress> linkedList = specifics;
            return linkedList;
        }
        finally {
            this.getReadLock().unlock();
        }
    }

    public boolean isExcluded(InetAddress address, String location) {
        String defaultLocation = "Default";
        if (!this.m_excludeRanges.isEmpty()) {
            byte[] laddr = address.getAddress();
            for (ExcludeRange range : this.m_excludeRanges) {
                if (!this.isLocationMatched(range.getLocation().orElse(defaultLocation), location) || !InetAddressUtils.isInetAddressInRange((byte[])laddr, (String)range.getBegin(), (String)range.getEnd())) continue;
                return true;
            }
        }
        if (!this.m_excludeUrlsMap.isEmpty()) {
            for (String url : this.m_excludeUrlsMap.keySet()) {
                byte[] laddr = address.getAddress();
                Pair<Optional<String>, List<String>> pair = this.m_excludeUrlsMap.get(url);
                if (!this.isLocationMatched(((Optional)pair.getLeft()).orElse(defaultLocation), location) || !((List)pair.getRight()).stream().anyMatch(ip -> InetAddressUtils.areSameInetAddress((byte[])laddr, (byte[])InetAddressUtils.toIpAddrBytes((String)ip)))) continue;
                return true;
            }
        }
        return false;
    }

    void initializeExcludeRanges() {
        this.getReadLock().lock();
        try {
            this.m_excludeRanges.addAll(this.getConfiguration().getExcludeRanges());
            this.getConfiguration().getDefinitions().forEach(def -> {
                this.setLocationFromDefinition((Definition)def);
                this.m_excludeRanges.addAll(def.getExcludeRanges());
            });
        }
        finally {
            this.getReadLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void initializeExcludeUrls() {
        this.getReadLock().lock();
        ArrayList excludeUrlList = new ArrayList();
        try {
            excludeUrlList.addAll(this.getConfiguration().getExcludeUrls());
            this.getConfiguration().getDefinitions().forEach(def -> {
                def.getExcludeUrls().forEach(eu -> {
                    if (!eu.getLocation().isPresent()) {
                        eu.setLocation(def.getLocation().orElse("Default"));
                    }
                });
                excludeUrlList.addAll(def.getExcludeUrls());
            });
            for (ExcludeUrl excludeUrl : excludeUrlList) {
                if (excludeUrl.getUrl() == null) continue;
                LinkedList<IPPollAddress> specifics = new LinkedList<IPPollAddress>();
                List<String> ipAddressList = DiscoveryConfigFactory.addToSpecificsFromURL(specifics, excludeUrl.getUrl(), excludeUrl.getForeignSource().orElse(null), excludeUrl.getLocation().orElse(null), 0L, 0);
                this.m_excludeUrlsMap.put(excludeUrl.getUrl(), (Pair<Optional<String>, List<String>>)Pair.of((Object)excludeUrl.getLocation(), ipAddressList));
            }
        }
        finally {
            this.getReadLock().unlock();
        }
    }

    private void setLocationFromDefinition(Definition definition) {
        List excludeRangesFromDef = definition.getExcludeRanges();
        excludeRangesFromDef.forEach(exRange -> {
            if (!exRange.getLocation().isPresent()) {
                exRange.setLocation(definition.getLocation().orElse("Default"));
            }
        });
    }

    private boolean isLocationMatched(String locationFromRange, String location) {
        if (Strings.isNullOrEmpty((String)location)) {
            location = "Default";
        }
        return locationFromRange.equals(location);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getForeignSource(InetAddress address) {
        this.getReadLock().lock();
        try {
            LOG.debug("Looking for matching foreign source specific IP or IP range with address: {}...", (Object)address);
            List specificCollection = this.getConfiguration().getSpecifics();
            for (Specific specific : specificCollection) {
                String ipAddr = specific.getAddress();
                if (!ipAddr.equals(InetAddressUtils.str((InetAddress)address))) continue;
                String foreignSource = specific.getForeignSource().orElse(null);
                LOG.debug("Matched foreign source {} matching address: {} against specific {}.", new Object[]{foreignSource, address, ipAddr});
                String string = foreignSource;
                return string;
            }
            byte[] laddr = address.getAddress();
            List includeRangeCollection = this.getConfiguration().getIncludeRanges();
            for (IncludeRange range : includeRangeCollection) {
                if (!InetAddressUtils.isInetAddressInRange((byte[])laddr, (String)range.getBegin(), (String)range.getEnd())) continue;
                String foreignSource = range.getForeignSource().orElse(null);
                LOG.debug("Found foreign source {} with address {} in the range begin: {} and end: {}.", new Object[]{foreignSource, address, range.getBegin(), range.getEnd()});
                String string = foreignSource;
                return string;
            }
            List includeUrlCollection = this.getConfiguration().getIncludeUrls();
            for (IncludeUrl includeUrl : includeUrlCollection) {
                String ipAddr = includeUrl.getUrl().orElse("");
                if (!ipAddr.equals(InetAddressUtils.str((InetAddress)address))) continue;
                String foreignSource = includeUrl.getForeignSource().orElse(null);
                LOG.debug("Matched foreign source {} matching address: {} in specified URL.", (Object)foreignSource, (Object)address);
                String string = foreignSource;
                return string;
            }
            String string = this.getConfiguration().getForeignSource().orElse(null);
            return string;
        }
        finally {
            this.getReadLock().unlock();
        }
    }

    public List<Detector> getListOfDetectors(InetAddress inetAddress, String location) {
        String ipAddress = InetAddressUtils.toIpAddrString((InetAddress)inetAddress);
        if (Strings.isNullOrEmpty((String)location)) {
            location = "Default";
        }
        String sourceLocation = location;
        String defaultLocation = this.getConfiguration().getLocation().orElse("Default");
        Optional<Definition> definition = this.getConfiguration().getDefinitions().stream().filter(def -> {
            boolean specificMatch = def.getSpecifics().stream().anyMatch(specific -> specific.getLocation().orElse(def.getLocation().orElse(defaultLocation)).equals(sourceLocation) && specific.getAddress().equals(ipAddress));
            if (specificMatch) {
                return true;
            }
            boolean urlSpecficMatch = def.getIncludeUrls().stream().anyMatch(includeUrl -> {
                List<String> urlSpecifics;
                boolean urlLocationMatch;
                boolean bl = urlLocationMatch = includeUrl.getUrl().isPresent() && includeUrl.getLocation().orElse(def.getLocation().orElse(defaultLocation)).equals(sourceLocation);
                if (urlLocationMatch && (urlSpecifics = this.m_urlSpecifics.get(includeUrl.getUrl().get())) != null) {
                    return urlSpecifics.contains(ipAddress);
                }
                return false;
            });
            if (urlSpecficMatch) {
                return true;
            }
            return def.getIncludeRanges().stream().anyMatch(includeRange -> includeRange.getLocation().orElse(def.getLocation().orElse(defaultLocation)).equals(sourceLocation) && InetAddressUtils.isInetAddressInRange((String)ipAddress, (String)includeRange.getBegin(), (String)includeRange.getEnd()));
        }).findFirst();
        if (definition.isPresent()) {
            return definition.get().getDetectors();
        }
        return new ArrayList<Detector>();
    }

    public double getPacketsPerSecond() {
        this.getReadLock().lock();
        try {
            double d = this.getConfiguration().getPacketsPerSecond().orElse(1.0);
            return d;
        }
        finally {
            this.getReadLock().unlock();
        }
    }

    public long getIntraPacketDelay() {
        this.getReadLock().lock();
        try {
            long l = Math.round(1000.0 / this.getConfiguration().getPacketsPerSecond().orElse(1.0));
            return l;
        }
        finally {
            this.getReadLock().unlock();
        }
    }

    public Iterator<IPPollAddress> getExcludingIterator(Iterator<IPPollAddress> it) {
        return StreamSupport.stream(Spliterators.spliteratorUnknownSize(it, 1040), false).filter(item -> !this.isExcluded(item.getAddress(), item.getLocation())).iterator();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Iterable<IPPollAddress> getConfiguredAddresses() {
        this.getReadLock().lock();
        try {
            List<IPPollAddress> specifics = this.getSpecifics();
            List<IPPollRange> ranges = this.getRanges();
            specifics.addAll(this.getURLSpecifics());
            this.initializeExcludeRanges();
            this.initializeExcludeUrls();
            ArrayList<Iterator<IPPollAddress>> iters = new ArrayList<Iterator<IPPollAddress>>();
            iters.add(specifics.iterator());
            for (IPPollRange range : ranges) {
                iters.add(this.getExcludingIterator(range.iterator()));
            }
            Iterable iterable = IteratorUtils.concatIterators(iters);
            return iterable;
        }
        finally {
            this.getReadLock().unlock();
        }
    }

    public long getRestartSleepTime() {
        this.getReadLock().lock();
        try {
            long l = this.getConfiguration().getRestartSleepTime().orElse(86400000L);
            return l;
        }
        finally {
            this.getReadLock().unlock();
        }
    }

    public long getInitialSleepTime() {
        this.getReadLock().lock();
        try {
            long l = this.getConfiguration().getInitialSleepTime().orElse(30000L);
            return l;
        }
        finally {
            this.getReadLock().unlock();
        }
    }
}

