/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.features.jmxconfiggenerator.jmxconfig.query;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.management.MBeanAttributeInfo;
import javax.management.MBeanInfo;
import javax.management.ObjectName;

public class QueryResult {
    private Map<ObjectName, MBeanResult> mbeanResultMap = new HashMap<ObjectName, MBeanResult>();
    private int totalMBeanCount;
    private Comparator<MBeanResult> comparator;

    public void setAttributeTotalCount(ObjectName objectName, int attributeTotalCount) {
        this.mbeanResultMap.get((Object)objectName).attributeResult.totalCount = attributeTotalCount;
    }

    public void put(ObjectName objectName, MBeanAttributeInfo attributeInfo) {
        AttributeResult attributeResult = this.mbeanResultMap.get((Object)objectName).attributeResult;
        if (!attributeResult.attributes.contains(attributeInfo)) {
            attributeResult.attributes.add(attributeInfo);
        }
    }

    public void put(ObjectName objectName, MBeanInfo mbeanInfo) {
        AttributeResult attributeResult = new AttributeResult();
        attributeResult.mbeanInfo = mbeanInfo;
        MBeanResult mbeanResult = new MBeanResult();
        mbeanResult.objectName = objectName;
        mbeanResult.mbeanInfo = mbeanInfo;
        mbeanResult.attributeResult = attributeResult;
        this.mbeanResultMap.put(objectName, mbeanResult);
    }

    public int getTotalMBeanCount() {
        return this.totalMBeanCount;
    }

    public void setTotalMBeanCount(int totalCount) {
        this.totalMBeanCount = totalCount;
    }

    public List<MBeanResult> getMBeanResults() {
        ArrayList<MBeanResult> result = new ArrayList<MBeanResult>(this.mbeanResultMap.values());
        if (this.comparator != null) {
            Collections.sort(result, this.comparator);
        }
        return result;
    }

    public void removeEmptyMBeanResults() {
        ArrayList<ObjectName> markForDeletion = new ArrayList<ObjectName>();
        for (Map.Entry<ObjectName, MBeanResult> eachEntry : this.mbeanResultMap.entrySet()) {
            if (!eachEntry.getValue().attributeResult.attributes.isEmpty()) continue;
            markForDeletion.add(eachEntry.getKey());
        }
        for (ObjectName eachObjectName : markForDeletion) {
            this.mbeanResultMap.remove(eachObjectName);
        }
    }

    public void remove(ObjectName objectName, MBeanAttributeInfo eachAttribute) {
        this.mbeanResultMap.get((Object)objectName).attributeResult.attributes.remove(eachAttribute);
    }

    public void sort() {
        this.comparator = new Comparator<MBeanResult>(){

            @Override
            public int compare(MBeanResult o1, MBeanResult o2) {
                return o1.objectName.compareTo(o2.objectName);
            }
        };
    }

    public static class MBeanResult {
        public ObjectName objectName;
        public MBeanInfo mbeanInfo;
        public AttributeResult attributeResult;
    }

    public static class AttributeResult {
        private Map<MBeanAttributeInfo, Object> valueMap = new HashMap<MBeanAttributeInfo, Object>();
        public int totalCount;
        public Collection<MBeanAttributeInfo> attributes = new ArrayList<MBeanAttributeInfo>();
        public MBeanInfo mbeanInfo;

        public Object getValue(MBeanAttributeInfo eachAttribute) {
            return this.valueMap.get(eachAttribute);
        }

        public void setValue(MBeanAttributeInfo eachAttribute, Object value) {
            this.valueMap.put(eachAttribute, value);
        }
    }
}

