/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.features.elastic.client.commands;

import com.google.gson.Gson;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import org.apache.http.HttpEntity;
import org.apache.http.util.EntityUtils;
import org.apache.karaf.shell.api.action.Action;
import org.apache.karaf.shell.api.action.Argument;
import org.apache.karaf.shell.api.action.Command;
import org.apache.karaf.shell.api.action.Option;
import org.apache.karaf.shell.api.action.lifecycle.Reference;
import org.apache.karaf.shell.api.action.lifecycle.Service;
import org.elasticsearch.client.Request;
import org.elasticsearch.client.Response;
import org.opennms.features.elastic.client.DefaultElasticRestClient;
import org.opennms.features.elastic.client.ElasticRestClient;

@Command(scope="opennms", name="elastic-template", description="Manage Elasticsearch templates")
@Service
public class TemplateCommand
implements Action {
    @Reference
    private ElasticRestClient elasticRestClient;
    @Option(name="-l", aliases={"--list"}, description="List available templates (only names)")
    private boolean list;
    @Option(name="-a", aliases={"--apply"}, description="Apply a template")
    private boolean apply;
    @Option(name="-s", aliases={"--show"}, description="Show template content")
    private boolean show;
    @Option(name="-d", aliases={"--directory"}, description="Template directory")
    private String directory;
    @Option(name="--apply-all", description="Apply all templates from directory")
    private boolean applyAll;
    @Option(name="--component", description="Operate on component templates")
    private boolean componentTemplate;
    @Option(name="--policy", description="Operate on ILM policies")
    private boolean ilmPolicy;
    @Argument(index=0, name="template", description="Template name", required=false)
    private String templateName;

    public Object execute() throws Exception {
        try {
            if (this.applyAll && this.directory != null) {
                int count = this.elasticRestClient.applyAllTemplatesFromDirectory(this.directory);
                System.out.println("Applied " + count + " templates and policies");
                return null;
            }
            if (this.list) {
                this.listResources();
                return null;
            }
            if (this.show) {
                this.showResource();
                return null;
            }
            if (this.apply) {
                this.applyResource();
                return null;
            }
            System.out.println("Please specify an operation: --list, --show, --apply, or --apply-all");
            return null;
        }
        catch (Exception e) {
            System.err.println("Error: " + e.getMessage());
            return null;
        }
    }

    private void listResources() throws IOException {
        String type;
        String endpoint;
        if (this.ilmPolicy) {
            endpoint = "/_ilm/policy";
            type = "ILM Policies";
        } else if (this.componentTemplate) {
            endpoint = "/_component_template";
            type = "Component Templates";
        } else {
            endpoint = "/_index_template";
            type = "Index Templates";
        }
        Request request = new Request("GET", endpoint);
        Response response = ((DefaultElasticRestClient)this.elasticRestClient).getRestClient().performRequest(request);
        String responseBody = EntityUtils.toString((HttpEntity)response.getEntity());
        System.out.println(type + ":");
        Gson gson = new Gson();
        JsonElement jsonElement = (JsonElement)gson.fromJson(responseBody, JsonElement.class);
        if (this.ilmPolicy) {
            JsonObject root = jsonElement.getAsJsonObject();
            for (String policyName : root.keySet()) {
                System.out.println("- " + policyName);
            }
        } else if (this.componentTemplate) {
            JsonArray templates = jsonElement.getAsJsonObject().getAsJsonArray("component_templates");
            for (JsonElement el : templates) {
                String name = el.getAsJsonObject().get("name").getAsString();
                System.out.println("- " + name);
            }
        } else {
            JsonArray templates = jsonElement.getAsJsonObject().getAsJsonArray("index_templates");
            for (JsonElement el : templates) {
                String name = el.getAsJsonObject().get("name").getAsString();
                System.out.println("- " + name);
            }
        }
    }

    private void showResource() throws IOException {
        if (this.templateName == null) {
            System.err.println("Error: Name is required for --show operation");
            return;
        }
        String endpoint = this.ilmPolicy ? "/_ilm/policy/" + this.templateName : (this.componentTemplate ? "/_component_template/" + this.templateName : "/_index_template/" + this.templateName);
        Request request = new Request("GET", endpoint);
        try {
            Response response = ((DefaultElasticRestClient)this.elasticRestClient).getRestClient().performRequest(request);
            System.out.println(EntityUtils.toString((HttpEntity)response.getEntity()));
        }
        catch (Exception e) {
            System.err.println("Error: Resource '" + this.templateName + "' not found");
        }
    }

    private void applyResource() throws IOException {
        String resourceType;
        if (this.templateName == null || this.directory == null) {
            System.err.println("Error: Name and directory are required for --apply operation");
            return;
        }
        Path resourcePath = Paths.get(this.directory, this.templateName + ".json");
        if (!Files.exists(resourcePath, new LinkOption[0])) {
            System.err.println("Error: File not found: " + resourcePath);
            return;
        }
        String content = new String(Files.readAllBytes(resourcePath));
        boolean success = this.ilmPolicy ? this.elasticRestClient.applyILMPolicy(this.templateName, content) : (this.componentTemplate ? this.elasticRestClient.applyComponentTemplate(this.templateName, content) : this.elasticRestClient.applyComposableIndexTemplate(this.templateName, content));
        String string = this.ilmPolicy ? "policy" : (resourceType = this.componentTemplate ? "component template" : "index template");
        if (success) {
            System.out.println("Successfully applied " + resourceType + ": " + this.templateName);
        } else {
            System.err.println("Failed to apply " + resourceType + ": " + this.templateName);
        }
    }
}

