/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.features.elastic.client;

import java.io.IOException;
import java.util.List;
import java.util.Objects;
import org.opennms.core.health.api.Context;
import org.opennms.core.health.api.HealthCheck;
import org.opennms.core.health.api.Response;
import org.opennms.core.health.api.Status;
import org.opennms.features.elastic.client.ElasticRestClient;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ElasticHealthCheck
implements HealthCheck {
    private static final Logger LOG = LoggerFactory.getLogger(ElasticHealthCheck.class);
    private static final String ELASTIC = "elastic";
    private final ElasticRestClient client;
    private final String featureName;

    public ElasticHealthCheck(ElasticRestClient client, String featureName) {
        this.client = Objects.requireNonNull(client);
        this.featureName = Objects.requireNonNull(featureName);
    }

    public String getDescription() {
        return "Elasticsearch cluster health check for " + this.featureName;
    }

    public List<String> getTags() {
        return List.of(ELASTIC);
    }

    public Response perform(Context context) throws Exception {
        try {
            String clusterHealth = this.client.health();
            if ("green".equalsIgnoreCase(clusterHealth) || "yellow".equalsIgnoreCase(clusterHealth)) {
                return new Response(Status.Success, String.format("Elasticsearch cluster health: %s for %s", clusterHealth, this.featureName));
            }
            return new Response(Status.Failure, String.format("Elasticsearch cluster is unhealthy (status: %s) for %s", clusterHealth, this.featureName));
        }
        catch (IOException e) {
            LOG.error("Failed to check Elasticsearch health", (Throwable)e);
            return new Response(Status.Failure, "Failed to connect to Elasticsearch for " + this.featureName + ": " + e.getMessage());
        }
    }
}

