/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.collection.commands;

import com.codahale.metrics.Meter;
import com.codahale.metrics.MetricRegistry;
import com.codahale.metrics.Timer;
import com.google.common.hash.HashFunction;
import com.google.common.hash.Hashing;
import com.google.common.util.concurrent.RateLimiter;
import java.net.InetAddress;
import java.nio.charset.StandardCharsets;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.karaf.shell.api.action.Action;
import org.apache.karaf.shell.api.action.Command;
import org.apache.karaf.shell.api.action.Option;
import org.apache.karaf.shell.api.action.lifecycle.Reference;
import org.apache.karaf.shell.api.action.lifecycle.Service;
import org.opennms.netmgt.collection.api.AttributeType;
import org.opennms.netmgt.collection.api.CollectionAgent;
import org.opennms.netmgt.collection.api.CollectionSet;
import org.opennms.netmgt.collection.api.CollectionSetVisitor;
import org.opennms.netmgt.collection.api.Persister;
import org.opennms.netmgt.collection.api.PersisterFactory;
import org.opennms.netmgt.collection.api.ServiceParameters;
import org.opennms.netmgt.collection.support.builder.CollectionSetBuilder;
import org.opennms.netmgt.collection.support.builder.InterfaceLevelResource;
import org.opennms.netmgt.collection.support.builder.NodeLevelResource;
import org.opennms.netmgt.collection.support.builder.Resource;
import org.opennms.netmgt.model.ResourcePath;
import org.opennms.netmgt.model.ResourceTypeUtils;
import org.opennms.netmgt.rrd.RrdRepository;

@Command(scope="opennms", name="stress-metrics", description="Stress the current persistence strategy with generated collection sets.")
@Service
public class StressCommand
implements Action {
    @Reference
    private PersisterFactory persisterFactory;
    @Option(name="-b", aliases={"--burst"}, description="Generate the collection sets in bursts instead of continously inserting them", required=false, multiValued=false)
    boolean burst = false;
    @Option(name="-i", aliases={"--interval"}, description="Interval in seconds at which collection sets will be generated", required=false, multiValued=false)
    int intervalInSeconds = 300;
    @Option(name="-n", aliases={"--nodes"}, description="Number of nodes for which metrics will be generated", required=false, multiValued=false)
    int numberOfNodes = 1000;
    @Option(name="-f", aliases={"--interfaces"}, description="Number of interfaces on each node", required=false, multiValued=false)
    int numberOfInterfacesPerNode = 10;
    @Option(name="-g", aliases={"--groups"}, description="Number of groups on each interface", required=false, multiValued=false)
    int numberOfGroupsPerInterface = 5;
    @Option(name="-a", aliases={"--attributes"}, description="Number of number attributes in each group", required=false, multiValued=false)
    int numberOfNumericAttributesPerGroup = 10;
    @Option(name="-s", aliases={"--strings"}, description="Number of string attributes in each group", required=false, multiValued=false)
    int numberOfStringAttributesPerGroup = 2;
    @Option(name="-r", aliases={"--report"}, description="Number of seconds after which the report should be generated", required=false, multiValued=false)
    int reportIntervalInSeconds = 30;
    @Option(name="-t", aliases={"--threads"}, description="Number of threads that will be used to generate and persist collection sets", required=false, multiValued=false)
    int numberOfGeneratorThreads = 1;
    @Option(name="-z", aliases={"--string-variation-factor"}, description="When set, every n-th group will use unique string attribute values in each batch", required=false, multiValued=false)
    int stringVariationFactor = 0;
    @Option(name="-x", aliases={"--rra"}, description="Round Robin Archives, defaults to the same RRA values as a pristine datacollection-config.xml.\nExample: -x 'RRA:AVERAGE:0.5:1:2016' -x 'RRA:AVERAGE:0.5:12:1488'", required=false, multiValued=true)
    List<String> rras = null;
    @Option(name="-ml", aliases={"--metric-extra-length"}, description="It will append specific length of string at the end of metrics.", required=false, multiValued=false)
    int metricExtraLength = 0;
    @Option(name="-mlv", aliases={"--metric-extra-length-variance"}, description="It will affect the length of metric-extra-length. Must be smaller than metric-extra-length.", required=false, multiValued=false)
    int metricExtraLengthVariance = 0;
    @Option(name="-rl", aliases={"--resource-extra-length"}, description="It will append specific length of string at the end of resources.", required=false, multiValued=false)
    int resourceExtraLength = 0;
    @Option(name="-rlv", aliases={"--resource-extra-length-variance"}, description="It will affect the length of resource-extra-length. Must be smaller than resource-extra-length.", required=false, multiValued=false)
    int resourceExtraLengthVariance = 0;
    private RateLimiter rateLimiter;
    private int numNumericAttributesPerNodePerCycle;
    private double numNumericAttributesPerSecond;
    private double numStringAttributesPerSecond;
    private final AtomicBoolean abort = new AtomicBoolean(false);
    private final MetricRegistry metrics = new MetricRegistry();
    final Timer batchTimer = this.metrics.timer("batches");
    private final Meter numericAttributesGenerated = this.metrics.meter("numeric-attributes-generated");
    private final Meter stringAttributesGenerated = this.metrics.meter("string-attributes-generated");
    private Meter stringAttributesVaried;
    private AtomicInteger seed = new AtomicInteger();

    /*
     * Exception decompiling
     */
    public Void execute() throws Exception {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [0[TRYBLOCK]], but top level block is 9[UNCONDITIONALDOLOOP]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private Callable<Void> generateAndPersistCollectionSets(final ServiceParameters params, final RrdRepository repository, final int generatorThreadId) {
        return new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                for (int nodeId = 0; nodeId < StressCommand.this.numberOfNodes; ++nodeId) {
                    if (nodeId % StressCommand.this.numberOfGeneratorThreads != generatorThreadId) continue;
                    if (StressCommand.this.rateLimiter != null) {
                        StressCommand.this.rateLimiter.acquire(StressCommand.this.numNumericAttributesPerNodePerCycle);
                    }
                    MockCollectionAgent agent = new MockCollectionAgent(nodeId);
                    NodeLevelResource nodeResource = new NodeLevelResource(nodeId);
                    Persister persister = StressCommand.this.persisterFactory.createPersister(params, repository);
                    for (int interfaceId = 0; interfaceId < StressCommand.this.numberOfInterfacesPerNode; ++interfaceId) {
                        if (StressCommand.this.abort.get()) {
                            return null;
                        }
                        InterfaceLevelResource interfaceResource = new InterfaceLevelResource(nodeResource, "tap" + interfaceId);
                        CollectionSet collectionSet = StressCommand.this.generateCollectionSet(agent, nodeId, interfaceId, (Resource)interfaceResource);
                        collectionSet.visit((CollectionSetVisitor)persister);
                    }
                }
                return null;
            }
        };
    }

    protected CollectionSet generateCollectionSet(CollectionAgent agent, int nodeId, int interfaceId, Resource resource) {
        CollectionSetBuilder builder = new CollectionSetBuilder(agent);
        for (int groupId = 0; groupId < this.numberOfGroupsPerInterface; ++groupId) {
            String groupName = "group" + groupId;
            for (int attributeId = 0; attributeId < this.numberOfNumericAttributesPerGroup; ++attributeId) {
                int value = groupId * attributeId + this.seed.incrementAndGet() % 100;
                StringBuilder collectionName = new StringBuilder("metric_");
                collectionName.append(groupId);
                collectionName.append("_");
                collectionName.append(attributeId);
                if (this.metricExtraLength > 0) {
                    collectionName.append(this.generateExtraString(collectionName.toString(), nodeId, this.metricExtraLength, this.metricExtraLengthVariance));
                }
                if (this.resourceExtraLength > 0) {
                    groupName = groupName + "_" + this.generateExtraString(groupName, nodeId, this.resourceExtraLength, this.resourceExtraLengthVariance);
                }
                builder.withNumericAttribute(resource, groupName, collectionName.toString(), (Number)value, AttributeType.GAUGE);
                this.numericAttributesGenerated.mark();
            }
            String stringAttributeValueSuffix = "";
            int groupInstance = (nodeId + 1) * (interfaceId + 1) * (groupId + 1);
            if (this.stringVariationFactor > 0 && groupInstance % this.stringVariationFactor == 0) {
                stringAttributeValueSuffix = String.format("-%d-varied", groupInstance);
                this.stringAttributesVaried.mark((long)this.numberOfStringAttributesPerGroup);
            }
            for (int stringAttributeId = 0; stringAttributeId < this.numberOfStringAttributesPerGroup; ++stringAttributeId) {
                String key = String.format("%s-key-%d", groupName, stringAttributeId);
                String value = String.format("%s-value-%d%s", groupName, stringAttributeId, stringAttributeValueSuffix);
                builder.withStringAttribute(resource, groupName, key, value);
                this.stringAttributesGenerated.mark();
            }
        }
        return builder.build();
    }

    private String generateExtraString(String prefix, int id, int length, int variance) {
        HashFunction sha1 = Hashing.sha1();
        String hash = sha1.hashString((CharSequence)prefix, StandardCharsets.UTF_8).toString();
        int outLength = length;
        if (length > 0) {
            outLength = length - variance + id % (2 * variance + 1);
        }
        if (outLength > hash.length()) {
            int repeat = (int)Math.ceil((double)outLength / (double)hash.length());
            hash = hash.repeat(repeat);
        }
        return hash.substring(0, outLength);
    }

    protected static class MockCollectionAgent
    implements CollectionAgent {
        private final int nodeId;

        public MockCollectionAgent(int nodeId) {
            this.nodeId = nodeId;
        }

        public InetAddress getAddress() {
            return null;
        }

        public Set<String> getAttributeNames() {
            return Collections.emptySet();
        }

        public <V> V getAttribute(String property) {
            return null;
        }

        public Object setAttribute(String property, Object value) {
            return null;
        }

        public Boolean isStoreByForeignSource() {
            return ResourceTypeUtils.isStoreByForeignSource();
        }

        public String getHostAddress() {
            return null;
        }

        public int getNodeId() {
            return this.nodeId;
        }

        public String getNodeLabel() {
            return Integer.toString(this.nodeId);
        }

        public String getForeignSource() {
            return "STRESS";
        }

        public String getForeignId() {
            return Integer.toString(this.nodeId);
        }

        public String getLocationName() {
            return null;
        }

        public ResourcePath getStorageResourcePath() {
            String foreignSource = this.getForeignSource();
            String foreignId = this.getForeignId();
            ResourcePath dir = this.isStoreByForeignSource() != false && foreignSource != null && foreignId != null ? ResourcePath.get((String[])new String[]{"fs", foreignSource, foreignId}) : ResourcePath.get((String[])new String[]{String.valueOf(this.getNodeId())});
            return dir;
        }

        public long getSavedSysUpTime() {
            return 0L;
        }

        public void setSavedSysUpTime(long sysUpTime) {
        }
    }
}

