/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.core.daemon;

import com.sun.tools.attach.VirtualMachine;
import com.sun.tools.attach.VirtualMachineDescriptor;
import java.io.IOException;
import java.util.UUID;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class CurrentVirtualMachine {
    private static final Logger LOG = LoggerFactory.getLogger(CurrentVirtualMachine.class);
    private static final String CONNECTOR_ADDRESS = "com.sun.management.jmxremote.localConnectorAddress";
    private static final String VIRTUAL_MACHINE_IDENTIFIER_PROPERTY = "org.opennms.core.daemon.virtualmachine.identifier";
    private static VirtualMachine s_self = null;

    protected CurrentVirtualMachine() {
    }

    public static VirtualMachine get() {
        if (s_self == null) {
            try {
                Class.forName("com.sun.tools.attach.VirtualMachine");
                Class.forName("com.sun.tools.attach.VirtualMachineDescriptor");
                Class.forName("com.sun.tools.attach.AttachNotSupportedException");
            }
            catch (ClassNotFoundException e) {
                LOG.info("The Attach API is not available in this JVM");
                return null;
            }
            String id = UUID.randomUUID().toString();
            System.setProperty(VIRTUAL_MACHINE_IDENTIFIER_PROPERTY, id);
            for (VirtualMachineDescriptor vmDescr : VirtualMachine.list()) {
                try {
                    VirtualMachine vm = VirtualMachine.attach(vmDescr);
                    String attachedIdentifier = vm.getSystemProperties().getProperty(VIRTUAL_MACHINE_IDENTIFIER_PROPERTY);
                    if (attachedIdentifier.equals(id)) {
                        s_self = vm;
                        break;
                    }
                    vm.detach();
                }
                catch (Exception e) {
                    if (!LOG.isWarnEnabled()) continue;
                    LOG.warn("Unable to connect to {}", (Object)vmDescr.displayName(), (Object)e);
                }
            }
        }
        return s_self;
    }

    public static String getJmxUri() {
        String connectorAddress = null;
        VirtualMachine vm = CurrentVirtualMachine.get();
        if (vm == null) {
            throw new IllegalStateException("Unable to determine current virtual machine!");
        }
        try {
            connectorAddress = vm.getAgentProperties().getProperty(CONNECTOR_ADDRESS);
        }
        catch (IOException e) {
            throw new IllegalStateException("IOException when fetching JMX URI from JVM with ID: " + vm.id(), e);
        }
        if (connectorAddress == null) {
            LOG.info("Starting local management agent in JVM with ID: {}", (Object)vm);
            try {
                vm.startLocalManagementAgent();
            }
            catch (IOException e) {
                throw new IllegalStateException("IOException when starting local JMX management agent in JVM with ID: " + vm.id(), e);
            }
            try {
                connectorAddress = vm.getAgentProperties().getProperty(CONNECTOR_ADDRESS);
            }
            catch (IOException e) {
                throw new IllegalStateException("IOException when fetching JMX URI from JVM with ID: " + vm.id(), e);
            }
        }
        try {
            vm.detach();
        }
        catch (IOException e) {
            LOG.warn("failed to detach from VM {}", (Object)vm);
        }
        return connectorAddress;
    }
}

