/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.snmp.proxy.common;

import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import org.opennms.netmgt.snmp.SnmpAgentConfig;
import org.opennms.netmgt.snmp.SnmpObjId;
import org.opennms.netmgt.snmp.SnmpResult;
import org.opennms.netmgt.snmp.SnmpValue;
import org.opennms.netmgt.snmp.proxy.common.AbstractSNMPRequestBuilder;
import org.opennms.netmgt.snmp.proxy.common.LocationAwareSnmpClientRpcImpl;
import org.opennms.netmgt.snmp.proxy.common.SnmpGetRequestDTO;
import org.opennms.netmgt.snmp.proxy.common.SnmpMultiResponseDTO;

public class SNMPMultiGetBuilder
extends AbstractSNMPRequestBuilder<List<SnmpValue>> {
    public SNMPMultiGetBuilder(LocationAwareSnmpClientRpcImpl client, SnmpAgentConfig agent, List<SnmpObjId> oids) {
        super(client, agent, SNMPMultiGetBuilder.buildGetRequests(oids), Collections.emptyList(), Collections.emptyList());
    }

    private static List<SnmpGetRequestDTO> buildGetRequests(List<SnmpObjId> oids) {
        SnmpGetRequestDTO getRequest = new SnmpGetRequestDTO();
        getRequest.setOids(oids);
        return Collections.singletonList(getRequest);
    }

    @Override
    protected List<SnmpValue> processResponse(SnmpMultiResponseDTO response) {
        return response.getResponses().stream().flatMap(res -> res.getResults().stream()).map(SnmpResult::getValue).collect(Collectors.toList());
    }
}

