/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.features.config.service.impl;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Consumer;
import org.opennms.features.config.exception.ValidationException;
import org.opennms.features.config.service.api.ConfigUpdateInfo;
import org.opennms.features.config.service.api.EventType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class EventHandlerManager {
    private static final Logger LOG = LoggerFactory.getLogger(EventHandlerManager.class);
    private final ConcurrentHashMap<EventType, Map<ConfigUpdateInfo, Collection<Consumer<ConfigUpdateInfo>>>> handlerMap = new ConcurrentHashMap();

    public EventHandlerManager() {
        this.handlerMap.put(EventType.CREATE, new ConcurrentHashMap());
        this.handlerMap.put(EventType.DELETE, new ConcurrentHashMap());
        this.handlerMap.put(EventType.VALIDATE, new ConcurrentHashMap());
        this.handlerMap.put(EventType.UPDATE, new ConcurrentHashMap());
    }

    void callEventHandlers(EventType type, ConfigUpdateInfo specificIdent) {
        LOG.debug("Call {} handlers for {}.", (Object)type, (Object)specificIdent);
        Map<ConfigUpdateInfo, Collection<Consumer<ConfigUpdateInfo>>> map = this.handlerMap.get(type);
        ConfigUpdateInfo wildcardIdent = new ConfigUpdateInfo(specificIdent.getConfigName(), ConfigUpdateInfo.WILDCARD_ID);
        this.callEventHandlers(map, specificIdent, specificIdent);
        this.callEventHandlers(map, wildcardIdent, specificIdent);
    }

    private void callEventHandlers(Map<ConfigUpdateInfo, Collection<Consumer<ConfigUpdateInfo>>> map, ConfigUpdateInfo searchIdent, ConfigUpdateInfo actualIdent) {
        map.computeIfPresent(searchIdent, (k, v) -> {
            v.forEach(c -> {
                try {
                    c.accept(actualIdent);
                }
                catch (Exception e) {
                    if (e instanceof ValidationException) {
                        throw e;
                    }
                    LOG.warn("Fail to notify {}, callback: {}, error: {}", new Object[]{actualIdent, v, e.getMessage(), e});
                }
            });
            return v;
        });
    }

    void registerEventHandler(EventType type, ConfigUpdateInfo info, Consumer<ConfigUpdateInfo> consumer) {
        Map<ConfigUpdateInfo, Collection<Consumer<ConfigUpdateInfo>>> map = this.handlerMap.get(type);
        map.compute(info, (k, v) -> {
            if (v == null) {
                ArrayList<Consumer> consumers = new ArrayList<Consumer>();
                consumers.add(consumer);
                return consumers;
            }
            v.add(consumer);
            return v;
        });
    }
}

