/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.plugins.elasticsearch.rest.archive;

import java.io.Reader;
import java.io.StringReader;
import java.lang.invoke.CallSite;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.http.HttpEntity;
import org.apache.http.auth.AuthScope;
import org.apache.http.auth.Credentials;
import org.apache.http.auth.UsernamePasswordCredentials;
import org.apache.http.client.CredentialsProvider;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.impl.client.BasicCredentialsProvider;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.util.EntityUtils;
import org.opennms.core.xml.JaxbUtils;
import org.opennms.netmgt.model.OnmsEvent;
import org.opennms.netmgt.model.OnmsEventCollection;
import org.opennms.netmgt.model.OnmsEventParameter;
import org.opennms.netmgt.xml.event.Event;
import org.opennms.netmgt.xml.event.Logmsg;
import org.opennms.netmgt.xml.event.Parm;
import org.opennms.netmgt.xml.event.Value;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OnmsRestEventsClient {
    public static final String NODE_LABEL = "nodelabel";
    public static final String EVENTS_URI = "/opennms/rest/events";
    public static final String EVENT_COUNT_URI = "/opennms/rest/events/count";
    private static final Logger LOG = LoggerFactory.getLogger(OnmsRestEventsClient.class);
    private final String baseUrl;
    private final String username;
    private final String password;

    public OnmsRestEventsClient(String baseUrl, String username, String password) {
        this.baseUrl = baseUrl;
        this.username = username;
        this.password = password;
    }

    /*
     * Enabled aggressive exception aggregation
     */
    public Integer getEventCount() {
        try (CloseableHttpClient client = this.createHttpClient();){
            Integer n;
            block15: {
                HttpGet request = new HttpGet(this.baseUrl + EVENT_COUNT_URI);
                request.addHeader("accept", "text/plain");
                LOG.debug("Executing request " + request.getRequestLine());
                CloseableHttpResponse response = client.execute((HttpUriRequest)request);
                try {
                    if (response.getStatusLine().getStatusCode() != 200) {
                        throw new RuntimeException("Failed : HTTP error code : " + response.getStatusLine().getStatusCode());
                    }
                    String responseStr = EntityUtils.toString((HttpEntity)response.getEntity());
                    LOG.debug("Response status: {}, entity: {}", (Object)response.getStatusLine(), (Object)responseStr);
                    n = Integer.parseInt(responseStr);
                    if (response == null) break block15;
                }
                catch (Throwable throwable) {
                    if (response != null) {
                        try {
                            response.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                response.close();
            }
            return n;
        }
        catch (Exception e) {
            throw new RuntimeException("An Exception occurred while getting event count: " + e.getMessage(), e);
        }
    }

    public List<Event> getEvents(Integer limit, Integer offset) {
        ArrayList<Event> arrayList;
        block19: {
            ArrayList<Event> retrievedEvents = new ArrayList<Event>();
            CloseableHttpClient httpclient = this.createHttpClient();
            try {
                ArrayList<CallSite> queryParts = new ArrayList<CallSite>();
                if (limit != null) {
                    queryParts.add((CallSite)((Object)("limit=" + limit)));
                }
                if (offset != null) {
                    queryParts.add((CallSite)((Object)("offset=" + offset)));
                }
                String query = queryParts.isEmpty() ? "" : "?" + queryParts.stream().collect(Collectors.joining("&"));
                HttpGet request = new HttpGet(this.baseUrl + EVENTS_URI + query);
                request.addHeader("accept", "application/xml");
                LOG.debug("Executing request " + request.getRequestLine());
                try (CloseableHttpResponse response = httpclient.execute((HttpUriRequest)request);){
                    if (response.getStatusLine().getStatusCode() != 200) {
                        throw new RuntimeException("Failed : HTTP error code : " + response.getStatusLine().getStatusCode());
                    }
                    String responseStr = EntityUtils.toString((HttpEntity)response.getEntity());
                    LOG.debug("Response status: {}, entity: {}", (Object)response.getStatusLine(), (Object)responseStr);
                    StringReader reader = new StringReader(responseStr);
                    OnmsEventCollection eventCollection = (OnmsEventCollection)JaxbUtils.unmarshal(OnmsEventCollection.class, (Reader)reader);
                    LOG.debug("Received event Collection:\u00b4with offset: {}, totalCount: {}, size: {}", new Object[]{eventCollection.getOffset(), eventCollection.getTotalCount(), eventCollection.size()});
                    for (int i = 0; i < eventCollection.size(); ++i) {
                        Event event = OnmsRestEventsClient.toEvent((OnmsEvent)eventCollection.get(i));
                        retrievedEvents.add(event);
                    }
                }
                arrayList = retrievedEvents;
                if (httpclient == null) break block19;
            }
            catch (Throwable throwable) {
                try {
                    if (httpclient != null) {
                        try {
                            httpclient.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (Exception e) {
                    throw new RuntimeException("exception when getting event list: " + e.getMessage(), e);
                }
            }
            httpclient.close();
        }
        return arrayList;
    }

    private static Event toEvent(OnmsEvent onmsEvent) {
        Event event = new Event();
        if (onmsEvent.getId() != null) {
            event.setDbid(onmsEvent.getId());
        }
        if (onmsEvent.getEventUei() != null) {
            event.setUei(onmsEvent.getEventUei());
        }
        if (onmsEvent.getEventCreateTime() != null) {
            event.setCreationTime(onmsEvent.getEventCreateTime());
        }
        if (onmsEvent.getSeverityLabel() != null) {
            event.setSeverity(onmsEvent.getSeverityLabel());
        }
        if (onmsEvent.getEventDescr() != null) {
            event.setDescr(onmsEvent.getEventDescr());
        }
        if (onmsEvent.getEventHost() != null) {
            event.setHost(onmsEvent.getEventHost());
        }
        ArrayList<Parm> parmColl = new ArrayList<Parm>();
        if (onmsEvent.getEventParameters() != null) {
            List params = onmsEvent.getEventParameters();
            for (OnmsEventParameter onmsEventParameter : params) {
                Value parmvalue = new Value();
                parmvalue.setType(onmsEventParameter.getType());
                parmvalue.setContent(onmsEventParameter.getValue());
                Parm parm = new Parm();
                parm.setParmName(onmsEventParameter.getName());
                parm.setValue(parmvalue);
                parmColl.add(parm);
            }
        }
        if (onmsEvent.getNodeLabel() != null) {
            Value parmValue = new Value();
            parmValue.setType("string");
            parmValue.setEncoding("text");
            parmValue.setContent(onmsEvent.getNodeLabel());
            Parm parm = new Parm();
            parm.setParmName(NODE_LABEL);
            parm.setValue(parmValue);
            parmColl.add(parm);
        }
        event.setParmCollection(parmColl);
        if (onmsEvent.getEventLogMsg() != null) {
            Logmsg logmsg = new Logmsg();
            logmsg.setContent(onmsEvent.getEventLogMsg());
            event.setLogmsg(logmsg);
        }
        if (onmsEvent.getNodeId() != null) {
            event.setNodeid(Long.valueOf(onmsEvent.getNodeId().longValue()));
        }
        return event;
    }

    private CloseableHttpClient createHttpClient() {
        BasicCredentialsProvider credentialsProvider = new BasicCredentialsProvider();
        credentialsProvider.setCredentials(AuthScope.ANY, (Credentials)new UsernamePasswordCredentials(this.username, this.password));
        return HttpClients.custom().setDefaultCredentialsProvider((CredentialsProvider)credentialsProvider).build();
    }
}

