/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.plugins.elasticsearch.rest;

import com.google.common.cache.CacheLoader;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ExecutionException;
import org.opennms.core.cache.Cache;
import org.opennms.core.cache.CacheBuilder;
import org.opennms.netmgt.dao.api.NodeDao;
import org.opennms.netmgt.dao.api.SessionUtils;
import org.opennms.netmgt.model.OnmsAssetRecord;
import org.opennms.netmgt.model.OnmsCategory;
import org.opennms.netmgt.model.OnmsGeolocation;
import org.opennms.netmgt.model.OnmsNode;
import org.opennms.plugins.elasticsearch.rest.CacheConfig;
import org.opennms.plugins.elasticsearch.rest.NodeCache;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NodeCacheImpl
implements NodeCache {
    private static final Logger LOG = LoggerFactory.getLogger(NodeCacheImpl.class);
    private final NodeDao nodeDao;
    private final SessionUtils sessionUtils;
    private final boolean archiveAssetData;
    private final Cache<Long, Map<String, String>> cache;

    public NodeCacheImpl(NodeDao nodeDao, SessionUtils sessionUtils, CacheConfig cacheConfig, boolean archiveAssetData) {
        this.nodeDao = Objects.requireNonNull(nodeDao);
        this.sessionUtils = Objects.requireNonNull(sessionUtils);
        this.archiveAssetData = archiveAssetData;
        LOG.info("initializing node data cache (archiveAssetData={}, cacheConfig={})", (Object)archiveAssetData, (Object)cacheConfig);
        this.cache = new CacheBuilder().withConfig((org.opennms.core.cache.CacheConfig)cacheConfig).withCacheLoader((CacheLoader)new CacheLoader<Long, Map<String, String>>(){

            public Map<String, String> load(Long nodeId) {
                return NodeCacheImpl.this.loadNodeAndCategoryInfo(nodeId);
            }
        }).build();
    }

    @Override
    public Map<String, String> getEntry(Long nodeId) {
        try {
            return (Map)this.cache.get((Object)nodeId);
        }
        catch (ExecutionException e) {
            throw new RuntimeException("Error loading entry with key " + nodeId + " from cache", e);
        }
    }

    @Override
    public void refreshEntry(Long nodeId) {
        LOG.debug("refreshing node cache entry: {}", (Object)nodeId);
        this.cache.refresh((Object)nodeId);
    }

    private Map<String, String> loadNodeAndCategoryInfo(Long nodeId) {
        HashMap<String, String> result = new HashMap<String, String>();
        if (nodeId != null) {
            LOG.debug("Fetching node data from database into cache");
            this.sessionUtils.withReadOnlyTransaction(() -> {
                OnmsNode node = this.nodeDao.get(nodeId.toString());
                if (node != null) {
                    this.populateBodyWithNodeInfo(result, node);
                }
                return null;
            });
        }
        return result;
    }

    private void populateBodyWithNodeInfo(Map<String, String> body, OnmsNode node) {
        body.put("nodelabel", node.getLabel());
        body.put("nodesysname", node.getSysName());
        body.put("nodesyslocation", node.getSysLocation());
        body.put("foreignsource", node.getForeignSource());
        body.put("foreignid", node.getForeignId());
        body.put("operatingsystem", node.getOperatingSystem());
        StringBuilder categories = new StringBuilder();
        Iterator i = node.getCategories().iterator();
        while (i.hasNext()) {
            categories.append(((OnmsCategory)i.next()).getName());
            if (!i.hasNext()) continue;
            categories.append(",");
        }
        body.put("categories", categories.toString());
        if (this.archiveAssetData) {
            OnmsAssetRecord assetRecord;
            OnmsNode parent = node.getParent();
            if (parent != null) {
                if (parent.getLabel() != null) {
                    body.put("parent-nodelabel", parent.getLabel());
                }
                if (parent.getNodeId() != null) {
                    body.put("parent-nodeid", parent.getNodeId());
                }
                if (parent.getForeignSource() != null) {
                    body.put("parent-foreignsource", parent.getForeignSource());
                }
                if (parent.getForeignId() != null) {
                    body.put("parent-foreignid", parent.getForeignId());
                }
            }
            if ((assetRecord = node.getAssetRecord()) != null) {
                OnmsGeolocation gl = assetRecord.getGeolocation();
                if (gl != null) {
                    if (gl.getLatitude() != null) {
                        body.put("asset-latitude", gl.getLatitude().toString());
                    }
                    if (gl.getLongitude() != null) {
                        body.put("asset-longitude", gl.getLongitude().toString());
                    }
                }
                if (assetRecord.getRegion() != null && !"".equals(assetRecord.getRegion())) {
                    body.put("asset-region", assetRecord.getRegion());
                }
                if (assetRecord.getBuilding() != null && !"".equals(assetRecord.getBuilding())) {
                    body.put("asset-building", assetRecord.getBuilding());
                }
                if (assetRecord.getFloor() != null && !"".equals(assetRecord.getFloor())) {
                    body.put("asset-floor", assetRecord.getFloor());
                }
                if (assetRecord.getRoom() != null && !"".equals(assetRecord.getRoom())) {
                    body.put("asset-room", assetRecord.getRoom());
                }
                if (assetRecord.getRack() != null && !"".equals(assetRecord.getRack())) {
                    body.put("asset-rack", assetRecord.getRack());
                }
                if (assetRecord.getSlot() != null && !"".equals(assetRecord.getSlot())) {
                    body.put("asset-slot", assetRecord.getSlot());
                }
                if (assetRecord.getPort() != null && !"".equals(assetRecord.getPort())) {
                    body.put("asset-port", assetRecord.getPort());
                }
                if (assetRecord.getCategory() != null && !"".equals(assetRecord.getCategory())) {
                    body.put("asset-category", assetRecord.getCategory());
                }
                if (assetRecord.getDisplayCategory() != null && !"".equals(assetRecord.getDisplayCategory())) {
                    body.put("asset-displaycategory", assetRecord.getDisplayCategory());
                }
                if (assetRecord.getNotifyCategory() != null && !"".equals(assetRecord.getNotifyCategory())) {
                    body.put("asset-notifycategory", assetRecord.getNotifyCategory());
                }
                if (assetRecord.getPollerCategory() != null && !"".equals(assetRecord.getPollerCategory())) {
                    body.put("asset-pollercategory", assetRecord.getPollerCategory());
                }
                if (assetRecord.getThresholdCategory() != null && !"".equals(assetRecord.getThresholdCategory())) {
                    body.put("asset-thresholdcategory", assetRecord.getThresholdCategory());
                }
                if (assetRecord.getManagedObjectType() != null && !"".equals(assetRecord.getManagedObjectType())) {
                    body.put("asset-managedobjecttype", assetRecord.getManagedObjectType());
                }
                if (assetRecord.getManagedObjectInstance() != null && !"".equals(assetRecord.getManagedObjectInstance())) {
                    body.put("asset-managedobjectinstance", assetRecord.getManagedObjectInstance());
                }
                if (assetRecord.getManufacturer() != null && !"".equals(assetRecord.getManufacturer())) {
                    body.put("asset-manufacturer", assetRecord.getManufacturer());
                }
                if (assetRecord.getVendor() != null && !"".equals(assetRecord.getVendor())) {
                    body.put("asset-vendor", assetRecord.getVendor());
                }
                if (assetRecord.getModelNumber() != null && !"".equals(assetRecord.getModelNumber())) {
                    body.put("asset-modelnumber", assetRecord.getModelNumber());
                }
            }
        }
    }
}

