/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.smackx.pubsub;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.jivesoftware.smack.SmackException;
import org.jivesoftware.smack.XMPPConnection;
import org.jivesoftware.smack.XMPPException;
import org.jivesoftware.smack.packet.IQ;
import org.jivesoftware.smack.packet.Packet;
import org.jivesoftware.smackx.disco.packet.DiscoverItems;
import org.jivesoftware.smackx.pubsub.GetItemsRequest;
import org.jivesoftware.smackx.pubsub.Item;
import org.jivesoftware.smackx.pubsub.ItemsExtension;
import org.jivesoftware.smackx.pubsub.Node;
import org.jivesoftware.smackx.pubsub.NodeExtension;
import org.jivesoftware.smackx.pubsub.PubSubElementType;
import org.jivesoftware.smackx.pubsub.PublishItem;
import org.jivesoftware.smackx.pubsub.packet.PubSub;

public class LeafNode
extends Node {
    LeafNode(XMPPConnection connection, String nodeName) {
        super(connection, nodeName);
    }

    public DiscoverItems discoverItems() throws SmackException.NoResponseException, XMPPException.XMPPErrorException, SmackException.NotConnectedException {
        DiscoverItems items = new DiscoverItems();
        items.setTo(this.to);
        items.setNode(this.getId());
        return (DiscoverItems)this.con.createPacketCollectorAndSend((IQ)items).nextResultOrThrow();
    }

    public <T extends Item> List<T> getItems() throws SmackException.NoResponseException, XMPPException.XMPPErrorException, SmackException.NotConnectedException {
        PubSub request = this.createPubsubPacket(IQ.Type.GET, new GetItemsRequest(this.getId()));
        PubSub result = (PubSub)this.con.createPacketCollectorAndSend((IQ)request).nextResultOrThrow();
        ItemsExtension itemsElem = (ItemsExtension)result.getExtension(PubSubElementType.ITEMS);
        return itemsElem.getItems();
    }

    public <T extends Item> List<T> getItems(String subscriptionId) throws SmackException.NoResponseException, XMPPException.XMPPErrorException, SmackException.NotConnectedException {
        PubSub request = this.createPubsubPacket(IQ.Type.GET, new GetItemsRequest(this.getId(), subscriptionId));
        PubSub result = (PubSub)this.con.createPacketCollectorAndSend((IQ)request).nextResultOrThrow();
        ItemsExtension itemsElem = (ItemsExtension)result.getExtension(PubSubElementType.ITEMS);
        return itemsElem.getItems();
    }

    public <T extends Item> List<T> getItems(Collection<String> ids) throws SmackException.NoResponseException, XMPPException.XMPPErrorException, SmackException.NotConnectedException {
        ArrayList<Item> itemList = new ArrayList<Item>(ids.size());
        for (String id : ids) {
            itemList.add(new Item(id));
        }
        PubSub request = this.createPubsubPacket(IQ.Type.GET, new ItemsExtension(ItemsExtension.ItemsElementType.items, this.getId(), itemList));
        PubSub result = (PubSub)this.con.createPacketCollectorAndSend((IQ)request).nextResultOrThrow();
        ItemsExtension itemsElem = (ItemsExtension)result.getExtension(PubSubElementType.ITEMS);
        return itemsElem.getItems();
    }

    public <T extends Item> List<T> getItems(int maxItems) throws SmackException.NoResponseException, XMPPException.XMPPErrorException, SmackException.NotConnectedException {
        PubSub request = this.createPubsubPacket(IQ.Type.GET, new GetItemsRequest(this.getId(), maxItems));
        PubSub result = (PubSub)this.con.createPacketCollectorAndSend((IQ)request).nextResultOrThrow();
        ItemsExtension itemsElem = (ItemsExtension)result.getExtension(PubSubElementType.ITEMS);
        return itemsElem.getItems();
    }

    public <T extends Item> List<T> getItems(int maxItems, String subscriptionId) throws SmackException.NoResponseException, XMPPException.XMPPErrorException, SmackException.NotConnectedException {
        PubSub request = this.createPubsubPacket(IQ.Type.GET, new GetItemsRequest(this.getId(), subscriptionId, maxItems));
        PubSub result = (PubSub)this.con.createPacketCollectorAndSend((IQ)request).nextResultOrThrow();
        ItemsExtension itemsElem = (ItemsExtension)result.getExtension(PubSubElementType.ITEMS);
        return itemsElem.getItems();
    }

    public void publish() throws SmackException.NotConnectedException {
        PubSub packet = this.createPubsubPacket(IQ.Type.SET, new NodeExtension(PubSubElementType.PUBLISH, this.getId()));
        this.con.sendPacket((Packet)packet);
    }

    public <T extends Item> void publish(T item) throws SmackException.NotConnectedException {
        ArrayList<T> items = new ArrayList<T>(1);
        items.add(item == null ? new Item() : item);
        this.publish(items);
    }

    public <T extends Item> void publish(Collection<T> items) throws SmackException.NotConnectedException {
        PubSub packet = this.createPubsubPacket(IQ.Type.SET, new PublishItem<T>(this.getId(), items));
        this.con.sendPacket((Packet)packet);
    }

    public void send() throws SmackException.NoResponseException, XMPPException.XMPPErrorException, SmackException.NotConnectedException {
        PubSub packet = this.createPubsubPacket(IQ.Type.SET, new NodeExtension(PubSubElementType.PUBLISH, this.getId()));
        this.con.createPacketCollectorAndSend((IQ)packet).nextResultOrThrow();
    }

    public <T extends Item> void send(T item) throws SmackException.NoResponseException, XMPPException.XMPPErrorException, SmackException.NotConnectedException {
        ArrayList<T> items = new ArrayList<T>(1);
        items.add(item == null ? new Item() : item);
        this.send(items);
    }

    public <T extends Item> void send(Collection<T> items) throws SmackException.NoResponseException, XMPPException.XMPPErrorException, SmackException.NotConnectedException {
        PubSub packet = this.createPubsubPacket(IQ.Type.SET, new PublishItem<T>(this.getId(), items));
        this.con.createPacketCollectorAndSend((IQ)packet).nextResultOrThrow();
    }

    public void deleteAllItems() throws SmackException.NoResponseException, XMPPException.XMPPErrorException, SmackException.NotConnectedException {
        PubSub request = this.createPubsubPacket(IQ.Type.SET, new NodeExtension(PubSubElementType.PURGE_OWNER, this.getId()), PubSubElementType.PURGE_OWNER.getNamespace());
        this.con.createPacketCollectorAndSend((IQ)request).nextResultOrThrow();
    }

    public void deleteItem(String itemId) throws SmackException.NoResponseException, XMPPException.XMPPErrorException, SmackException.NotConnectedException {
        ArrayList<String> items = new ArrayList<String>(1);
        items.add(itemId);
        this.deleteItem(items);
    }

    public void deleteItem(Collection<String> itemIds) throws SmackException.NoResponseException, XMPPException.XMPPErrorException, SmackException.NotConnectedException {
        ArrayList<Item> items = new ArrayList<Item>(itemIds.size());
        for (String id : itemIds) {
            items.add(new Item(id));
        }
        PubSub request = this.createPubsubPacket(IQ.Type.SET, new ItemsExtension(ItemsExtension.ItemsElementType.retract, this.getId(), items));
        this.con.createPacketCollectorAndSend((IQ)request).nextResultOrThrow();
    }
}

