/*
 * Decompiled with CFR 0.152.
 */
package io.hawt.jmx;

import io.hawt.jmx.JmxTreeWatcher;
import io.hawt.jmx.PluginRegistryMBean;
import java.util.concurrent.atomic.AtomicLong;
import javax.management.MBeanServerNotification;
import javax.management.MalformedObjectNameException;
import javax.management.Notification;
import javax.management.NotificationFilter;
import javax.management.NotificationListener;
import javax.management.ObjectName;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PluginRegistry
extends JmxTreeWatcher
implements PluginRegistryMBean {
    private static final transient Logger LOG = LoggerFactory.getLogger(PluginRegistry.class);
    private AtomicLong updateCounter = new AtomicLong(0L);
    private ObjectName comparator = null;

    @Override
    public void init() {
        try {
            this.comparator = new ObjectName("hawtio:type=plugin,name=*");
            super.init();
        }
        catch (MalformedObjectNameException mone) {
            LOG.error("Failed to initialize comparator object name", (Throwable)mone);
        }
        catch (Exception e) {
            LOG.error("Failed to initialize plugin registry: ", (Throwable)e);
        }
    }

    @Override
    protected ObjectName getObjectName() throws Exception {
        return new ObjectName("hawtio:type=Registry");
    }

    @Override
    protected NotificationListener getNotificationListener() {
        return (notification, handback) -> {
            LOG.debug("Got notification: {} for object {}", (Object)notification, handback);
            this.updateCounter.incrementAndGet();
        };
    }

    @Override
    protected NotificationFilter getNotificationFilter() {
        return new NotificationFilter(){
            private static final long serialVersionUID = 1L;

            @Override
            public boolean isNotificationEnabled(Notification notification) {
                if (notification instanceof MBeanServerNotification) {
                    MBeanServerNotification n = (MBeanServerNotification)notification;
                    return PluginRegistry.this.comparator.apply(n.getMBeanName());
                }
                return false;
            }
        };
    }

    @Override
    public long getUpdateCounter() {
        return this.updateCounter.get();
    }
}

