/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.poller.monitors;

import java.sql.Connection;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.Map;
import org.opennms.core.utils.ParameterMap;
import org.opennms.netmgt.poller.PollStatus;
import org.opennms.netmgt.poller.monitors.JDBCMonitor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class JDBCQueryMonitor
extends JDBCMonitor {
    public static final Logger LOG = LoggerFactory.getLogger(JDBCQueryMonitor.class);
    private static final int OPERATOR_MAP_EQUALS = 0;
    private static final int OPERATOR_MAP_LESS_THAN = 1;
    private static final int OPERATOR_MAP_GREATER_THAN = 2;
    private static final int OPERATOR_MAP_NOT_EQUAL = 3;
    private static final int OPERATOR_MAP_LESS_THAN_EQUAL_TO = 4;
    private static final int OPERATOR_MAP_GREATER_THAN_EQUAL_TO = 5;
    private static final int QUERY_ACTION_ROW_COUNT = 0;
    private static final int QUERY_ACTION_COMPARE_STRING = 1;
    private static final int QUERY_ACTION_COMPARE_INT = 2;
    private static final int QUERY_ACTION_COMPARE_BOOLEAN = 3;
    private static Map<String, Integer> operatorMap = new HashMap<String, Integer>();
    private static Map<String, Integer> actionMap = new HashMap<String, Integer>();

    public JDBCQueryMonitor() throws ClassNotFoundException, InstantiationException, IllegalAccessException {
        operatorMap.put("=", 0);
        operatorMap.put("<", 1);
        operatorMap.put(">", 2);
        operatorMap.put("!=", 3);
        operatorMap.put("<=", 4);
        operatorMap.put(">=", 5);
        actionMap.put("row_count", 0);
        actionMap.put("compare_string", 1);
        actionMap.put("compare_int", 2);
        actionMap.put("compare_bool", 3);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    @Override
    public PollStatus checkDatabaseStatus(Connection con, Map<String, Object> parameters) {
        ps = PollStatus.unavailable();
        st = null;
        query = ParameterMap.getKeyedString(parameters, (String)"query", null);
        action = ParameterMap.getKeyedString(parameters, (String)"action", (String)"row_count");
        column = ParameterMap.getKeyedString(parameters, (String)"column", null);
        operator = ParameterMap.getKeyedString(parameters, (String)"operator", (String)">=");
        message = ParameterMap.getKeyedString(parameters, (String)"message", null);
        JDBCQueryMonitor.LOG.debug("Query: {}", (Object)query);
        if (query == null) {
            ps = PollStatus.unavailable((String)"Null Query, ensure query value set in poller configuration.");
            return ps;
        }
        try {
            st = con.createStatement(1005, 1007);
            rs = st.executeQuery(query);
            rs.first();
            switch (JDBCQueryMonitor.actionMap.get(action)) {
                case 0: {
                    rs.last();
                    rowCount = rs.getRow();
                    expectedRowCount = ParameterMap.getKeyedInteger(parameters, (String)"operand", (int)1);
                    if (this.integerCheck(rowCount, expectedRowCount, operator)) {
                        ps = PollStatus.available();
                        ** break;
lbl26:
                        // 1 sources

                    } else {
                        ps = PollStatus.unavailable((String)("Row Count Check Failed: " + rowCount + " " + operator + " " + expectedRowCount));
                        ** break;
                    }
lbl29:
                    // 1 sources

                    break;
                }
                case 1: {
                    expectedString = ParameterMap.getKeyedString(parameters, (String)"operand", null);
                    retrivedString = rs.getString(column);
                    if (expectedString.equals(retrivedString)) {
                        ps = PollStatus.available();
                        ** break;
lbl36:
                        // 1 sources

                    } else {
                        ps = PollStatus.unavailable((String)("String Field Check Failed: Expected: " + expectedString + " Returned: " + retrivedString));
                        ** break;
                    }
lbl39:
                    // 1 sources

                    break;
                }
                case 2: {
                    expectedInt = ParameterMap.getKeyedInteger(parameters, (String)"operand", (int)1);
                    retrivedInt = rs.getInt(column);
                    if (this.integerCheck(retrivedInt, expectedInt, operator)) {
                        ps = PollStatus.available();
                        ** break;
lbl46:
                        // 1 sources

                    } else {
                        ps = PollStatus.unavailable((String)("Integer Field Check Failed: " + expectedInt + " " + operator + " " + retrivedInt));
                    }
                    break;
                }
                ** default:
lbl50:
                // 1 sources

                break;
            }
        }
        catch (SQLException sqle) {
            ps = PollStatus.unavailable((String)("Err: " + sqle.toString()));
        }
        catch (Exception exp) {
            ps = PollStatus.unavailable((String)("Err: " + exp.toString()));
        }
        finally {
            this.closeStmt(st);
        }
        if (message != null && ps.isUnavailable()) {
            ps = PollStatus.unavailable((String)(message + " " + ps.getReason()));
        }
        return ps;
    }

    private boolean integerCheck(int val, int expected, String operator) {
        switch (operatorMap.get(operator)) {
            case 0: {
                return val == expected;
            }
            case 2: {
                return val > expected;
            }
            case 5: {
                return val >= expected;
            }
            case 1: {
                return val < expected;
            }
            case 4: {
                return val <= expected;
            }
            case 3: {
                return val != expected;
            }
        }
        return false;
    }
}

