/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.dao.util;

import java.util.List;
import org.opennms.netmgt.events.api.EventDatabaseConstants;
import org.opennms.netmgt.xml.event.Operaction;

public abstract class OperatorAction {
    public static String format(Operaction opact) {
        String text = opact.getContent();
        String state = opact.getState();
        return EventDatabaseConstants.escape((String)text, (char)',') + "," + state;
    }

    public static String format(List<Operaction> opacts, int sz) {
        StringBuilder buf = new StringBuilder();
        boolean first = true;
        for (Operaction opact : opacts) {
            if (!first) {
                buf.append(';');
            } else {
                first = false;
            }
            buf.append(EventDatabaseConstants.escape((String)OperatorAction.format(opact), (char)';'));
        }
        if (buf.length() >= sz) {
            buf.setLength(sz - 4);
            buf.append("...");
        }
        return buf.toString();
    }
}

