/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.v7.data.util.sqlcontainer;

import com.vaadin.v7.data.Property;
import com.vaadin.v7.data.util.converter.Converter;
import com.vaadin.v7.data.util.sqlcontainer.RowItem;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Date;

@Deprecated
public final class ColumnProperty
implements Property {
    private static final long serialVersionUID = -3694463129581802457L;
    private RowItem owner;
    private String propertyId;
    private boolean readOnly;
    private boolean allowReadOnlyChange = true;
    private boolean nullable = true;
    private Object value;
    private Object changedValue;
    private Class<?> type;
    private boolean modified;
    private boolean versionColumn;
    private boolean primaryKey = false;

    private ColumnProperty() {
    }

    @Deprecated
    public ColumnProperty(String propertyId, boolean readOnly, boolean allowReadOnlyChange, boolean nullable, Object value, Class<?> type) {
        this(propertyId, readOnly, allowReadOnlyChange, nullable, false, value, type);
    }

    public ColumnProperty(String propertyId, boolean readOnly, boolean allowReadOnlyChange, boolean nullable, boolean primaryKey, Object value, Class<?> type) {
        if (propertyId == null) {
            throw new IllegalArgumentException("Properties must be named.");
        }
        if (type == null) {
            throw new IllegalArgumentException("Property type must be set.");
        }
        this.propertyId = propertyId;
        this.type = type;
        this.value = value;
        this.allowReadOnlyChange = allowReadOnlyChange;
        this.nullable = nullable;
        this.readOnly = readOnly;
        this.primaryKey = primaryKey;
    }

    public Object getValue() {
        if (this.isModified()) {
            return this.changedValue;
        }
        return this.value;
    }

    public Object getOldValue() {
        return this.value;
    }

    public void setValue(Object newValue) throws Property.ReadOnlyException, Converter.ConversionException {
        boolean isDateProperty;
        if (newValue == null && !this.nullable) {
            throw new NotNullableException("Null values are not allowed for this property.");
        }
        if (this.readOnly) {
            throw new Property.ReadOnlyException("Cannot set value for read-only property.");
        }
        boolean bl = isDateProperty = Time.class.equals(this.getType()) || java.sql.Date.class.equals(this.getType()) || Timestamp.class.equals(this.getType());
        if (newValue != null) {
            if (isDateProperty) {
                long millis = 0L;
                if (newValue instanceof Date) {
                    millis = ((Date)newValue).getTime();
                    if (Time.class.equals(this.getType())) {
                        newValue = new Time(millis);
                    } else if (java.sql.Date.class.equals(this.getType())) {
                        newValue = new java.sql.Date(millis);
                    } else if (Timestamp.class.equals(this.getType())) {
                        newValue = new Timestamp(millis);
                    }
                }
            }
            if (!this.getType().isAssignableFrom(newValue.getClass())) {
                throw new IllegalArgumentException("Illegal value type for ColumnProperty");
            }
            if (this.isValueAlreadySet(newValue)) {
                return;
            }
        }
        this.changedValue = newValue;
        this.modified = true;
        this.owner.getContainer().itemChangeNotification(this.owner);
    }

    private boolean isValueAlreadySet(Object newValue) {
        Object referenceValue = this.isModified() ? this.changedValue : this.value;
        return this.isNullable() && newValue == null && referenceValue == null || newValue.equals(referenceValue);
    }

    public Class<?> getType() {
        return this.type;
    }

    @Override
    public boolean isReadOnly() {
        return this.readOnly;
    }

    public boolean isReadOnlyChangeAllowed() {
        return this.allowReadOnlyChange;
    }

    @Override
    public void setReadOnly(boolean newStatus) {
        if (this.allowReadOnlyChange) {
            this.readOnly = newStatus;
        }
    }

    public boolean isPrimaryKey() {
        return this.primaryKey;
    }

    public String getPropertyId() {
        return this.propertyId;
    }

    public void setOwner(RowItem owner) {
        if (owner == null) {
            throw new IllegalArgumentException("Owner can not be set to null.");
        }
        if (this.owner != null) {
            throw new IllegalStateException("ColumnProperties can only be bound once.");
        }
        this.owner = owner;
    }

    public boolean isModified() {
        return this.modified;
    }

    public boolean isVersionColumn() {
        return this.versionColumn;
    }

    public void setVersionColumn(boolean versionColumn) {
        this.versionColumn = versionColumn;
    }

    public boolean isNullable() {
        return this.nullable;
    }

    public boolean isPersistent() {
        if (this.isVersionColumn()) {
            return false;
        }
        return this.isReadOnlyChangeAllowed() && !this.isReadOnly();
    }

    public boolean isRowIdentifier() {
        return this.isPrimaryKey() || this.isVersionColumn();
    }

    public void commit() {
        if (this.isModified()) {
            this.modified = false;
            this.value = this.changedValue;
        }
    }

    @Deprecated
    public class NotNullableException
    extends RuntimeException {
        public NotNullableException() {
        }

        public NotNullableException(String msg) {
            super(msg);
        }

        public NotNullableException(Throwable cause) {
            super(cause);
        }
    }
}

