/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.core.utils.jexl;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

public final class OnmsJexlSandbox {
    private final Map<String, Permissions> sandbox;
    private final boolean white;
    private static final Names WHITE_NAMES = new Names(){

        @Override
        public boolean add(String name) {
            return false;
        }

        @Override
        protected Names copy() {
            return this;
        }
    };
    private static final Permissions ALL_WHITE = new Permissions(WHITE_NAMES, WHITE_NAMES, WHITE_NAMES);

    public OnmsJexlSandbox() {
        this(false, new HashMap<String, Permissions>());
    }

    public OnmsJexlSandbox(boolean wb) {
        this(wb, new HashMap<String, Permissions>());
    }

    protected OnmsJexlSandbox(Map<String, Permissions> map) {
        this(true, map);
    }

    protected OnmsJexlSandbox(boolean wb, Map<String, Permissions> map) {
        this.white = wb;
        this.sandbox = map;
    }

    public OnmsJexlSandbox copy() {
        HashMap<String, Permissions> map = new HashMap<String, Permissions>();
        for (Map.Entry<String, Permissions> entry : this.sandbox.entrySet()) {
            map.put(entry.getKey(), entry.getValue().copy());
        }
        return new OnmsJexlSandbox(this.white, map);
    }

    public String read(Class<?> clazz, String name) {
        return this.read(clazz.getName(), name);
    }

    public String read(String clazz, String name) {
        Permissions permissions = this.sandbox.get(clazz);
        if (permissions == null) {
            return this.white ? name : null;
        }
        return permissions.read().get(name);
    }

    public String write(Class<?> clazz, String name) {
        return this.write(clazz.getName(), name);
    }

    public String write(String clazz, String name) {
        Permissions permissions = this.sandbox.get(clazz);
        if (permissions == null) {
            return this.white ? name : null;
        }
        return permissions.write().get(name);
    }

    public String execute(Class<?> clazz, String name) {
        return this.execute(clazz.getName(), name);
    }

    public String execute(String clazz, String name) {
        Permissions permissions = this.sandbox.get(clazz);
        if (permissions == null) {
            return this.white ? name : null;
        }
        return permissions.execute().get(name);
    }

    public Permissions permissions(String clazz, boolean readFlag, boolean writeFlag, boolean executeFlag) {
        Permissions box = new Permissions(readFlag, writeFlag, executeFlag);
        this.sandbox.put(clazz, box);
        return box;
    }

    public Permissions white(String clazz) {
        return this.permissions(clazz, true, true, true);
    }

    public Permissions black(String clazz) {
        return this.permissions(clazz, false, false, false);
    }

    public Permissions get(String clazz) {
        Permissions permissions = this.sandbox.get(clazz);
        if (permissions == null) {
            return ALL_WHITE;
        }
        return permissions;
    }

    public static final class Permissions {
        private final Names read;
        private final Names write;
        private final Names execute;

        Permissions(boolean readFlag, boolean writeFlag, boolean executeFlag) {
            this(readFlag ? new WhiteSet() : new BlackSet(), writeFlag ? new WhiteSet() : new BlackSet(), executeFlag ? new WhiteSet() : new BlackSet());
        }

        Permissions(Names nread, Names nwrite, Names nexecute) {
            this.read = nread != null ? nread : WHITE_NAMES;
            this.write = nwrite != null ? nwrite : WHITE_NAMES;
            this.execute = nexecute != null ? nexecute : WHITE_NAMES;
        }

        Permissions copy() {
            return new Permissions(this.read.copy(), this.write.copy(), this.execute.copy());
        }

        public Permissions read(String ... pnames) {
            for (String pname : pnames) {
                this.read.add(pname);
            }
            return this;
        }

        public Permissions write(String ... pnames) {
            for (String pname : pnames) {
                this.write.add(pname);
            }
            return this;
        }

        public Permissions execute(String ... mnames) {
            for (String mname : mnames) {
                this.execute.add(mname);
            }
            return this;
        }

        public Names read() {
            return this.read;
        }

        public Names write() {
            return this.write;
        }

        public Names execute() {
            return this.execute;
        }
    }

    public static abstract class Names {
        public abstract boolean add(String var1);

        public boolean alias(String name, String alias) {
            return false;
        }

        public String get(String name) {
            return name;
        }

        protected Names copy() {
            return this;
        }
    }

    public static final class BlackSet
    extends Names {
        private Set<String> names = null;

        @Override
        protected Names copy() {
            BlackSet copy = new BlackSet();
            copy.names = this.names == null ? null : new HashSet<String>(this.names);
            return copy;
        }

        @Override
        public boolean add(String name) {
            if (this.names == null) {
                this.names = new HashSet<String>();
            }
            return this.names.add(name);
        }

        @Override
        public String get(String name) {
            return this.names != null && !this.names.contains(name) ? name : null;
        }
    }

    public static final class WhiteSet
    extends Names {
        private Map<String, String> names = null;

        @Override
        protected Names copy() {
            WhiteSet copy = new WhiteSet();
            copy.names = this.names == null ? null : new HashMap<String, String>(this.names);
            return copy;
        }

        @Override
        public boolean add(String name) {
            if (this.names == null) {
                this.names = new HashMap<String, String>();
            }
            return this.names.put(name, name) == null;
        }

        @Override
        public boolean alias(String name, String alias) {
            if (this.names == null) {
                this.names = new HashMap<String, String>();
            }
            return this.names.put(alias, name) == null;
        }

        @Override
        public String get(String name) {
            if (this.names == null) {
                return name;
            }
            return this.names.get(name);
        }
    }
}

