/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.features.reporting.dao.remoterepository;

import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.util.ArrayList;
import java.util.List;
import org.opennms.core.xml.JaxbUtils;
import org.opennms.features.reporting.dao.remoterepository.RemoteRepositoryConfigDao;
import org.opennms.features.reporting.model.remoterepository.RemoteRepositoryConfig;
import org.opennms.features.reporting.model.remoterepository.RemoteRepositoryDefinition;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.io.Resource;
import org.springframework.util.Assert;

public class DefaultRemoteRepositoryConfigDao
implements RemoteRepositoryConfigDao {
    private Logger logger = LoggerFactory.getLogger(DefaultRemoteRepositoryConfigDao.class);
    private Resource m_configResource;
    private RemoteRepositoryConfig m_remoteRepositoryConfig;
    private String m_jasperReportsVersion;

    public DefaultRemoteRepositoryConfigDao(Resource configResource) {
        this.m_configResource = configResource;
        Assert.notNull((Object)this.m_configResource, (String)"property configResource must be set to a non-null value");
        this.logger.debug("Config resource is set to " + this.m_configResource.toString());
        try {
            this.loadConfiguration();
        }
        catch (Exception e) {
            this.logger.error("Error could not load remote-repository.xml. Error message: '{}'", (Object)e.getMessage());
        }
        this.logger.debug("Configuration '{}' successfully loaded and unmarshalled.", (Object)this.m_configResource.getFilename());
    }

    @Override
    public void loadConfiguration() throws Exception {
        File file = null;
        try {
            file = this.m_configResource.getFile();
            Assert.notNull((Object)file, (String)"config file must be set to a non-null value");
        }
        catch (IOException e) {
            this.logger.error("Resource '{}' does not seem to have an underlying File object.", (Object)this.m_configResource, (Object)e);
            return;
        }
        this.setRemoteRepositoryConfig((RemoteRepositoryConfig)JaxbUtils.unmarshal(RemoteRepositoryConfig.class, (File)file));
        Assert.notNull((Object)this.m_remoteRepositoryConfig, (String)"unmarshall config file returned a null value.");
        this.logger.debug("Unmarshalling config file '{}'", (Object)file.getAbsolutePath());
        this.logger.debug("Remote repository configuration assigned: '{}'", (Object)this.m_remoteRepositoryConfig);
        this.setJasperReportsVersion(this.m_remoteRepositoryConfig.getJasperReportsVersion());
    }

    @Override
    public Resource getConfigResource() {
        return this.m_configResource;
    }

    @Override
    public void setConfigResource(Resource configResource) {
        this.m_configResource = configResource;
    }

    @Override
    public String getJasperReportsVersion() {
        return this.m_jasperReportsVersion;
    }

    @Override
    public Boolean isRepositoryActive(String repositoryID) {
        return this.getRepositoryById(repositoryID).isRepositoryActive();
    }

    @Override
    public URI getURI(String repositoryID) {
        return this.getRepositoryById(repositoryID).getURI();
    }

    @Override
    public String getLoginUser(String repositoryID) {
        return this.getRepositoryById(repositoryID).getLoginUser();
    }

    @Override
    public String getLoginRepoPassword(String repositoryID) {
        return this.getRepositoryById(repositoryID).getLoginRepoPassword();
    }

    @Override
    public String getRepositoryName(String repositoryID) {
        return this.getRepositoryById(repositoryID).getRepositoryName();
    }

    @Override
    public String getRepositoryDescription(String repositoryID) {
        return this.getRepositoryById(repositoryID).getRepositoryDescription();
    }

    @Override
    public String getRepositoryManagementURL(String repositoryID) {
        return this.getRepositoryById(repositoryID).getRepositoryManagementURL();
    }

    @Override
    public List<RemoteRepositoryDefinition> getAllRepositories() {
        ArrayList<RemoteRepositoryDefinition> resultList = new ArrayList<RemoteRepositoryDefinition>();
        resultList.addAll(this.m_remoteRepositoryConfig.getRepositoryList());
        return resultList;
    }

    @Override
    public List<RemoteRepositoryDefinition> getActiveRepositories() {
        ArrayList<RemoteRepositoryDefinition> resultList = new ArrayList<RemoteRepositoryDefinition>();
        for (RemoteRepositoryDefinition repository : this.m_remoteRepositoryConfig.getRepositoryList()) {
            if (!repository.isRepositoryActive().booleanValue()) continue;
            resultList.add(repository);
        }
        return resultList;
    }

    @Override
    public RemoteRepositoryDefinition getRepositoryById(String repositoryID) {
        RemoteRepositoryDefinition result = null;
        for (RemoteRepositoryDefinition repository : this.getAllRepositories()) {
            if (!repositoryID.equals(repository.getRepositoryId())) continue;
            return repository;
        }
        return result;
    }

    private void setRemoteRepositoryConfig(RemoteRepositoryConfig remoteRepositoryConfig) {
        this.m_remoteRepositoryConfig = remoteRepositoryConfig;
    }

    private void setJasperReportsVersion(String jasperReportsVersion) {
        this.m_jasperReportsVersion = jasperReportsVersion;
    }
}

