/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.icmp.jni6;

import java.io.IOException;
import java.net.DatagramPacket;
import java.net.Inet6Address;
import org.opennms.core.logging.Logging;
import org.opennms.core.tracker.Messenger;
import org.opennms.core.tracker.ReplyHandler;
import org.opennms.netmgt.icmp.jni6.Jni6PingRequest;
import org.opennms.netmgt.icmp.jni6.Jni6PingResponse;
import org.opennms.protocols.icmp6.ICMPv6EchoReply;
import org.opennms.protocols.icmp6.ICMPv6Packet;
import org.opennms.protocols.icmp6.ICMPv6Socket;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Jni6IcmpMessenger
implements Messenger<Jni6PingRequest, Jni6PingResponse> {
    private static final Logger LOG = LoggerFactory.getLogger(Jni6IcmpMessenger.class);
    private int m_pingerId;
    private ICMPv6Socket m_socket;

    public Jni6IcmpMessenger(int pingerId) throws IOException {
        this.m_pingerId = pingerId;
        this.m_socket = new ICMPv6Socket(Integer.valueOf(pingerId).shortValue());
    }

    void processPackets(ReplyHandler<Jni6PingResponse> callback) {
        while (true) {
            try {
                while (true) {
                    DatagramPacket packet;
                    Jni6PingResponse reply;
                    if ((reply = Jni6IcmpMessenger.createPingResponse(packet = this.m_socket.receive())) == null || reply.getIdentifier() != this.m_pingerId) {
                        continue;
                    }
                    callback.handleReply((Object)reply);
                }
            }
            catch (IOException e) {
                LOG.error("I/O Error occurred reading from ICMP Socket", (Throwable)e);
                continue;
            }
            catch (IllegalArgumentException e) {
                continue;
            }
            catch (IndexOutOfBoundsException e) {
                continue;
            }
            catch (Throwable e) {
                LOG.error("Unexpected Exception processing reply packet!", e);
                continue;
            }
            break;
        }
    }

    public void sendRequest(Jni6PingRequest request) {
        request.send(this.m_socket);
    }

    public void start(final ReplyHandler<Jni6PingResponse> callback) {
        Thread socketReader = new Thread("JNI-ICMP-" + this.m_pingerId + "-Socket-Reader"){

            @Override
            public void run() {
                Logging.putPrefix((String)"icmp");
                try {
                    Jni6IcmpMessenger.this.processPackets((ReplyHandler<Jni6PingResponse>)callback);
                }
                catch (Throwable t) {
                    LOG.error("Unexpected exception on Thread {}!", (Object)this, (Object)t);
                }
            }
        };
        socketReader.setDaemon(true);
        socketReader.start();
    }

    public static Jni6PingResponse createPingResponse(DatagramPacket packet) {
        ICMPv6Packet icmpPacket = new ICMPv6Packet(packet.getData(), packet.getOffset(), packet.getLength());
        if (icmpPacket.getType() != ICMPv6Packet.Type.EchoReply) {
            return null;
        }
        ICMPv6EchoReply echoReply = new ICMPv6EchoReply(icmpPacket);
        if (!echoReply.isEchoReply() || !echoReply.isValid()) {
            return null;
        }
        Inet6Address address = (Inet6Address)packet.getAddress();
        return new Jni6PingResponse(address, echoReply);
    }

    public void setTrafficClass(int tc) throws IOException {
        try {
            this.m_socket.setTrafficClass(tc);
        }
        catch (IOException e) {
            LOG.error("Failed to set traffic class {} on ICMPv6 socket.", (Object)tc, (Object)e);
        }
    }

    public void setAllowFragmentation(boolean allow) throws IOException {
        if (!allow) {
            try {
                this.m_socket.dontFragment();
            }
            catch (IOException e) {
                LOG.error("Failed to set 'Don't Fragment' bit on ICMPv6 socket.", (Throwable)e);
            }
        }
    }
}

