/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.web.category;

import java.io.IOException;
import java.util.concurrent.Callable;
import org.opennms.core.logging.Logging;
import org.opennms.core.resource.Vault;
import org.opennms.netmgt.config.ViewsDisplayFactory;
import org.opennms.netmgt.config.viewsdisplay.Section;
import org.opennms.netmgt.config.viewsdisplay.View;
import org.opennms.netmgt.events.api.EventProxy;
import org.opennms.netmgt.events.api.EventProxyException;
import org.opennms.netmgt.model.events.EventBuilder;
import org.opennms.web.api.Util;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RTCPostSubscriber {
    private static final String LOGGING_PREFIX = "rtc";
    private static final Logger LOG = LoggerFactory.getLogger(RTCPostSubscriber.class);
    protected final EventProxy m_proxy = Util.createEventProxy();

    protected static void sendSubscribeEvent(final EventProxy proxy, final String url, final String username, final String password, final String categoryName) throws IllegalArgumentException, EventProxyException {
        block4: {
            if (proxy == null || url == null || username == null || password == null || categoryName == null) {
                throw new IllegalArgumentException("Cannot take null parameters.");
            }
            try {
                Logging.withPrefix((String)LOGGING_PREFIX, (Callable)new Callable<Void>(){

                    @Override
                    public Void call() throws Exception {
                        EventBuilder bldr = new EventBuilder("uei.opennms.org/internal/rtc/subscribe", "RTCPostSubscriber");
                        bldr.setHost("host");
                        bldr.addParam("url", url);
                        bldr.addParam("user", username);
                        bldr.addParam("passwd", password);
                        bldr.addParam("catlabel", categoryName);
                        proxy.send(bldr.getEvent());
                        LOG.info("Subscription requested for {} to {}", (Object)username, (Object)url);
                        return null;
                    }
                });
            }
            catch (Throwable e) {
                if (e instanceof IllegalArgumentException) {
                    throw (IllegalArgumentException)e;
                }
                if (!(e instanceof EventProxyException)) break block4;
                throw (EventProxyException)e;
            }
        }
    }

    protected static void sendUnsubscribeEvent(final EventProxy proxy, final String url) throws IllegalArgumentException, EventProxyException {
        block4: {
            if (proxy == null || url == null) {
                throw new IllegalArgumentException("Cannot take null parameters.");
            }
            try {
                Logging.withPrefix((String)LOGGING_PREFIX, (Callable)new Callable<Void>(){

                    @Override
                    public Void call() throws Exception {
                        EventBuilder bldr = new EventBuilder("uei.opennms.org/internal/rtc/unsubscribe", "RTCPostSubscriber");
                        bldr.setHost("host");
                        bldr.addParam("url", url);
                        proxy.send(bldr.getEvent());
                        LOG.info("Unsubscription sent for {}", (Object)url);
                        return null;
                    }
                });
            }
            catch (Throwable e) {
                if (e instanceof IllegalArgumentException) {
                    throw (IllegalArgumentException)e;
                }
                if (!(e instanceof EventProxyException)) break block4;
                throw (EventProxyException)e;
            }
        }
    }

    protected void subscribe(String categoryName) throws IllegalArgumentException, EventProxyException {
        String baseUrl;
        String passwordProperty;
        String username = LOGGING_PREFIX;
        String password = LOGGING_PREFIX;
        if (categoryName == null) {
            throw new IllegalArgumentException("categoryName cannot be null");
        }
        String usernameProperty = Vault.getProperty((String)"opennms.rtc-client.http-post.username");
        if (usernameProperty != null) {
            username = usernameProperty;
        }
        if ((passwordProperty = Vault.getProperty((String)"opennms.rtc-client.http-post.password")) != null) {
            password = passwordProperty;
        }
        if ((baseUrl = Vault.getProperty((String)"opennms.rtc-client.http-post.base-url")) == null) {
            baseUrl = "http://localhost:8080/opennms/rtc/post";
        }
        String url = baseUrl.endsWith("/") ? baseUrl + Util.encode(categoryName) : baseUrl + "/" + Util.encode(categoryName);
        final String logUrl = url;
        final String logUsername = username;
        Logging.withPrefix((String)LOGGING_PREFIX, (Runnable)new Runnable(){

            @Override
            public void run() {
                LOG.debug("RTCPostSubscriber initialized: url={}, user={}", (Object)logUrl, (Object)logUsername);
            }
        });
        RTCPostSubscriber.sendSubscribeEvent(this.m_proxy, url, username, password, categoryName);
    }

    public void unsubscribe(String url) throws IllegalArgumentException, EventProxyException {
        RTCPostSubscriber.sendUnsubscribeEvent(this.m_proxy, url);
    }

    public static void subscribeAll(final String viewName) {
        if (viewName == null) {
            throw new IllegalArgumentException("Cannot take null parameters.");
        }
        try {
            Logging.withPrefix((String)LOGGING_PREFIX, (Callable)new Callable<Void>(){

                @Override
                public Void call() throws Exception {
                    ViewsDisplayFactory.init();
                    ViewsDisplayFactory factory = ViewsDisplayFactory.getInstance();
                    View view = factory.getView(viewName);
                    if (view != null) {
                        RTCPostSubscriber subscriber = new RTCPostSubscriber();
                        for (Section section : view.getSections()) {
                            for (String categoryName : section.getCategories()) {
                                subscriber.subscribe(categoryName);
                                LOG.info("Sent subscription event to RTC for category: {}", (Object)categoryName);
                            }
                        }
                    }
                    return null;
                }
            });
        }
        catch (Throwable e) {
            e.printStackTrace();
        }
    }
}

