/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.web.category;

import java.net.InetAddress;
import java.util.ArrayList;
import java.util.List;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlElementWrapper;
import javax.xml.bind.annotation.XmlRootElement;
import org.apache.commons.lang.builder.EqualsBuilder;
import org.apache.commons.lang.builder.ToStringBuilder;
import org.opennms.core.utils.InetAddressUtils;
import org.opennms.netmgt.model.OnmsIpInterface;
import org.opennms.web.category.AvailabilityMonitoredService;

@XmlRootElement(name="ipinterface")
@XmlAccessorType(value=XmlAccessType.NONE)
public class AvailabilityIpInterface {
    @XmlAttribute(name="id")
    private final Integer m_id;
    @XmlAttribute(name="address")
    private final String m_address;
    @XmlAttribute(name="availability")
    private final double m_availability;
    @XmlElementWrapper(name="services")
    @XmlElement(name="service")
    private final List<AvailabilityMonitoredService> m_services = new ArrayList<AvailabilityMonitoredService>();

    public AvailabilityIpInterface() {
        this.m_id = -1;
        this.m_address = "";
        this.m_availability = -1.0;
    }

    public AvailabilityIpInterface(OnmsIpInterface iface, double availability) {
        this.m_id = iface.getId();
        this.m_address = InetAddressUtils.str((InetAddress)iface.getIpAddress());
        this.m_availability = availability;
    }

    public void addService(AvailabilityMonitoredService service) {
        this.m_services.add(service);
    }

    public Integer getId() {
        return this.m_id;
    }

    public double getAvailability() {
        return this.m_availability;
    }

    public String getAddress() {
        return this.m_address;
    }

    public List<AvailabilityMonitoredService> getServices() {
        return this.m_services;
    }

    public String toString() {
        return new ToStringBuilder((Object)this).append("id", (Object)this.getId()).append("availability", this.getAvailability()).append("address", (Object)this.getAddress()).append("services", this.getServices()).toString();
    }

    public boolean equals(Object o) {
        if (!(o instanceof AvailabilityIpInterface)) {
            return false;
        }
        AvailabilityIpInterface that = (AvailabilityIpInterface)o;
        return new EqualsBuilder().append((Object)this.getId(), (Object)that.getId()).append(this.getAvailability(), that.getAvailability()).append((Object)this.getAddress(), (Object)that.getAddress()).append(this.getServices(), that.getServices()).isEquals();
    }
}

