/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.flows.classification;

import com.google.common.primitives.Ints;
import com.google.common.primitives.Longs;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.Objects;
import org.apache.commons.lang3.ArrayUtils;
import org.opennms.core.network.IPAddress;

public abstract class IpAddr
implements Comparable<IpAddr> {
    public static IpAddr of(String dottedNotation) {
        if (dottedNotation == null) {
            return null;
        }
        try {
            return IpAddr.of(InetAddress.getByName(dottedNotation));
        }
        catch (UnknownHostException e) {
            throw new IllegalArgumentException("Invalid IPAddress " + dottedNotation, e);
        }
    }

    public static IpAddr of(InetAddress addr) {
        byte[] bytes = addr.getAddress();
        if (bytes.length == 4) {
            return new Ip4Addr(Ints.fromBytes((byte)bytes[0], (byte)bytes[1], (byte)bytes[2], (byte)bytes[3]));
        }
        if (bytes.length == 16) {
            return new Ip6Addr(Longs.fromBytes((byte)bytes[0], (byte)bytes[1], (byte)bytes[2], (byte)bytes[3], (byte)bytes[4], (byte)bytes[5], (byte)bytes[6], (byte)bytes[7]), Longs.fromBytes((byte)bytes[8], (byte)bytes[9], (byte)bytes[10], (byte)bytes[11], (byte)bytes[12], (byte)bytes[13], (byte)bytes[14], (byte)bytes[15]));
        }
        throw new RuntimeException("unexpected number of bytes of ip address - addr: " + addr);
    }

    public abstract IpAddr inc();

    public static final class Ip4Addr
    extends IpAddr {
        private final int value;

        public Ip4Addr(int value) {
            this.value = value;
        }

        @Override
        public int compareTo(IpAddr other) {
            if (other instanceof Ip6Addr) {
                return -1;
            }
            Ip4Addr o = (Ip4Addr)other;
            return Integer.compareUnsigned(this.value, o.value);
        }

        @Override
        public IpAddr inc() {
            if (this.value + 1 == 0) {
                throw new RuntimeException("IP address can no more; limit reached");
            }
            return new Ip4Addr(this.value + 1);
        }

        public String toString() {
            return new IPAddress(Ints.toByteArray((int)this.value)).toString();
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Ip4Addr ip4Addr = (Ip4Addr)o;
            return this.value == ip4Addr.value;
        }

        public int hashCode() {
            return Objects.hash(this.value);
        }
    }

    public static final class Ip6Addr
    extends IpAddr {
        private final long high;
        private final long low;

        public Ip6Addr(long high, long low) {
            this.high = high;
            this.low = low;
        }

        @Override
        public int compareTo(IpAddr other) {
            if (other instanceof Ip4Addr) {
                return 1;
            }
            Ip6Addr o = (Ip6Addr)other;
            return this.high != o.high ? Long.compareUnsigned(this.high, o.high) : Long.compareUnsigned(this.low, o.low);
        }

        @Override
        public IpAddr inc() {
            if (this.low + 1L == 0L) {
                if (this.high + 1L == 0L) {
                    throw new RuntimeException("IP address can no more; limit reached");
                }
                return new Ip6Addr(this.high + 1L, 0L);
            }
            return new Ip6Addr(this.high, this.low + 1L);
        }

        public String toString() {
            return new IPAddress(ArrayUtils.addAll((byte[])Longs.toByteArray((long)this.high), (byte[])Longs.toByteArray((long)this.low))).toString();
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Ip6Addr ip6Addr = (Ip6Addr)o;
            return this.high == ip6Addr.high && this.low == ip6Addr.low;
        }

        public int hashCode() {
            return Objects.hash(this.high, this.low);
        }
    }
}

